/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;

public class PaimonCharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveCharObjectInspector,
WriteableObjectInspector {
    private final int len;

    public PaimonCharObjectInspector(int len) {
        super((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)len));
        this.len = len;
    }

    public HiveChar getPrimitiveJavaObject(Object o) {
        return o == null ? null : new HiveChar(o.toString(), this.len);
    }

    public HiveCharWritable getPrimitiveWritableObject(Object o) {
        HiveChar hiveChar = this.getPrimitiveJavaObject(o);
        return hiveChar == null ? null : new HiveCharWritable(hiveChar);
    }

    public Object copyObject(Object o) {
        if (o instanceof HiveChar) {
            HiveChar hiveChar = (HiveChar)o;
            return new HiveChar(hiveChar, this.len);
        }
        if (o instanceof BinaryString) {
            return BinaryString.fromString(o.toString());
        }
        return o;
    }

    @Override
    public BinaryString convert(Object value) {
        return value == null ? null : BinaryString.fromString(value.toString());
    }
}

