/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullCompactedStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FullCompactedStartingScanner.class);
    private final int deltaCommits;

    public FullCompactedStartingScanner(SnapshotManager snapshotManager, int deltaCommits) {
        super(snapshotManager);
        this.deltaCommits = deltaCommits;
        this.startingSnapshotId = this.pick();
    }

    @Nullable
    protected Long pick() {
        return this.snapshotManager.pickOrLatest(this::picked);
    }

    private boolean picked(Snapshot snapshot) {
        long identifier = snapshot.commitIdentifier();
        return snapshot.commitKind() == Snapshot.CommitKind.COMPACT && FullCompactedStartingScanner.isFullCompactedIdentifier(identifier, this.deltaCommits);
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long startingSnapshotId = this.pick();
        if (startingSnapshotId == null) {
            startingSnapshotId = this.snapshotManager.latestSnapshotId();
            if (startingSnapshotId == null) {
                LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
                return new StartingScanner.NoSnapshot();
            }
            LOG.debug("No compact snapshot found, reading from the latest snapshot {}.", (Object)startingSnapshotId);
        }
        return StartingScanner.fromPlan(snapshotReader.withMode(ScanMode.ALL).withSnapshot(startingSnapshotId).read());
    }

    public static boolean isFullCompactedIdentifier(long identifier, int deltaCommits) {
        return identifier % (long)deltaCommits == 0L || identifier == Long.MAX_VALUE;
    }
}

