/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.messages;

import java.util.Random;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.service.messages.KvRequest;
import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBuf;
import org.apache.paimon.shade.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class KvRequestTest {
    @Test
    void testSerialization() {
        KvRequest request = KvRequestTest.random();
        byte[] serialize = request.serialize();
        ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.heapBuffer();
        byteBuf.writeBytes(serialize);
        KvRequest newRequest = new KvRequest.KvRequestDeserializer().deserializeMessage(byteBuf);
        Assertions.assertThat((Object)newRequest).isEqualTo((Object)request);
    }

    public static BinaryRow row(int i) {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeInt(0, i);
        writer.complete();
        return row;
    }

    public static KvRequest random() {
        Random rnd = new Random();
        BinaryRow[] keys = new BinaryRow[rnd.nextInt(100)];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = KvRequestTest.row(rnd.nextInt());
        }
        return new KvRequest(KvRequestTest.row(rnd.nextInt()), rnd.nextInt(1000), keys);
    }
}

