/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.AbstractColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReader;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;

public class IntColumnReader
extends AbstractColumnReader<WritableIntVector> {
    public IntColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.INT32);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableIntVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        this.readIntegers(n, column, rowId);
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setInt(rowId + i, this.readInteger());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableIntVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setInt(i, this.dictionary.decodeToInt(dictionaryIds.getInt(i)));
        }
    }

    private int readInteger() {
        return this.readDataBuffer(4).getInt();
    }

    private void readIntegers(int total, WritableIntVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.readDataBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setIntsFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setInt(rowId + i, buffer.getInt());
            }
        }
    }
}

