/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringStartsWith;

public class SparkFilterConverter {
    public static final List<String> SUPPORT_FILTERS = Arrays.asList("EqualTo", "EqualNullSafe", "GreaterThan", "GreaterThanOrEqual", "LessThan", "LessThanOrEqual", "In", "IsNull", "IsNotNull", "And", "Or", "Not", "StringStartsWith");
    private final RowType rowType;
    private final PredicateBuilder builder;

    public SparkFilterConverter(RowType rowType) {
        this.rowType = rowType;
        this.builder = new PredicateBuilder(rowType);
    }

    public Predicate convertIgnoreFailure(Filter filter) {
        try {
            return this.convert(filter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Predicate convert(Filter filter) {
        if (filter instanceof EqualTo) {
            EqualTo eq2 = (EqualTo)filter;
            int index = this.fieldIndex(eq2.attribute());
            Object literal = this.convertLiteral(index, eq2.value());
            return this.builder.equal(index, literal);
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe eq3 = (EqualNullSafe)filter;
            if (eq3.value() == null) {
                return this.builder.isNull(this.fieldIndex(eq3.attribute()));
            }
            int index = this.fieldIndex(eq3.attribute());
            Object literal = this.convertLiteral(index, eq3.value());
            return this.builder.equal(index, literal);
        }
        if (filter instanceof GreaterThan) {
            GreaterThan gt = (GreaterThan)filter;
            int index = this.fieldIndex(gt.attribute());
            Object literal = this.convertLiteral(index, gt.value());
            return this.builder.greaterThan(index, literal);
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual gt = (GreaterThanOrEqual)filter;
            int index = this.fieldIndex(gt.attribute());
            Object literal = this.convertLiteral(index, gt.value());
            return this.builder.greaterOrEqual(index, literal);
        }
        if (filter instanceof LessThan) {
            LessThan lt = (LessThan)filter;
            int index = this.fieldIndex(lt.attribute());
            Object literal = this.convertLiteral(index, lt.value());
            return this.builder.lessThan(index, literal);
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lt = (LessThanOrEqual)filter;
            int index = this.fieldIndex(lt.attribute());
            Object literal = this.convertLiteral(index, lt.value());
            return this.builder.lessOrEqual(index, literal);
        }
        if (filter instanceof In) {
            In in = (In)filter;
            int index = this.fieldIndex(in.attribute());
            return this.builder.in(index, Arrays.stream(in.values()).map(v -> this.convertLiteral(index, v)).collect(Collectors.toList()));
        }
        if (filter instanceof IsNull) {
            return this.builder.isNull(this.fieldIndex(((IsNull)filter).attribute()));
        }
        if (filter instanceof IsNotNull) {
            return this.builder.isNotNull(this.fieldIndex(((IsNotNull)filter).attribute()));
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return PredicateBuilder.and(this.convert(and.left()), this.convert(and.right()));
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return PredicateBuilder.or(this.convert(or.left()), this.convert(or.right()));
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return this.convert(not.child()).negate().orElseThrow(UnsupportedOperationException::new);
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith startsWith = (StringStartsWith)filter;
            int index = this.fieldIndex(startsWith.attribute());
            Object literal = this.convertLiteral(index, (Object)startsWith.value());
            return this.builder.startsWith(index, literal);
        }
        throw new UnsupportedOperationException(filter + " is unsupported. Support Filters: " + SUPPORT_FILTERS);
    }

    public Object convertLiteral(String field, Object value) {
        return this.convertLiteral(this.fieldIndex(field), value);
    }

    private int fieldIndex(String field) {
        int index = this.rowType.getFieldIndex(field);
        if (index == -1) {
            throw new UnsupportedOperationException(String.format("Nested field '%s' is unsupported.", field));
        }
        return index;
    }

    private Object convertLiteral(int index, Object value) {
        DataType type = this.rowType.getTypeAt(index);
        return PredicateBuilder.convertJavaObject(type, value);
    }
}

