/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.spark.PaimonPartitionManagement;
import org.apache.paimon.spark.PaimonScanBuilder;
import org.apache.paimon.spark.SparkSource;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.SparkWriteBuilder;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkTable
implements Table,
SupportsRead,
SupportsWrite,
PaimonPartitionManagement {
    private final org.apache.paimon.table.Table table;

    public SparkTable(org.apache.paimon.table.Table table) {
        this.table = table;
    }

    public org.apache.paimon.table.Table getTable() {
        return this.table;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        org.apache.paimon.table.Table newTable = this.table.copy(options.asCaseSensitiveMap());
        return new PaimonScanBuilder(newTable);
    }

    public String name() {
        return this.table.name();
    }

    public StructType schema() {
        return SparkTypeUtils.fromPaimonRowType(this.table.rowType());
    }

    public Set<TableCapability> capabilities() {
        HashSet<TableCapability> capabilities = new HashSet<TableCapability>();
        capabilities.add(TableCapability.BATCH_READ);
        capabilities.add(TableCapability.V1_BATCH_WRITE);
        capabilities.add(TableCapability.OVERWRITE_BY_FILTER);
        capabilities.add(TableCapability.OVERWRITE_DYNAMIC);
        capabilities.add(TableCapability.MICRO_BATCH_READ);
        return capabilities;
    }

    public Transform[] partitioning() {
        return (Transform[])this.table.partitionKeys().stream().map(FieldReference::apply).map(IdentityTransform::apply).toArray(Transform[]::new);
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        try {
            return new SparkWriteBuilder((FileStoreTable)this.table, Options.fromMap((Map<String, String>)info.options()));
        }
        catch (Exception e) {
            throw new RuntimeException("Only FileStoreTable can be written.");
        }
    }

    public Map<String, String> properties() {
        if (this.table instanceof DataTable) {
            HashMap<String, String> properties = new HashMap<String, String>(((DataTable)this.table).coreOptions().toMap());
            if (!this.table.primaryKeys().isEmpty()) {
                properties.put(CoreOptions.PRIMARY_KEY.key(), String.join((CharSequence)",", this.table.primaryKeys()));
            }
            properties.put("provider", SparkSource.NAME());
            if (this.table.comment().isPresent()) {
                properties.put("comment", this.table.comment().get());
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkTable that = (SparkTable)o;
        return Objects.equals(this.table, that.table);
    }
}

