/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkReadTestBase;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.VarCharType;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SparkReadITCase
extends SparkReadTestBase {
    @Test
    public void testNormal() {
        this.innerTestSimpleType((Dataset<Row>)spark.table("t1"));
        this.innerTestNestedType((Dataset<Row>)spark.table("t2"));
    }

    @Test
    public void testFilterPushDown() {
        this.innerTestSimpleTypeFilterPushDown((Dataset<Row>)spark.table("t1"));
        this.innerTestNestedTypeFilterPushDown((Dataset<Row>)spark.table("t2"));
    }

    @Test
    public void testCatalogNormal() {
        this.innerTestSimpleType((Dataset<Row>)spark.table("t1"));
        this.innerTestNestedType((Dataset<Row>)spark.table("t2"));
    }

    @Test
    public void testSnapshotsTable() {
        List rows = spark.table("`t1$snapshots`").select("snapshot_id", new String[]{"schema_id", "commit_user", "commit_kind"}).collectAsList();
        String commitUser = ((Row)rows.get(0)).getString(2);
        String rowString = String.format("[[1,0,%s,APPEND]]", commitUser);
        Assertions.assertThat((String)rows.toString()).isEqualTo(rowString);
        spark.sql("CREATE TABLE schemasTable (\na BIGINT,\nb STRING)\nTBLPROPERTIES ('primary-key' = 'a')");
        spark.sql("ALTER TABLE schemasTable ADD COLUMN c STRING");
        List schemas = spark.table("`schemasTable$schemas`").collectAsList();
        List fieldsList = schemas.stream().map(row -> row.get(1)).collect(Collectors.toList());
        Assertions.assertThat(fieldsList.stream().map(Object::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"[{\"id\":0,\"name\":\"a\",\"type\":\"BIGINT NOT NULL\"},{\"id\":1,\"name\":\"b\",\"type\":\"STRING\"}]", "[{\"id\":0,\"name\":\"a\",\"type\":\"BIGINT NOT NULL\"},{\"id\":1,\"name\":\"b\",\"type\":\"STRING\"},{\"id\":2,\"name\":\"c\",\"type\":\"STRING\"}]"});
    }

    @Test
    public void testSnapshotsTableWithRecordCount() {
        List rows = spark.table("`t1$snapshots`").select("snapshot_id", new String[]{"total_record_count", "delta_record_count", "changelog_record_count"}).collectAsList();
        Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,3,3,0]]");
    }

    @Test
    public void testManifestsTable() {
        List rows = spark.table("`t1$manifests`").select("schema_id", new String[]{"file_name", "file_size"}).collectAsList();
        Long schemaId = ((Row)rows.get(0)).getLong(0);
        String fileName = ((Row)rows.get(0)).getString(1);
        Long fileSize = ((Row)rows.get(0)).getLong(2);
        Assertions.assertThat((Long)schemaId).isEqualTo(0L);
        Assertions.assertThat((String)fileName).startsWith((CharSequence)"manifest");
        Assertions.assertThat((Long)fileSize).isGreaterThan(0L);
    }

    @Test
    public void testManifestsTableWithRecordCount() {
        List rows = spark.table("`t1$manifests`").select("num_added_files", new String[]{"num_deleted_files"}).collectAsList();
        Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,0]]");
    }

    @Test
    public void testCatalogFilterPushDown() {
        this.innerTestSimpleTypeFilterPushDown((Dataset<Row>)spark.table("t1"));
        this.innerTestNestedTypeFilterPushDown((Dataset<Row>)spark.table("t2"));
    }

    @Test
    public void testDefaultNamespace() {
        Assertions.assertThat((String)spark.sql("SHOW CURRENT NAMESPACE").collectAsList().toString()).isEqualTo("[[paimon,default]]");
    }

    @Test
    public void testCreateTable() {
        spark.sql("CREATE TABLE testCreateTable(\na BIGINT,\nb VARCHAR(10),\nc CHAR(10))");
        Assertions.assertThat((String)spark.sql("SELECT fields FROM `testCreateTable$schemas`").collectAsList().toString()).isEqualTo("[[[{\"id\":0,\"name\":\"a\",\"type\":\"BIGINT\"},{\"id\":1,\"name\":\"b\",\"type\":\"VARCHAR(10)\"},{\"id\":2,\"name\":\"c\",\"type\":\"CHAR(10)\"}]]]");
    }

    @Test
    public void testCreateTableAs() {
        spark.sql("CREATE TABLE testCreateTable(\na BIGINT,\nb VARCHAR(10),\nc CHAR(10))");
        spark.sql("INSERT INTO testCreateTable VALUES(1,'a','b')");
        spark.sql("CREATE TABLE testCreateTableAs AS SELECT * FROM testCreateTable");
        List result = spark.sql("SELECT * FROM testCreateTableAs").collectAsList();
        Assertions.assertThat(result.stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[1,a,b]"});
        spark.sql("CREATE TABLE partitionedTable (\na BIGINT,\nb STRING,\nc STRING)\nPARTITIONED BY (a,b)");
        spark.sql("INSERT INTO partitionedTable VALUES(1,'aaa','bbb')");
        spark.sql("CREATE TABLE partitionedTableAs PARTITIONED BY (a) AS SELECT * FROM partitionedTable");
        Assertions.assertThat((String)spark.sql("SHOW CREATE TABLE partitionedTableAs").collectAsList().toString()).isEqualTo(String.format("[[%sPARTITIONED BY (a)\nTBLPROPERTIES (\n  'path' = '%s')\n]]", this.showCreateString("partitionedTableAs", "a BIGINT", "b STRING", "c STRING"), new Path(warehousePath, "default.db/partitionedTableAs")));
        List resultPartition = spark.sql("SELECT * FROM partitionedTableAs").collectAsList();
        Assertions.assertThat(resultPartition.stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[1,aaa,bbb]"});
        spark.sql("CREATE TABLE testTable(\na BIGINT,\nb VARCHAR(10),\nc CHAR(10))\n TBLPROPERTIES(\n 'file.format' = 'orc'\n)");
        spark.sql("INSERT INTO testTable VALUES(1,'a','b')");
        spark.sql("CREATE TABLE testTableAs TBLPROPERTIES ('file.format' = 'parquet') AS SELECT * FROM testTable");
        Assertions.assertThat((String)spark.sql("SHOW CREATE TABLE testTableAs").collectAsList().toString()).isEqualTo(String.format("[[%sTBLPROPERTIES (\n  'file.format' = 'parquet',\n  'path' = '%s')\n]]", this.showCreateString("testTableAs", "a BIGINT", "b STRING", "c STRING"), new Path(warehousePath, "default.db/testTableAs")));
        List resultProp = spark.sql("SELECT * FROM testTableAs").collectAsList();
        Assertions.assertThat(resultProp.stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[1,a,b]"});
        spark.sql("CREATE TABLE t_pk (\na BIGINT,\nb STRING,\nc STRING\n) TBLPROPERTIES (\n  'primary-key' = 'a,b'\n)\nCOMMENT 'table comment'");
        spark.sql("INSERT INTO t_pk VALUES(1,'aaa','bbb')");
        spark.sql("CREATE TABLE t_pk_as TBLPROPERTIES ('primary-key' = 'a') AS SELECT * FROM t_pk");
        Assertions.assertThat((String)spark.sql("SHOW CREATE TABLE t_pk_as").collectAsList().toString()).isEqualTo(String.format("[[%sTBLPROPERTIES (\n  'path' = '%s',\n  'primary-key' = 'a')\n]]", this.showCreateString("t_pk_as", "a BIGINT", "b STRING", "c STRING"), new Path(warehousePath, "default.db/t_pk_as")));
        List resultPk = spark.sql("SELECT * FROM t_pk_as").collectAsList();
        Assertions.assertThat(resultPk.stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[1,aaa,bbb]"});
        spark.sql("CREATE TABLE t_all (\n    user_id BIGINT,\n    item_id BIGINT,\n    behavior STRING,\n    dt STRING,\n    hh STRING\n) PARTITIONED BY (dt, hh) TBLPROPERTIES (\n    'primary-key' = 'dt,hh,user_id'\n)");
        spark.sql("INSERT INTO t_all VALUES(1,2,'bbb','2020-01-01','12')");
        spark.sql("CREATE TABLE t_all_as PARTITIONED BY (dt) TBLPROPERTIES ('primary-key' = 'dt,hh') AS SELECT * FROM t_all");
        Assertions.assertThat((String)spark.sql("SHOW CREATE TABLE t_all_as").collectAsList().toString()).isEqualTo(String.format("[[%sPARTITIONED BY (dt)\nTBLPROPERTIES (\n  'path' = '%s',\n  'primary-key' = 'dt,hh')\n]]", this.showCreateString("t_all_as", "user_id BIGINT", "item_id BIGINT", "behavior STRING", "dt STRING", "hh STRING"), new Path(warehousePath, "default.db/t_all_as")));
        List resultAll = spark.sql("SELECT * FROM t_all_as").collectAsList();
        Assertions.assertThat(resultAll.stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[1,2,bbb,2020-01-01,12]"});
    }

    @Test
    public void testConflictOption() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("CREATE TABLE T (a INT) TBLPROPERTIES ('changelog-producer' = 'input')")).getRootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Can not set changelog-producer on table without primary keys");
        spark.sql("CREATE TABLE T (a INT)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("ALTER TABLE T SET TBLPROPERTIES('changelog-producer' 'input')")).getRootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Can not set changelog-producer on table without primary keys");
    }

    @Test
    public void testShowTablesSorted() {
        spark.sql("create table t3(id int, name string)");
        spark.sql("create table t4(id int, name string)");
        List tables = spark.sql("SHOW TABLES").collectAsList();
        Assertions.assertThat((String)tables.toString()).isEqualTo("[[default,t1,false], [default,t2,false], [default,t3,false], [default,t4,false]]");
    }

    @Test
    public void testCreateTableWithNullablePk() {
        spark.sql("CREATE TABLE PkTable (\na BIGINT,\nb STRING)\nTBLPROPERTIES ('primary-key' = 'a')");
        Path tablePath = new Path(warehousePath, "default.db/PkTable");
        TableSchema schema = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)tablePath).schema();
        Assertions.assertThat((boolean)schema.logicalRowType().getTypeAt(0).isNullable()).isFalse();
    }

    @Test
    public void testDescribeTable() {
        spark.sql("CREATE TABLE PartitionedTable (\na BIGINT,\nb STRING)\nPARTITIONED BY (a)\n");
        Assertions.assertThat((String)spark.sql("DESCRIBE PartitionedTable").collectAsList().toString()).isEqualTo("[[a,bigint,null], [b,string,null], [# Partition Information,,], [# col_name,data_type,comment], [a,bigint,null]]");
    }

    @Test
    public void testShowCreateTable() {
        spark.sql("CREATE TABLE tbl (\n  a INT COMMENT 'a comment',\n  b STRING\n) USING paimon\nPARTITIONED BY (b)\nCOMMENT 'tbl comment'\nTBLPROPERTIES (\n  'primary-key' = 'a,b',\n  'k1' = 'v1'\n)");
        Assertions.assertThat((String)spark.sql("SHOW CREATE TABLE tbl").collectAsList().toString()).isEqualTo(String.format("[[%sPARTITIONED BY (b)\nCOMMENT 'tbl comment'\nTBLPROPERTIES (\n  'k1' = 'v1',\n  'path' = '%s',\n  'primary-key' = 'a,b')\n]]", this.showCreateString("tbl", "a INT COMMENT 'a comment'", "b STRING"), new Path(warehousePath, "default.db/tbl")));
    }

    @Test
    public void testShowTableProperties() {
        spark.sql("CREATE TABLE tbl (\n  a INT)\nTBLPROPERTIES (\n  'k1' = 'v1',\n  'k2' = 'v2'\n)");
        Assertions.assertThat(spark.sql("SHOW TBLPROPERTIES tbl").collectAsList().stream().map(Row::toString).collect(Collectors.toList())).contains((Object[])new String[]{"[k1,v1]", "[k2,v2]"});
    }

    @Test
    public void testCreateTableWithNonexistentPk() {
        spark.sql("USE paimon");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("CREATE TABLE default.PartitionedPkTable (\na BIGINT,\nb STRING,\nc DOUBLE) USING paimon\nCOMMENT 'table comment'\nPARTITIONED BY (b)\nTBLPROPERTIES ('primary-key' = 'd')")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Table column [a, b, c] should include all primary key constraint [d]");
    }

    @Test
    public void testCreateTableWithNonexistentPartition() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("CREATE TABLE PartitionedPkTable (\na BIGINT,\nb STRING,\nc DOUBLE)\nPARTITIONED BY (d)\nTBLPROPERTIES ('primary-key' = 'a')")).isInstanceOf(AnalysisException.class)).hasMessageContaining("Couldn't find column d");
    }

    @Test
    public void testCreateAndDropTable() {
        this.innerTest("MyTable1", true, true);
        this.innerTest("MyTable2", true, false);
        this.innerTest("MyTable3", false, false);
        this.innerTest("MyTable4", false, false);
        this.innerTest("MyTable5", false, true);
        this.innerTest("MyTable6", false, true);
    }

    private void innerTest(String tableName, boolean hasPk, boolean partitioned) {
        String ddlTemplate = "CREATE TABLE default.%s (\norder_id BIGINT NOT NULL comment 'order_id',\nbuyer_id BIGINT NOT NULL COMMENT 'buyer_id',\ncoupon_info ARRAY<STRING> NOT NULL COMMENT 'coupon_info',\norder_amount DOUBLE NOT NULL COMMENT 'order_amount',\ndt STRING NOT NULL COMMENT 'dt',\nhh STRING NOT NULL COMMENT 'hh')\nCOMMENT 'table comment'\n%s\nTBLPROPERTIES (%s)";
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        tableProperties.put("foo", "bar");
        tableProperties.put("file.format", "avro");
        List<String> columns = Arrays.asList("order_id", "buyer_id", "coupon_info", "order_amount", "dt", "hh");
        List<DataType> types = Arrays.asList(new BigIntType(false), new BigIntType(false), new ArrayType(false, (DataType)VarCharType.STRING_TYPE), new DoubleType(false), VarCharType.stringType((boolean)false), VarCharType.stringType((boolean)false));
        List fields = IntStream.range(0, columns.size()).boxed().map(i -> new DataField(i.intValue(), (String)columns.get((int)i), (DataType)types.get((int)i), (String)columns.get((int)i))).collect(Collectors.toList());
        String partitionStr = "";
        if (hasPk) {
            tableProperties.put("primary-key", partitioned ? "order_id,dt,hh" : "order_id");
        }
        if (partitioned) {
            partitionStr = "PARTITIONED BY (dt, hh)";
        }
        String ddl = String.format(ddlTemplate, tableName, partitionStr, tableProperties.entrySet().stream().map(entry -> String.format("'%s' = '%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")));
        spark.sql(ddl);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql(ddl)).isInstanceOf(TableAlreadyExistsException.class)).hasMessageContaining(String.format("Cannot create table or view `default`.`%s` because it already exists", tableName));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql(ddl.replace("default", "foo"))).isInstanceOf(NoSuchNamespaceException.class)).hasMessageContaining("The schema `foo` cannot be found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql(String.format("ALTER TABLE %s UNSET TBLPROPERTIES('primary-key')", tableName))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Alter primary key is not supported");
        Path tablePath = new Path(warehousePath, String.format("default.db/%s", tableName));
        TableSchema schema = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)tablePath).schema();
        Assertions.assertThat((List)schema.fields()).containsExactlyElementsOf(fields);
        Assertions.assertThat((Map)schema.options()).containsEntry((Object)"foo", (Object)"bar");
        Assertions.assertThat((Map)schema.options()).doesNotContainKey((Object)"primary-key");
        if (hasPk) {
            if (partitioned) {
                Assertions.assertThat((List)schema.primaryKeys()).containsExactly((Object[])new String[]{"order_id", "dt", "hh"});
            } else {
                Assertions.assertThat((List)schema.primaryKeys()).containsExactly((Object[])new String[]{"order_id"});
            }
            Assertions.assertThat((List)schema.trimmedPrimaryKeys()).containsOnly((Object[])new String[]{"order_id"});
        } else {
            Assertions.assertThat((List)schema.primaryKeys()).isEmpty();
        }
        if (partitioned) {
            Assertions.assertThat((List)schema.partitionKeys()).containsExactly((Object[])new String[]{"dt", "hh"});
        } else {
            Assertions.assertThat((List)schema.partitionKeys()).isEmpty();
        }
        Assertions.assertThat((String)schema.comment()).isEqualTo("table comment");
        SparkReadITCase.writeTable(tableName, "(1L, 10L, array('loyalty_discount', 'shipping_discount'), 199.0d, '2022-07-20', '12')");
        Dataset dataset = spark.read().format("paimon").load(tablePath.toString());
        Assertions.assertThat((String)dataset.select("order_id", new String[]{"buyer_id", "dt"}).collectAsList().toString()).isEqualTo("[[1,10,2022-07-20]]");
        Assertions.assertThat((String)dataset.select("coupon_info", new String[0]).collectAsList().toString()).isEqualTo("[[WrappedArray(loyalty_discount, shipping_discount)]]");
        Assertions.assertThat((String)spark.sql(String.format("SHOW TABLES IN paimon.default LIKE '%s'", tableName)).select("namespace", new String[]{"tableName"}).collectAsList().toString()).isEqualTo(String.format("[[default,%s]]", tableName));
        spark.sql(String.format("DROP TABLE %s", tableName));
        Assertions.assertThat((String)spark.sql(String.format("SHOW TABLES IN paimon.default LIKE '%s'", tableName)).select("namespace", new String[]{"tableName"}).collectAsList().toString()).isEqualTo("[]");
        Assertions.assertThat((File)new File(tablePath.toUri())).doesNotExist();
    }

    @Test
    public void testCreateAndDropNamespace() {
        spark.sql("CREATE NAMESPACE bar");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("CREATE NAMESPACE bar")).isInstanceOf(NamespaceAlreadyExistsException.class)).hasMessageContaining("Cannot create schema `bar` because it already exists");
        Assertions.assertThat(spark.sql("SHOW NAMESPACES").collectAsList().stream().map(row -> row.getString(0)).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"bar", "default"});
        Path nsPath = new Path(warehousePath, "bar.db");
        Assertions.assertThat((File)new File(nsPath.toUri())).exists();
        spark.sql("DROP NAMESPACE bar");
        Assertions.assertThat((String)spark.sql("SHOW NAMESPACES").collectAsList().toString()).isEqualTo("[[default]]");
        Assertions.assertThat((File)new File(nsPath.toUri())).doesNotExist();
    }

    private void innerTestNestedType(Dataset<Row> dataset) {
        List results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,WrappedArray(AAA, BBB),[[1.0,WrappedArray(null)],1]], [2,WrappedArray(CCC, DDD),[[null,WrappedArray(true)],null]], [3,WrappedArray(null, null),[[2.0,WrappedArray(true, false)],2]], [4,WrappedArray(null, EEE),[[3.0,WrappedArray(true, false, true)],3]]]");
        results = dataset.select("a", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1], [2], [3], [4]]");
        results = dataset.select("c.c1", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[[1.0,WrappedArray(null)]], [[null,WrappedArray(true)]], [[2.0,WrappedArray(true, false)]], [[3.0,WrappedArray(true, false, true)]]]");
        results = dataset.select("c.c2", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1], [null], [2], [3]]");
        results = dataset.select("c.c1.c11", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1.0], [null], [2.0], [3.0]]");
        results = dataset.select("c.c1.c12", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[WrappedArray(null)], [WrappedArray(true)], [WrappedArray(true, false)], [WrappedArray(true, false, true)]]");
    }

    private void innerTestSimpleTypeFilterPushDown(Dataset<Row> dataset) {
        List results = dataset.filter("a < 4").select("a", new String[]{"c"}).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,1]]");
        results = dataset.filter("b = 4").select("a", new String[]{"c"}).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[]");
    }

    private void innerTestNestedTypeFilterPushDown(Dataset<Row> dataset) {
        List results = dataset.filter("a < 4").select("a", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1], [2], [3]]");
        results = dataset.filter("array_contains(b, 'AAA')").select("b", new String[0]).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[WrappedArray(AAA, BBB)]]");
        results = dataset.filter("c.c1.c11 is null").select("a", new String[]{"c"}).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[2,[[null,WrappedArray(true)],null]]]");
        results = dataset.filter("c.c1.c11 = 1.0").select("a", new String[]{"c.c1"}).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,[1.0,WrappedArray(null)]]]");
        results = dataset.filter("c.c2 is null").select("a", new String[]{"c"}).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[2,[[null,WrappedArray(true)],null]]]");
        results = dataset.filter("array_contains(c.c1.c12, false)").select("a", new String[]{"c.c1.c12", "c.c2"}).collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[3,WrappedArray(true, false),2], [4,WrappedArray(true, false, true),3]]");
    }

    @Test
    public void testCreateNestedField() {
        spark.sql("CREATE TABLE nested_table ( a INT, b STRUCT<b1: STRUCT<b11: INT, b12 INT>, b2 BIGINT>)");
        Assertions.assertThat((String)spark.sql("SHOW CREATE TABLE nested_table").collectAsList().toString()).contains(new CharSequence[]{this.showCreateString("nested_table", "a INT", "b STRUCT<b1: STRUCT<b11: INT, b12: INT>, b2: BIGINT>")});
    }
}

