/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import java.util.Map;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0011B)\u001a7fi&|gNV3di>\u0014H+Z:u\u0015\t!Q!A\u0002tc2T!AB\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005!I\u0011A\u00029bS6|gN\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0001\"\u0001E\t\u000e\u0003\u0015I!AE\u0003\u0003'A\u000b\u0017.\\8o'B\f'o\u001b+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0019\u0001")
public class DeletionVectorTest
extends PaimonSparkTestBase {
    private static final Map restoreDeletionVectors$1(DeletionVectorsMaintainer.Factory dvMaintainerFactory$1, FileStoreTable table$1) {
        return dvMaintainerFactory$1.createOrRestore(table$1.snapshotManager().latestSnapshotId(), BinaryRow.EMPTY_ROW, 0).deletionVectors();
    }

    public static final /* synthetic */ String $anonfun$new$9(int x$8) {
        return Character.toString((char)(Random$.MODULE$.nextInt(26) + 97));
    }

    public static final /* synthetic */ String $anonfun$new$10(int x$9) {
        return new StringBuilder(1).append("p").append(Random$.MODULE$.nextInt(3)).toString();
    }

    private final void insert$1(String t1, String t2, int count) {
        IndexedSeq ids = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$7 -> Random$.MODULE$.nextInt(10000), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq names = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$8 -> DeletionVectorTest.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq pts = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$9 -> DeletionVectorTest.$anonfun$new$10(BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom());
        String values = ((TraversableOnce)((TraversableLike)((IterableLike)ids.zip((GenIterable)names, IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)pts, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String pt;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    pt = (String)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int id = tuple2._1$mcI$sp();
            String name = (String)tuple2._2();
            String string = new StringBuilder(10).append("(").append(id).append(", '").append(name).append("', '").append(pt).append("')").toString();
            return string;
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ");
        this.spark().sql(new StringBuilder(20).append("INSERT INTO ").append(t1).append(" VALUES ").append(values).toString());
        this.spark().sql(new StringBuilder(20).append("INSERT INTO ").append(t2).append(" VALUES ").append(values).toString());
    }

    private final void delete$1(String t1, String t2, int count) {
        List ids = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$10 -> Random$.MODULE$.nextInt(10000), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        String idsString = ids.mkString(", ");
        this.spark().sql(new StringBuilder(27).append("DELETE FROM ").append(t1).append(" WHERE id IN (").append(idsString).append(")").toString());
        this.spark().sql(new StringBuilder(27).append("DELETE FROM ").append(t2).append(" WHERE id IN (").append(idsString).append(")").toString());
    }

    private final void update$1(String t1, String t2, int count) {
        List ids = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$11 -> Random$.MODULE$.nextInt(10000), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        String idsString = ids.mkString(", ");
        String randomName = Character.toString((char)(Random$.MODULE$.nextInt(26) + 97));
        this.spark().sql(new StringBuilder(36).append("UPDATE ").append(t1).append(" SET name = '").append(randomName).append("' WHERE id IN (").append(idsString).append(")").toString());
        this.spark().sql(new StringBuilder(36).append("UPDATE ").append(t2).append(" SET name = '").append(randomName).append("' WHERE id IN (").append(idsString).append(")").toString());
    }

    private final void checkResult$1(String t1, String t2, String dvTbl$1) {
        try {
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(30).append("SELECT * FROM ").append(t1).append(" ORDER BY id, pt").toString()), this.spark().sql(new StringBuilder(30).append("SELECT * FROM ").append(t2).append(" ORDER BY id, pt").toString()));
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(26).append("test error, table params: ").append(this.loadTable(dvTbl$1).options()).toString());
            throw new RuntimeException(e);
        }
    }

    public DeletionVectorTest() {
        this.test("Paimon deletionVector: deletion vector write verification", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                   |CREATE TABLE T (id INT, name STRING)\n                   |TBLPROPERTIES (\n                   | 'bucket' = '1',\n                   | 'primary-key' = 'id',\n                   | 'file.format' = 'parquet',\n                   | 'deletion-vectors.enabled' = 'true'\n                   |)\n                   |")).stripMargin());
            FileStoreTable table = this.loadTable("T");
            this.spark().sql("INSERT INTO T VALUES (1, 'aaaaaaaaaaaaaaaaaaa'), (2, 'b'), (3, 'c')");
            this.spark().sql("INSERT INTO T VALUES (1, 'a_new1'), (3, 'c_new1')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a_new1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c_new1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * from T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            DeletionVectorsMaintainer.Factory dvMaintainerFactory = new DeletionVectorsMaintainer.Factory(table.store().newIndexFileHandler());
            Map deletionVectors1 = DeletionVectorTest.restoreDeletionVectors$1(dvMaintainerFactory, table);
            Assertions.assertEquals((int)1, (int)deletionVectors1.size());
            deletionVectors1.entrySet().forEach(e -> {
                Assertions.assertTrue((boolean)((DeletionVector)e.getValue()).isDeleted(0L));
                Assertions.assertTrue((boolean)((DeletionVector)e.getValue()).isDeleted(2L));
            });
            this.spark().sql("CALL sys.compact('T')");
            Map deletionVectors2 = DeletionVectorTest.restoreDeletionVectors$1(dvMaintainerFactory, table);
            Assertions.assertTrue((boolean)deletionVectors2.isEmpty());
            this.spark().sql("INSERT INTO T VALUES (2, 'b_new2')");
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a_new1"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b_new2"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c_new1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * from T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            Map deletionVectors3 = DeletionVectorTest.restoreDeletionVectors$1(dvMaintainerFactory, table);
            Assertions.assertEquals((int)1, (int)deletionVectors3.size());
            deletionVectors3.entrySet().forEach(e -> Assertions.assertTrue((boolean)((DeletionVector)e.getValue()).isDeleted(1L)));
        }), new Position("DeletionVectorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Paimon deletionVector: e2e random write", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String bucket = (String)((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)new .colon.colon((Object)"-1", (List)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"3", (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom())).head();
            String changelogProducer = (String)((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)new .colon.colon((Object)"none", (List)new .colon.colon((Object)"lookup", (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).head();
            String format = (String)((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)new .colon.colon((Object)"orc", (List)new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"avro", (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom())).head();
            int batchSize = Random$.MODULE$.nextInt(1024) + 1;
            String dvTbl = "deletion_vector_tbl";
            String resultTbl = "result_tbl";
            this.spark().sql(new StringBuilder(21).append("drop table if exists ").append(dvTbl).toString());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(438).append("\n                 |CREATE TABLE ").append(dvTbl).append(" (id INT, name STRING, pt STRING)\n                 |TBLPROPERTIES (\n                 | 'primary-key' = 'id, pt',\n                 | 'deletion-vectors.enabled' = 'true',\n                 | 'bucket' = '").append(bucket).append("',\n                 | 'changelog-producer' = '").append(changelogProducer).append("',\n                 | 'file.format' = '").append(format).append("',\n                 | 'read.batch-size' = '").append(batchSize).append("'\n                 |)\n                 |PARTITIONED BY (pt)\n                 |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(21).append("drop table if exists ").append(resultTbl).toString());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(277).append("\n                 |CREATE TABLE ").append(resultTbl).append(" (id INT, name STRING, pt STRING)\n                 |TBLPROPERTIES (\n                 | 'primary-key' = 'id, pt',\n                 | 'deletion-vectors.enabled' = 'false'\n                 |)\n                 |PARTITIONED BY (pt)\n                 |").toString())).stripMargin());
            Seq operations = (Seq)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.insert$1(dvTbl, resultTbl, 1000), (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.update$1(dvTbl, resultTbl, 100), (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1(dvTbl, resultTbl, 100), (List)Nil$.MODULE$)));
            ((Function0)operations.head()).apply$mcV$sp();
            this.checkResult$1(dvTbl, resultTbl, dvTbl);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                ((Function0)operations.apply(Random$.MODULE$.nextInt(operations.size()))).apply$mcV$sp();
                this.checkResult$1(dvTbl, resultTbl, dvTbl);
            });
        }, new Position("DeletionVectorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
    }
}

