/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.spark.PaimonBatch;
import org.apache.paimon.spark.PaimonScan;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.spark.SparkInputPartition;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.sql.PaimonPushDownTest$;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownLimit;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a3AAB\u0004\u0001%!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00059!9a\u0007AI\u0001\n\u00139\u0004\"\u0002\"\u0001\t\u0013\u0019\u0005\"B%\u0001\t\u0013Q%A\u0005)bS6|g\u000eU;tQ\u0012{wO\u001c+fgRT!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007a\u0006LWn\u001c8\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\t\u0011\"\u0003\u0002\u0017\u0013\t\u0019\u0002+Y5n_:\u001c\u0006/\u0019:l)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aB\u0001\u000fO\u0016$8kY1o\u0005VLG\u000eZ3s)\tir\u0005\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u0005!!/Z1e\u0015\t\u00113%A\u0005d_:tWm\u0019;pe*\u0011\u0001\u0002\n\u0006\u0003\u00155I!AJ\u0010\u0003\u0017M\u001b\u0017M\u001c\"vS2$WM\u001d\u0005\bQ\t\u0001\n\u00111\u0001*\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0002+g9\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]E\ta\u0001\u0010:p_Rt$\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018\u00021\u001d,GoU2b]\n+\u0018\u000e\u001c3fe\u0012\"WMZ1vYR$\u0013'F\u00019U\tI\u0013hK\u0001;!\tY\u0004)D\u0001=\u0015\tid(A\u0005v]\u000eDWmY6fI*\u0011qhL\u0001\u000bC:tw\u000e^1uS>t\u0017BA!=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012G\",7m\u001b$jYR,'/\u0012=jgR\u001cHC\u0001#I!\t)e)D\u00010\u0013\t9uFA\u0004C_>dW-\u00198\t\u000b!!\u0001\u0019A\u0015\u00021\rDWmY6FcV\fG\u000eV8GS2$XM]#ySN$8\u000f\u0006\u0003E\u00172s\u0005\"\u0002\u0005\u0006\u0001\u0004I\u0003\"B'\u0006\u0001\u0004I\u0013\u0001\u00028b[\u0016DQaT\u0003A\u0002A\u000bQA^1mk\u0016\u0004\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003+\u000e\n\u0001bY1uC2L8\u000f^\u0005\u0003/J\u0013q\u0001T5uKJ\fG\u000e")
public class PaimonPushDownTest
extends PaimonSparkTestBase {
    private ScanBuilder getScanBuilder(String tableName) {
        return new SparkTable((Table)this.loadTable(tableName)).newScanBuilder(CaseInsensitiveStringMap.empty());
    }

    private String getScanBuilder$default$1() {
        return "T";
    }

    private boolean checkFilterExists(String sql) {
        return this.spark().sql(sql).queryExecution().optimizedPlan().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$checkFilterExists$1(x0$1)));
    }

    private boolean checkEqualToFilterExists(String sql, String name, Literal value) {
        return this.spark().sql(sql).queryExecution().optimizedPlan().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$checkEqualToFilterExists$1(name, value, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$checkFilterExists$1(LogicalPlan x0$1) {
        Filter filter;
        LogicalPlan logicalPlan = x0$1;
        boolean bl = logicalPlan instanceof Filter && (filter = (Filter)logicalPlan).condition() != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkEqualToFilterExists$2(String name$1, Literal value$1, Expression x0$2) {
        Expression expression = x0$2;
        if (!(expression instanceof EqualTo)) return false;
        EqualTo equalTo = (EqualTo)expression;
        Expression a = equalTo.left();
        Expression r = equalTo.right();
        if (!(a instanceof AttributeReference)) return false;
        AttributeReference attributeReference = (AttributeReference)a;
        if (!(r instanceof Literal)) return false;
        Literal literal = (Literal)r;
        if (!attributeReference.name().equals(name$1)) return false;
        if (!literal.equals((Object)value$1)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkEqualToFilterExists$1(String name$1, Literal value$1, LogicalPlan x0$1) {
        boolean bl;
        Filter filter;
        Expression c;
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof Filter && (c = (filter = (Filter)logicalPlan).condition()) != null) {
            Expression expression = c;
            bl = expression.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$checkEqualToFilterExists$2(name$1, value$1, x0$2)));
        } else {
            bl = false;
        }
        return bl;
    }

    public PaimonPushDownTest() {
        this.test("Paimon push down: apply partition filter push down with non-partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, pt STRING)\n                 |TBLPROPERTIES ('primary-key'='id, pt', 'bucket'='2')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', 'p1'), (2, 'b', 'p1'), (3, 'c', 'p2')");
            String q = "SELECT * FROM T WHERE pt = 'p1'";
            Assertions.assertTrue((boolean)this.checkEqualToFilterExists(q, "pt", Literal$.MODULE$.apply((Object)"p1")));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(q), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("Paimon push down: apply partition filter push down with partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, pt STRING)\n                 |TBLPROPERTIES ('primary-key'='id, pt', 'bucket'='2')\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', 'p1'), (2, 'b', 'p1'), (3, 'c', 'p2'), (4, 'd', 'p3')");
            ObjectRef q = ObjectRef.create((Object)"SELECT * FROM T WHERE id = '1'");
            Assertions.assertTrue((boolean)this.checkFilterExists((String)q.elem));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            q.elem = "SELECT * FROM T WHERE id = '1' or pt = 'p1'";
            Assertions.assertTrue((boolean)this.checkEqualToFilterExists((String)q.elem, "pt", Literal$.MODULE$.apply((Object)"p1")));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2));
            q.elem = "SELECT * FROM T WHERE pt = 'p1'";
            Assertions.assertFalse((boolean)this.checkFilterExists((String)q.elem));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4));
            q.elem = "SELECT * FROM T WHERE id = '1' and pt = 'p1'";
            Assertions.assertFalse((boolean)this.checkEqualToFilterExists((String)q.elem, "pt", Literal$.MODULE$.apply((Object)"p1")));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row6));
            q.elem = "SELECT * FROM T WHERE pt < 'p3'";
            Assertions.assertFalse((boolean)this.checkFilterExists((String)q.elem));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "p2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7));
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Paimon pushDown: limit for append-only tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (a INT, b STRING, c STRING)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22')");
            this.spark().sql("INSERT INTO T VALUES (3, 'c', '11'), (4, 'd', '22')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "11"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "22"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "11"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "d", "22"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY a"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            ScanBuilder scanBuilder = this.getScanBuilder(this.getScanBuilder$default$1());
            Assertions.assertTrue((boolean)(scanBuilder instanceof SupportsPushDownLimit));
            DataFileMeta[] dataFilesWithoutLimit = (DataFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scanBuilder.build().toBatch().planInputPartitions())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                InputPartition inputPartition = x0$1;
                if (inputPartition instanceof SparkInputPartition) {
                    SparkInputPartition sparkInputPartition = (SparkInputPartition)inputPartition;
                    Split split = sparkInputPartition.split();
                    if (split instanceof DataSplit) {
                        DataSplit dataSplit = (DataSplit)split;
                        seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(dataSplit.dataFiles()).asScala();
                    } else {
                        seq = (Seq)Nil$.MODULE$;
                    }
                } else {
                    throw new MatchError((Object)inputPartition);
                }
                Seq seq2 = seq;
                return seq2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFileMeta.class)));
            Assertions.assertTrue((dataFilesWithoutLimit.length >= 2 ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder).pushLimit(1));
            PaimonScan paimonScan = (PaimonScan)scanBuilder.build();
            InputPartition[] partitions = new PaimonBatch(paimonScan.getOriginSplits(), paimonScan.readBuilder()).planInputPartitions();
            Assertions.assertEquals((int)1, (int)partitions.length);
            Assertions.assertEquals((long)1L, (long)this.spark().sql("SELECT * FROM T LIMIT 1").count());
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Paimon pushDown: limit for change-log tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (a INT, b STRING, c STRING)\n                 |TBLPROPERTIES ('primary-key'='a')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22')");
            this.spark().sql("INSERT INTO T VALUES (3, 'c', '11'), (4, 'd', '22')");
            ScanBuilder scanBuilder = this.getScanBuilder(this.getScanBuilder$default$1());
            Assertions.assertTrue((boolean)(scanBuilder instanceof SupportsPushDownLimit));
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder).pushLimit(1));
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("Paimon pushDown: runtime filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source", "t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PaimonPushDownTest.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_PaimonPushDownTest$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_PaimonPushDownTest$$typecreator6$1(PaimonPushDownTest $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"x1", (Object)"2023"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"x2", (Object)"2023"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)5L), (Object)"x5", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)6L), (Object)"x6", (Object)"2026"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_PaimonPushDownTest$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "pt"})).createOrReplaceTempView("source");
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                  |CREATE TABLE t (id INT, name STRING, pt STRING) PARTITIONED BY (pt)\n                  |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |INSERT INTO t VALUES (1, \"a\", \"2023\"), (3, \"c\", \"2023\"), (5, \"e\", \"2025\"), (7, \"g\", \"2027\")\n          |")).stripMargin());
            Dataset df1 = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                            |SELECT t.id, t.name, source.b FROM source join t\n                            |ON source.pt = t.pt AND source.pt = '2023'\n                            |ORDER BY t.id, source.b\n                            |")).stripMargin());
            QueryExecution qe1 = df1.queryExecution();
            Assertions.assertFalse((boolean)qe1.analyzed().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe1.optimizedPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe1.sparkPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "x1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "x2"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "x1"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "x2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df1, (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            Dataset df2 = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                            |SELECT t.*, source.b FROM source join t\n                            |ON source.a = t.id AND source.pt = t.pt AND source.a > 3\n                            |")).stripMargin());
            QueryExecution qe2 = df1.queryExecution();
            Assertions.assertFalse((boolean)qe2.analyzed().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe2.optimizedPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe2.sparkPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "e", "2025", "x5"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df2, (Seq)Nil$.MODULE$.$colon$colon((Object)row5));
        }), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }
}

