/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.In;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableSet;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.types.RowType;

public abstract class ScanBucketFilter {
    public static final int MAX_VALUES = 1000;
    private final RowType bucketKeyType;
    private ScanBucketSelector selector;

    public ScanBucketFilter(RowType bucketKeyType) {
        this.bucketKeyType = bucketKeyType;
    }

    public abstract void pushdown(Predicate var1);

    public void setBucketKeyFilter(Predicate predicate) {
        this.selector = ScanBucketFilter.create(predicate, this.bucketKeyType).orElse(null);
    }

    public boolean select(int bucket, int numBucket) {
        return this.selector == null || this.selector.select(bucket, numBucket);
    }

    @VisibleForTesting
    static Optional<ScanBucketSelector> create(Predicate bucketPredicate, RowType bucketKeyType) {
        List[] bucketValues = new List[bucketKeyType.getFieldCount()];
        block0: for (Predicate predicate : PredicateBuilder.splitAnd(bucketPredicate)) {
            Integer reference = null;
            ArrayList values = new ArrayList();
            for (Predicate orPredicate : PredicateBuilder.splitOr(predicate)) {
                if (!(orPredicate instanceof LeafPredicate)) continue block0;
                LeafPredicate leaf = (LeafPredicate)orPredicate;
                if (reference != null && reference.intValue() != leaf.index()) continue block0;
                reference = leaf.index();
                if (!leaf.function().equals(Equal.INSTANCE) && !leaf.function().equals(In.INSTANCE)) continue block0;
                values.addAll(leaf.literals().stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (reference == null) continue;
            if (bucketValues[reference] != null) {
                return Optional.empty();
            }
            bucketValues[reference.intValue()] = values;
        }
        int rowCount = 1;
        for (List values : bucketValues) {
            if (values == null) {
                return Optional.empty();
            }
            if ((rowCount *= values.size()) <= 1000) continue;
            return Optional.empty();
        }
        InternalRowSerializer internalRowSerializer = new InternalRowSerializer(bucketKeyType);
        ArrayList hashCodes = new ArrayList();
        ScanBucketFilter.assembleRows(bucketValues, columns -> hashCodes.add(ScanBucketFilter.hash(columns, serializer)), new ArrayList<Object>(), 0);
        return Optional.of(new ScanBucketSelector(hashCodes.stream().mapToInt(i -> i).toArray()));
    }

    private static int hash(List<Object> columns, InternalRowSerializer serializer) {
        BinaryRow binaryRow = serializer.toBinaryRow(GenericRow.of(columns.toArray()));
        return KeyAndBucketExtractor.bucketKeyHashCode(binaryRow);
    }

    private static void assembleRows(List<Object>[] rowValues, Consumer<List<Object>> consumer, List<Object> stack, int columnIndex) {
        List<Object> columnValues = rowValues[columnIndex];
        for (Object value : columnValues) {
            stack.add(value);
            if (columnIndex == rowValues.length - 1) {
                consumer.accept(stack);
            } else {
                ScanBucketFilter.assembleRows(rowValues, consumer, stack, columnIndex + 1);
            }
            stack.remove(stack.size() - 1);
        }
    }

    @ThreadSafe
    public static class ScanBucketSelector {
        private final int[] hashCodes;
        private final Map<Integer, Set<Integer>> buckets = new ConcurrentHashMap<Integer, Set<Integer>>();

        public ScanBucketSelector(int[] hashCodes) {
            this.hashCodes = hashCodes;
        }

        @VisibleForTesting
        boolean select(int bucket, int numBucket) {
            return this.buckets.computeIfAbsent(numBucket, k -> this.createBucketSet(numBucket)).contains(bucket);
        }

        @VisibleForTesting
        int[] hashCodes() {
            return this.hashCodes;
        }

        @VisibleForTesting
        Set<Integer> createBucketSet(int numBucket) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (int hash : this.hashCodes) {
                builder.add((Object)KeyAndBucketExtractor.bucket(hash, numBucket));
            }
            return builder.build();
        }
    }
}

