/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.roaringbitmap;

import org.apache.paimon.shade.org.roaringbitmap.PeekableCharIterator;

final class ReverseBitmapContainerCharIterator
implements PeekableCharIterator {
    long word;
    int position;
    long[] bitmap;

    ReverseBitmapContainerCharIterator() {
    }

    ReverseBitmapContainerCharIterator(long[] bitmap) {
        this.wrap(bitmap);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.position >= 0;
    }

    @Override
    public char next() {
        int shift = Long.numberOfLeadingZeros(this.word) + 1;
        char answer = (char)((this.position + 1) * 64 - shift);
        this.word &= -2L >>> shift;
        while (this.word == 0L) {
            --this.position;
            if (this.position < 0) break;
            this.word = this.bitmap[this.position];
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        return this.next();
    }

    @Override
    public void advanceIfNeeded(char maxval) {
        if (maxval < (this.position + 1) * 64) {
            if (maxval < this.position * 64) {
                this.position = maxval / 64;
            }
            long currentWord = this.bitmap[this.position];
            currentWord &= -1L >>> 63 - (maxval & 0x3F);
            if (this.position > 0) {
                while (currentWord == 0L) {
                    --this.position;
                    if (this.position == 0) break;
                    currentWord = this.bitmap[this.position];
                }
            }
            this.word = currentWord;
        }
    }

    @Override
    public char peekNext() {
        int shift = Long.numberOfLeadingZeros(this.word) + 1;
        return (char)((this.position + 1) * 64 - shift);
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    void wrap(long[] b) {
        this.bitmap = b;
        this.position = this.bitmap.length - 1;
        while (this.position >= 0 && (this.word = this.bitmap[this.position]) == 0L) {
            --this.position;
        }
    }
}

