/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sort;

import java.util.List;
import org.apache.paimon.spark.sort.SparkHilbertUDF;
import org.apache.paimon.spark.sort.TableSorter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.StructType;

public class HilbertSorter
extends TableSorter {
    private static final String H_COLUMN = "HVALUE";

    public HilbertSorter(FileStoreTable table, List<String> orderColumns) {
        super(table, orderColumns);
        this.checkNotEmpty();
    }

    @Override
    public Dataset<Row> sort(Dataset<Row> df) {
        Column hilbertColumn = this.hilbertValue(df);
        Dataset hilbertValueDF = df.withColumn(H_COLUMN, hilbertColumn);
        Dataset sortedDF = hilbertValueDF.repartitionByRange(new Column[]{hilbertValueDF.col(H_COLUMN)}).sortWithinPartitions(new Column[]{hilbertValueDF.col(H_COLUMN)});
        return sortedDF.drop(H_COLUMN);
    }

    private Column hilbertValue(Dataset<Row> df) {
        SparkHilbertUDF hilbertUDF = new SparkHilbertUDF();
        Column[] hilbertCols = (Column[])this.orderColNames.stream().map(arg_0 -> ((StructType)df.schema()).apply(arg_0)).map(col -> hilbertUDF.sortedLexicographically(df.col(col.name()), col.dataType())).toArray(Column[]::new);
        return hilbertUDF.transform(functions.array((Column[])hilbertCols));
    }
}

