/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.testutils.assertj;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.apache.paimon.testutils.assertj.PaimonCompletableFutureAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;

public final class PaimonAssertions {
    public static final InstanceOfAssertFactory<Stream, ListAssert<Throwable>> STREAM_THROWABLE = new InstanceOfAssertFactory(Stream.class, Assertions::assertThat);

    private PaimonAssertions() {
    }

    public static ThrowingConsumer<? super Throwable> anyCauseMatches(Class<? extends Throwable> clazz, String containsMessage) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)((ListAssert)PaimonAssertions.assertThatChainOfCauses(t).as("Any cause is instance of class '%s' and contains message '%s'", new Object[]{clazz, containsMessage})).anySatisfy(cause -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)cause).isInstanceOf(clazz)).hasMessageContaining(containsMessage));
        };
    }

    public static ThrowingConsumer<? super Throwable> anyCauseMatches(Class<? extends Throwable> clazz) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)((ListAssert)PaimonAssertions.assertThatChainOfCauses(t).as("Any cause is instance of class '%s'", new Object[]{clazz})).anySatisfy(cause -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)cause).isInstanceOf(clazz);
            });
        };
    }

    public static ThrowingConsumer<? super Throwable> anyCauseMatches(String containsMessage) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)((ListAssert)PaimonAssertions.assertThatChainOfCauses(t).as("Any cause contains message '%s'", new Object[]{containsMessage})).anySatisfy(t1 -> Assertions.assertThat((Throwable)t1).hasMessageContaining(containsMessage));
        };
    }

    public static ListAssert<Throwable> assertThatChainOfCauses(Throwable root) {
        return (ListAssert)Assertions.assertThat((Throwable)root).extracting(PaimonAssertions::chainOfCauses, STREAM_THROWABLE);
    }

    public static Stream<Throwable> chainOfCauses(Throwable throwable) {
        if (throwable == null) {
            return Stream.empty();
        }
        if (throwable.getCause() == null) {
            return Stream.of(throwable);
        }
        return Stream.concat(Stream.of(throwable), PaimonAssertions.chainOfCauses(throwable.getCause()));
    }

    public static <T> PaimonCompletableFutureAssert<T> assertThatFuture(CompletableFuture<T> actual) {
        return new PaimonCompletableFutureAssert<T>(actual);
    }

    public static <T> PaimonCompletableFutureAssert<T> assertThatFuture(CompletionStage<T> actual) {
        return new PaimonCompletableFutureAssert<T>(actual);
    }
}

