/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.concurrent.Callable;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.TestTypeBuilders;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeUtil;
import org.apache.parquet.schema.Types;
import org.junit.Test;

public class TestTypeUtil {
    @Test
    public void testWriteCheckMessageType() {
        TypeUtil.checkValidWriteSchema((GroupType)((GroupType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).named("a")).optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("b")).named("valid_schema")));
        TestTypeBuilders.assertThrows("Should complain about empty MessageType", InvalidSchemaException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TypeUtil.checkValidWriteSchema((GroupType)new MessageType("invalid_schema", new Type[0]));
                return null;
            }
        });
    }

    @Test
    public void testWriteCheckGroupType() {
        TypeUtil.checkValidWriteSchema((GroupType)((GroupType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("a")).optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("b")).named("valid_group")));
        TestTypeBuilders.assertThrows("Should complain about empty GroupType", InvalidSchemaException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TypeUtil.checkValidWriteSchema((GroupType)new GroupType(Type.Repetition.REPEATED, "invalid_group", new Type[0]));
                return null;
            }
        });
    }

    @Test
    public void testWriteCheckNestedGroupType() {
        TypeUtil.checkValidWriteSchema((GroupType)((GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("a")).optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("b")).named("valid_group")).named("valid_message")));
        TestTypeBuilders.assertThrows("Should complain about empty GroupType", InvalidSchemaException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TypeUtil.checkValidWriteSchema((GroupType)((GroupType)((Types.GroupBuilder)Types.buildMessage().addField((Type)new GroupType(Type.Repetition.REPEATED, "invalid_group", new Type[0]))).named("invalid_message")));
                return null;
            }
        });
    }
}

