/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.Utils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestDeltaLengthByteArray {
    String[] values = new String[]{"parquet", "hadoop", "mapreduce"};

    private DeltaLengthByteArrayValuesWriter getDeltaLengthByteArrayValuesWriter() {
        return new DeltaLengthByteArrayValuesWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
    }

    @Test
    public void testSerialization() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = this.getDeltaLengthByteArrayValuesWriter();
        DeltaLengthByteArrayValuesReader reader = new DeltaLengthByteArrayValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toInputStream(), this.values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)this.values[i]), (Object)bin[i]);
        }
    }

    @Test
    public void testRandomStrings() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = this.getDeltaLengthByteArrayValuesWriter();
        DeltaLengthByteArrayValuesReader reader = new DeltaLengthByteArrayValuesReader();
        String[] values = Utils.getRandomStringSamples(1000, 32);
        Utils.writeData((ValuesWriter)writer, values);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toInputStream(), values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)values[i]), (Object)bin[i]);
        }
    }

    @Test
    public void testLengths() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = this.getDeltaLengthByteArrayValuesWriter();
        DeltaBinaryPackingValuesReader reader = new DeltaBinaryPackingValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        int[] bin = Utils.readInts((ValuesReader)reader, writer.getBytes().toInputStream(), this.values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((long)this.values[i].length(), (long)bin[i]);
        }
    }
}

