/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.column.columnindex;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PrimitiveIterator;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.LogicalInverter;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.internal.column.columnindex.BinaryColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.BooleanColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.DoubleColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.FloatColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.IntColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.LongColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.TestIndexIterator;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnIndexBuilder {
    @Test
    public void testBuildBinaryDecimal() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(12)).scale(2)).named("test_binary_decimal");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(BinaryColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.BinaryColumn col = FilterApi.binaryColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("-0.17"), TestColumnIndexBuilder.decimalBinary("1234567890.12")));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("-234.23"), null, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("-9999293.23"), TestColumnIndexBuilder.decimalBinary("2348978.45")));
        builder.add(sb.stats(type, null, null, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("87656273")));
        Assert.assertEquals((long)8L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 0L, 3L, 3L, 0L, 4L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, TestColumnIndexBuilder.decimalBinary("1234567890.12"), TestColumnIndexBuilder.decimalBinary("-234.23"), null, TestColumnIndexBuilder.decimalBinary("2348978.45"), null, null, TestColumnIndexBuilder.decimalBinary("87656273"));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, TestColumnIndexBuilder.decimalBinary("-0.17"), TestColumnIndexBuilder.decimalBinary("-234.23"), null, TestColumnIndexBuilder.decimalBinary("-9999293.23"), null, null, TestColumnIndexBuilder.decimalBinary("87656273"));
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("0.0")), 1, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("87656273")), 0, 1, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 4, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("2348978.45")), 1);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("2348978.45")), 1, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("-234.23")), 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("-234.23")), 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class), 0, 1, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class)), 1, 2, 4, 7);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("-9999293.23"), TestColumnIndexBuilder.decimalBinary("-234.23")));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("-0.17"), TestColumnIndexBuilder.decimalBinary("87656273")));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("87656273")));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("1234567890.12"), null, null, null));
        builder.add(sb.stats(type, null, null, null));
        Assert.assertEquals((long)8L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 4L, 0L, 0L, 2L, 0L, 2L, 3L, 3L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, TestColumnIndexBuilder.decimalBinary("-234.23"), TestColumnIndexBuilder.decimalBinary("87656273"), null, TestColumnIndexBuilder.decimalBinary("87656273"), null, TestColumnIndexBuilder.decimalBinary("1234567890.12"), null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, TestColumnIndexBuilder.decimalBinary("-9999293.23"), TestColumnIndexBuilder.decimalBinary("-0.17"), null, TestColumnIndexBuilder.decimalBinary("87656273"), null, TestColumnIndexBuilder.decimalBinary("1234567890.12"), null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("87656273")), 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 3, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("87656273")), 0, 1, 2, 3, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("87656273")), 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("87656273")), 2, 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("-0.17")), 1);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("-0.17")), 1, 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class), 0, 2, 3, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class)), 1, 2, 4, 6);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("1234567890.12"), null, null, null));
        builder.add(sb.stats(type, null, null, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("1234567890.12"), TestColumnIndexBuilder.decimalBinary("87656273")));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("987656273"), TestColumnIndexBuilder.decimalBinary("-0.17")));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.decimalBinary("-234.23"), TestColumnIndexBuilder.decimalBinary("-9999293.23")));
        Assert.assertEquals((long)8L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 3L, 2L, 3L, 4L, 0L, 0L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, true, false, true, false, false, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, null, TestColumnIndexBuilder.decimalBinary("1234567890.12"), null, TestColumnIndexBuilder.decimalBinary("1234567890.12"), TestColumnIndexBuilder.decimalBinary("987656273"), null, TestColumnIndexBuilder.decimalBinary("-234.23"));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, null, TestColumnIndexBuilder.decimalBinary("1234567890.12"), null, TestColumnIndexBuilder.decimalBinary("87656273"), TestColumnIndexBuilder.decimalBinary("-0.17"), null, TestColumnIndexBuilder.decimalBinary("-9999293.23"));
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("1234567890.12")), 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("0.0")), 0, 1, 2, 3, 4, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 2, 4, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("1234567890.12")), new int[0]);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("1234567890.12")), 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("-0.17")), 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.decimalBinary("-0.17")), 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class), 0, 1, 2, 3, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class)), 2, 4, 5, 7);
    }

    @Test
    public void testBuildBinaryUtf8() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("test_binary_utf8");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(BinaryColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.BinaryColumn col = FilterApi.binaryColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Jeltz"), TestColumnIndexBuilder.stringBinary("Slartibartfast"), null, null));
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Prefect")));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Trilian"), null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Beeblebrox")));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)8L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 5L, 2L, 0L, 1L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, true, false, false, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"), null, null, TestColumnIndexBuilder.stringBinary("Prefect"), TestColumnIndexBuilder.stringBinary("Trilian"), TestColumnIndexBuilder.stringBinary("Beeblebrox"), null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, TestColumnIndexBuilder.stringBinary("Jeltz"), null, null, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Beeblebrox"), null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Marvin")), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Beeblebrox")), 0, 1, 2, 3, 4, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Prefect")), 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Prefect")), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryUtf8StartsWithB.class), 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryUtf8StartsWithB.class)), 0, 1, 2, 3, 4, 5, 7);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Dent"), null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Jeltz")));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Prefect"), null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Slartibartfast")));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)8L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 5L, 0L, 1L, 2L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, true, true, false, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), TestColumnIndexBuilder.stringBinary("Dent"), null, null, TestColumnIndexBuilder.stringBinary("Jeltz"), TestColumnIndexBuilder.stringBinary("Prefect"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"), null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), TestColumnIndexBuilder.stringBinary("Beeblebrox"), null, null, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"), null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Jeltz")), 3, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 4, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Slartibartfast")), 0, 1, 2, 3, 4, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 3, 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Marvin")), 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Marvin")), 4, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 0);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 0, 3, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryUtf8StartsWithB.class), 0);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryUtf8StartsWithB.class)), 0, 1, 2, 3, 4, 5, 6, 7);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Slartibartfast")));
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Prefect"), TestColumnIndexBuilder.stringBinary("Jeltz"), null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Dent")));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Beeblebrox"), null, null));
        Assert.assertEquals((long)8L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 0L, 5L, 1L, 0L, 2L, 2L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"), null, TestColumnIndexBuilder.stringBinary("Prefect"), TestColumnIndexBuilder.stringBinary("Dent"), null, null, TestColumnIndexBuilder.stringBinary("Dent"));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"), null, TestColumnIndexBuilder.stringBinary("Jeltz"), TestColumnIndexBuilder.stringBinary("Dent"), null, null, TestColumnIndexBuilder.stringBinary("Beeblebrox"));
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Marvin")), 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 0, 1, 2, 3, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 3, 4, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Prefect")), 1);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Prefect")), 1, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Marvin")), 3, 4, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Marvin")), 3, 4, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryUtf8StartsWithB.class), 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryUtf8StartsWithB.class)), 0, 1, 2, 3, 4, 5, 6, 7);
    }

    @Test
    public void testStaticBuildBinary() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("test_binary_utf8")), (BoundaryOrder)BoundaryOrder.ASCENDING, Arrays.asList(true, true, false, false, true, false, true, false), Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), TestColumnIndexBuilder.toBBList(null, null, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Jeltz"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast")), TestColumnIndexBuilder.toBBList(null, null, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Prefect"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast")));
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, true, false, false, true, false, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, null, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Prefect"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, null, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Jeltz"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"));
    }

    @Test
    public void testFilterWithoutNullCounts() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("test_binary_utf8")), (BoundaryOrder)BoundaryOrder.ASCENDING, Arrays.asList(true, true, false, false, true, false, true, false), null, TestColumnIndexBuilder.toBBList(null, null, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Jeltz"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast")), TestColumnIndexBuilder.toBBList(null, null, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Prefect"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast")));
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        Assert.assertNull((Object)columnIndex.getNullCounts());
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, true, false, false, true, false, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, null, TestColumnIndexBuilder.stringBinary("Dent"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Prefect"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, null, TestColumnIndexBuilder.stringBinary("Beeblebrox"), TestColumnIndexBuilder.stringBinary("Dent"), null, TestColumnIndexBuilder.stringBinary("Jeltz"), null, TestColumnIndexBuilder.stringBinary("Slartibartfast"));
        Operators.BinaryColumn col = FilterApi.binaryColumn((String)"test_col");
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 4, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)TestColumnIndexBuilder.stringBinary("Dent")), 0, 1, 2, 3, 4, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 2, 3, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class), 0, 1, 2, 3, 4, 5, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BinaryDecimalIsNullOrZeroUdp.class)), 2, 3, 5, 7);
    }

    @Test
    public void testBuildBoolean() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("test_boolean");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(BooleanColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.BooleanColumn col = FilterApi.booleanColumn((String)"test_col");
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, false, true));
        builder.add(sb.stats(type, true, false, null));
        builder.add(sb.stats(type, true, true, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, false, false));
        Assert.assertEquals((long)5L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), true, true, true, null, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), false, false, true, null, false);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Boolean.valueOf(true)), 0, 1, 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Boolean.valueOf(true)), 0, 1, 2, 3, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 1, 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BooleanIsTrueOrNull.class), 0, 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BooleanIsTrueOrNull.class)), 0, 1, 4);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, false, false));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, null, null, null, null));
        builder.add(sb.stats(type, false, true, null));
        builder.add(sb.stats(type, false, true, null, null));
        builder.add(sb.stats(type, null, null, null));
        Assert.assertEquals((long)7L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 0L, 3L, 4L, 1L, 2L, 3L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, true, false, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, false, null, null, true, true, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, false, null, null, false, false, null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Boolean.valueOf(true)), 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Boolean.valueOf(true)), 0, 1, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BooleanIsTrueOrNull.class), 0, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BooleanIsTrueOrNull.class)), 1, 4, 5);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, true, true));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, null, null, null, null));
        builder.add(sb.stats(type, true, false, null));
        builder.add(sb.stats(type, false, false, null, null));
        builder.add(sb.stats(type, null, null, null));
        Assert.assertEquals((long)7L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 0L, 3L, 4L, 1L, 2L, 3L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, true, false, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, true, null, null, true, false, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, true, null, null, false, false, null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Boolean.valueOf(true)), 1, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Boolean.valueOf(true)), 0, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, BooleanIsTrueOrNull.class), 0, 1, 2, 3, 4, 5, 6);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, BooleanIsTrueOrNull.class)), 4, 5);
    }

    @Test
    public void testStaticBuildBoolean() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("test_boolean")), (BoundaryOrder)BoundaryOrder.DESCENDING, Arrays.asList(false, true, false, true, false, true), Arrays.asList(9L, 8L, 7L, 6L, 5L, 0L), TestColumnIndexBuilder.toBBList(false, null, false, null, true, null), TestColumnIndexBuilder.toBBList(true, null, false, null, true, null));
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 9L, 8L, 7L, 6L, 5L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), true, null, false, null, true, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), false, null, false, null, true, null);
    }

    @Test
    public void testBuildDouble() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("test_double");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(DoubleColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.DoubleColumn col = FilterApi.doubleColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, -4.2, -4.1));
        builder.add(sb.stats(type, -11.7, 7.0, null));
        builder.add(sb.stats(type, 2.2, 2.2, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 1.9, 2.32));
        builder.add(sb.stats(type, -21.0, 8.1));
        Assert.assertEquals((long)6L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 0L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), -4.1, 7.0, 2.2, null, 2.32, 8.1);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), -4.2, -11.7, 2.2, null, 1.9, -21.0);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Double.valueOf(0.0)), 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Double.valueOf(2.2)), 0, 1, 2, 3, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Double.valueOf(2.2)), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Double.valueOf(2.2)), 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Double.valueOf(-4.2)), 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Double.valueOf(-4.2)), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, DoubleIsInteger.class), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, DoubleIsInteger.class)), 0, 1, 2, 3, 4, 5);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -532.3, -345.2, null, null));
        builder.add(sb.stats(type, -234.7, -234.6, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, -234.6, 2.99999));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 3.0, 42.83));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 1L, 2L, 3L, 0L, 2L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, -345.2, -234.6, null, null, 2.99999, null, 42.83, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, -532.3, -234.7, null, null, -234.6, null, 3.0, null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Double.valueOf(0.0)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 4, 6, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Double.valueOf(0.0)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Double.valueOf(2.99999)), 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Double.valueOf(2.99999)), 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Double.valueOf(-234.6)), 1, 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Double.valueOf(-234.6)), 1, 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, DoubleIsInteger.class), 1, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, DoubleIsInteger.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, 532.3, 345.2));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 234.7, 234.6, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 234.69, -2.99999));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -3.0, -42.83));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 5L, 0L, 3L, 1L, 2L, 0L, 2L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, true, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, 532.3, null, 234.7, null, 234.69, null, null, -3.0);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, 345.2, null, 234.6, null, -2.99999, null, null, -42.83);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Double.valueOf(234.6)), 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Double.valueOf(2.2)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Double.valueOf(2.2)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Double.valueOf(234.69)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Double.valueOf(-2.99999)), 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Double.valueOf(-2.99999)), 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, DoubleIsInteger.class), 1, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, DoubleIsInteger.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testBuildDoubleZeroNaN() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("test_double");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, -1.0, -0.0));
        builder.add(sb.stats(type, 0.0, 1.0));
        builder.add(sb.stats(type, 1.0, 100.0));
        ColumnIndex columnIndex = builder.build();
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), -1.0, -0.0, 1.0);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), 0.0, 1.0, 100.0);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        builder.add(sb.stats(type, -1.0, -0.0));
        builder.add(sb.stats(type, 0.0, Double.NaN));
        builder.add(sb.stats(type, 1.0, 100.0));
        Assert.assertNull((Object)builder.build());
    }

    @Test
    public void testStaticBuildDouble() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("test_double")), (BoundaryOrder)BoundaryOrder.UNORDERED, Arrays.asList(false, false, false, false, false, false), Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L), TestColumnIndexBuilder.toBBList(-1.0, -2.0, -3.0, -4.0, -5.0, -6.0), TestColumnIndexBuilder.toBBList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0));
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 4L, 5L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, false, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), 1.0, 2.0, 3.0, 4.0, 5.0, 6.0);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), -1.0, -2.0, -3.0, -4.0, -5.0, -6.0);
    }

    @Test
    public void testBuildFloat() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("test_float");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(FloatColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.FloatColumn col = FilterApi.floatColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, Float.valueOf(-4.2f), Float.valueOf(-4.1f)));
        builder.add(sb.stats(type, Float.valueOf(-11.7f), Float.valueOf(7.0f), null));
        builder.add(sb.stats(type, Float.valueOf(2.2f), Float.valueOf(2.2f), null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, Float.valueOf(1.9f), Float.valueOf(2.32f)));
        builder.add(sb.stats(type, Float.valueOf(-21.0f), Float.valueOf(8.1f)));
        Assert.assertEquals((long)6L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 0L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), Float.valueOf(-4.1f), Float.valueOf(7.0f), Float.valueOf(2.2f), null, Float.valueOf(2.32f), Float.valueOf(8.1f));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), Float.valueOf(-4.2f), Float.valueOf(-11.7f), Float.valueOf(2.2f), null, Float.valueOf(1.9f), Float.valueOf(-21.0f));
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Float.valueOf(0.0f)), 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 0, 1, 2, 3, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Float.valueOf(0.0f)), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Float.valueOf(1.9f)), 0, 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, FloatIsInteger.class), 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, FloatIsInteger.class)), 0, 1, 2, 3, 4, 5);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, Float.valueOf(-532.3f), Float.valueOf(-345.2f), null, null));
        builder.add(sb.stats(type, Float.valueOf(-300.6f), Float.valueOf(-234.7f), null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, Float.valueOf(-234.6f), Float.valueOf(2.99999f)));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, Float.valueOf(3.0f), Float.valueOf(42.83f)));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 1L, 2L, 3L, 0L, 2L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, Float.valueOf(-345.2f), Float.valueOf(-234.7f), null, null, Float.valueOf(2.99999f), null, Float.valueOf(42.83f), null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, Float.valueOf(-532.3f), Float.valueOf(-300.6f), null, null, Float.valueOf(-234.6f), null, Float.valueOf(3.0f), null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Float.valueOf(0.0f)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 4, 6, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Float.valueOf(-234.7f)), 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Float.valueOf(-234.6f)), 1, 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Float.valueOf(-234.6f)), 1, 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, FloatIsInteger.class), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, FloatIsInteger.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, Float.valueOf(532.3f), Float.valueOf(345.2f)));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, Float.valueOf(234.7f), Float.valueOf(234.6f), null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, Float.valueOf(234.6f), Float.valueOf(-2.99999f)));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, Float.valueOf(-3.0f), Float.valueOf(-42.83f)));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 5L, 0L, 3L, 1L, 2L, 0L, 2L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, true, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, Float.valueOf(532.3f), null, Float.valueOf(234.7f), null, Float.valueOf(234.6f), null, null, Float.valueOf(-3.0f));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, Float.valueOf(345.2f), null, Float.valueOf(234.6f), null, Float.valueOf(-2.99999f), null, null, Float.valueOf(-42.83f));
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Float.valueOf(234.65f)), 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Float.valueOf(2.2f)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Float.valueOf(0.0f)), 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Float.valueOf(0.0f)), 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, FloatIsInteger.class), 1, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, FloatIsInteger.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testBuildFloatZeroNaN() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("test_float");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, Float.valueOf(-1.0f), Float.valueOf(-0.0f)));
        builder.add(sb.stats(type, Float.valueOf(0.0f), Float.valueOf(1.0f)));
        builder.add(sb.stats(type, Float.valueOf(1.0f), Float.valueOf(100.0f)));
        ColumnIndex columnIndex = builder.build();
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), Float.valueOf(-1.0f), Float.valueOf(-0.0f), Float.valueOf(1.0f));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(100.0f));
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        builder.add(sb.stats(type, Float.valueOf(-1.0f), Float.valueOf(-0.0f)));
        builder.add(sb.stats(type, Float.valueOf(0.0f), Float.valueOf(Float.NaN)));
        builder.add(sb.stats(type, Float.valueOf(1.0f), Float.valueOf(100.0f)));
        Assert.assertNull((Object)builder.build());
    }

    @Test
    public void testStaticBuildFloat() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("test_float")), (BoundaryOrder)BoundaryOrder.ASCENDING, Arrays.asList(true, true, true, false, false, false), Arrays.asList(9L, 8L, 7L, 6L, 0L, 0L), TestColumnIndexBuilder.toBBList(null, null, null, Float.valueOf(-3.0f), Float.valueOf(-2.0f), Float.valueOf(0.1f)), TestColumnIndexBuilder.toBBList(null, null, null, Float.valueOf(-2.0f), Float.valueOf(0.0f), Float.valueOf(6.0f)));
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 9L, 8L, 7L, 6L, 0L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, true, true, false, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, null, null, Float.valueOf(-2.0f), Float.valueOf(0.0f), Float.valueOf(6.0f));
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, null, null, Float.valueOf(-3.0f), Float.valueOf(-2.0f), Float.valueOf(0.1f));
    }

    @Test
    public void testBuildInt32() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(IntColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.IntColumn col = FilterApi.intColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, -4, 10));
        builder.add(sb.stats(type, -11, 7, null));
        builder.add(sb.stats(type, 2, 2, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 1, 2));
        builder.add(sb.stats(type, -21, 8));
        Assert.assertEquals((long)6L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 0L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), 10, 7, 2, null, 2, 8);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), -4, -11, 2, null, 1, -21);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 3, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -532, -345, null, null));
        builder.add(sb.stats(type, -500, -42, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, -42, 2));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 3, 42));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 1L, 2L, 3L, 0L, 2L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, -345, -42, null, null, 2, null, 42, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, -532, -500, null, null, -42, null, 3, null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 4, 6, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 1, 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 1, 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, 532, 345));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 234, 42, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 42, -2));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -3, -42));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 5L, 0L, 3L, 1L, 2L, 0L, 2L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, true, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, 532, null, 234, null, 42, null, null, -3);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, 345, null, 42, null, -2, null, null, -42);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testStaticBuildInt32() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32")), (BoundaryOrder)BoundaryOrder.DESCENDING, Arrays.asList(false, false, false, true, true, true), Arrays.asList(0L, 10L, 0L, 3L, 5L, 7L), TestColumnIndexBuilder.toBBList(10, 8, 6, null, null, null), TestColumnIndexBuilder.toBBList(9, 7, 5, null, null, null));
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 10L, 0L, 3L, 5L, 7L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, true, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), 9, 7, 5, null, null, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), 10, 8, 6, null, null, null);
    }

    @Test
    public void testBuildUInt8() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_8)).named("test_uint8");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(IntColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.IntColumn col = FilterApi.intColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, 4, 10));
        builder.add(sb.stats(type, 11, 17, null));
        builder.add(sb.stats(type, 2, 2, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 1, 255));
        builder.add(sb.stats(type, 239, 250));
        Assert.assertEquals((long)6L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 0L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), 10, 17, 2, null, 255, 250);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), 4, 11, 2, null, 1, 239);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 3, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Integer.valueOf(239)), 0, 1, 2, 4);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Integer.valueOf(239)), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class), 0, 1, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 0, 0, null, null));
        builder.add(sb.stats(type, 0, 42, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 42, 238));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 239, 255));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 1L, 2L, 3L, 0L, 2L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, 0, 42, null, null, 238, null, 255, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, 0, 0, null, null, 42, null, 239, null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 4, 6, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Integer.valueOf(2)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Integer.valueOf(238)), 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Integer.valueOf(238)), 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Integer.valueOf(42)), 1, 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Integer.valueOf(42)), 1, 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, 255, 255));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 239, 234, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 238, 42));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 41, 0));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 5L, 0L, 3L, 1L, 2L, 0L, 2L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, true, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, 255, null, 239, null, 238, null, null, 41);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, 255, null, 234, null, 42, null, null, 0);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Integer.valueOf(171)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Integer.valueOf(255)), 0, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Integer.valueOf(255)), new int[0]);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Integer.valueOf(255)), 1);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Integer.valueOf(42)), 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Integer.valueOf(42)), 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, IntegerIsDivisableWith3.class)), 0, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testBuildInt64() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("test_int64");
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        Assert.assertThat((Object)builder, (Matcher)CoreMatchers.instanceOf(LongColumnIndexBuilder.class));
        Assert.assertNull((Object)builder.build());
        Operators.LongColumn col = FilterApi.longColumn((String)"test_col");
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats(type, -4L, 10L));
        builder.add(sb.stats(type, -11L, 7L, null));
        builder.add(sb.stats(type, 2L, 2L, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 1L, 2L));
        builder.add(sb.stats(type, -21L, 8L));
        Assert.assertEquals((long)6L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        ColumnIndex columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 0L, 1L, 2L, 3L, 0L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, false, false, false, true, false, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), 10L, 7L, 2L, null, 2L, 8L);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), -4L, -11L, 2L, null, 1L, -21L);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Long.valueOf(0L)), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 1, 2, 3);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Long.valueOf(0L)), 0, 1, 2, 3, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Long.valueOf(2L)), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Long.valueOf(2L)), 0, 1, 2, 4, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Long.valueOf(-21L)), new int[0]);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Long.valueOf(-21L)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, LongIsDivisableWith3.class), 0, 1, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, LongIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -532L, -345L, null, null));
        builder.add(sb.stats(type, -234L, -42L, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, -42L, 2L));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -3L, 42L));
        builder.add(sb.stats(type, null, null));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 2L, 2L, 1L, 2L, 3L, 0L, 2L, 0L, 2L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, false, true, true, false, true, false, true);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, -345L, -42L, null, null, 2L, null, 42L, null);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, -532L, -234L, null, null, -42L, null, -3L, null);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Long.valueOf(-42L)), 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 1, 2, 3, 4, 6, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Long.valueOf(-42L)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Long.valueOf(2L)), 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Long.valueOf(2L)), 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Long.valueOf(-42L)), 1, 2);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Long.valueOf(-42L)), 1, 2, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, LongIsDivisableWith3.class), 1, 2, 5, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, LongIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
        sb = new StatsBuilder();
        builder.add(sb.stats(type, null, null, null, null, null));
        builder.add(sb.stats(type, 532L, 345L));
        builder.add(sb.stats(type, null, null, null));
        builder.add(sb.stats(type, 234L, 42L, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, 42L, -2L));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, null, null));
        builder.add(sb.stats(type, -3L, -42L));
        Assert.assertEquals((long)9L, (long)builder.getPageCount());
        Assert.assertEquals((long)sb.getMinMaxSize(), (long)builder.getMinMaxSize());
        columnIndex = builder.build();
        Assert.assertEquals((Object)BoundaryOrder.DESCENDING, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 5L, 0L, 3L, 1L, 2L, 0L, 2L, 2L, 0L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, true, false, true, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, 532L, null, 234L, null, 42L, null, null, -3L);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, 345L, null, 42L, null, -2L, null, null, -42L);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, (Comparable)Long.valueOf(0L)), 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.eq((Operators.Column)col, null), 0, 2, 3, 4, 6, 7);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, (Comparable)Long.valueOf(0L)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.notEq((Operators.Column)col, null), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gt((Operators.Column)col, (Comparable)Long.valueOf(2L)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.gtEq((Operators.Column)col, (Comparable)Long.valueOf(2L)), 1, 3, 5);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.lt((Operators.Column)col, (Comparable)Long.valueOf(-42L)), new int[0]);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.ltEq((Operators.Column)col, (Comparable)Long.valueOf(-42L)), 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, (FilterPredicate)FilterApi.userDefined((Operators.Column)col, LongIsDivisableWith3.class), 1, 3, 5, 8);
        TestColumnIndexBuilder.assertCorrectFiltering(columnIndex, LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)col, LongIsDivisableWith3.class)), 0, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testStaticBuildInt64() {
        ColumnIndex columnIndex = ColumnIndexBuilder.build((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("test_int64")), (BoundaryOrder)BoundaryOrder.UNORDERED, Arrays.asList(true, false, true, false, true, false), Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L), TestColumnIndexBuilder.toBBList(null, 2L, null, 4L, null, 9L), TestColumnIndexBuilder.toBBList(null, 3L, null, 15L, null, 10L));
        Assert.assertEquals((Object)BoundaryOrder.UNORDERED, (Object)columnIndex.getBoundaryOrder());
        TestColumnIndexBuilder.assertCorrectNullCounts(columnIndex, 1L, 2L, 3L, 4L, 5L, 6L);
        TestColumnIndexBuilder.assertCorrectNullPages(columnIndex, true, false, true, false, true, false);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMaxValues(), null, 3L, null, 15L, null, 10L);
        TestColumnIndexBuilder.assertCorrectValues((List<ByteBuffer>)columnIndex.getMinValues(), null, 2L, null, 4L, null, 9L);
    }

    @Test
    public void testNoOpBuilder() {
        ColumnIndexBuilder builder = ColumnIndexBuilder.getNoOpBuilder();
        StatsBuilder sb = new StatsBuilder();
        builder.add(sb.stats((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("test_binary_utf8"), TestColumnIndexBuilder.stringBinary("Jeltz"), TestColumnIndexBuilder.stringBinary("Slartibartfast"), null, null));
        builder.add(sb.stats((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("test_boolean"), true, true, null, null));
        builder.add(sb.stats((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("test_double"), null, null, null));
        builder.add(sb.stats((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32"), null, null));
        builder.add(sb.stats((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("test_int64"), -234L, -42L, null));
        Assert.assertEquals((long)0L, (long)builder.getPageCount());
        Assert.assertEquals((long)0L, (long)builder.getMinMaxSize());
        Assert.assertNull((Object)builder.build());
    }

    private static List<ByteBuffer> toBBList(Binary ... values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.length);
        for (Binary value : values) {
            if (value == null) {
                buffers.add(ByteBuffer.allocate(0));
                continue;
            }
            buffers.add(value.toByteBuffer());
        }
        return buffers;
    }

    private static List<ByteBuffer> toBBList(Boolean ... values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.length);
        for (Boolean value : values) {
            if (value == null) {
                buffers.add(ByteBuffer.allocate(0));
                continue;
            }
            buffers.add(ByteBuffer.wrap(BytesUtils.booleanToBytes((boolean)value)));
        }
        return buffers;
    }

    private static List<ByteBuffer> toBBList(Double ... values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.length);
        for (Double value : values) {
            if (value == null) {
                buffers.add(ByteBuffer.allocate(0));
                continue;
            }
            buffers.add(ByteBuffer.wrap(BytesUtils.longToBytes((long)Double.doubleToLongBits(value))));
        }
        return buffers;
    }

    private static List<ByteBuffer> toBBList(Float ... values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.length);
        for (Float value : values) {
            if (value == null) {
                buffers.add(ByteBuffer.allocate(0));
                continue;
            }
            buffers.add(ByteBuffer.wrap(BytesUtils.intToBytes((int)Float.floatToIntBits(value.floatValue()))));
        }
        return buffers;
    }

    private static List<ByteBuffer> toBBList(Integer ... values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.length);
        for (Integer value : values) {
            if (value == null) {
                buffers.add(ByteBuffer.allocate(0));
                continue;
            }
            buffers.add(ByteBuffer.wrap(BytesUtils.intToBytes((int)value)));
        }
        return buffers;
    }

    private static List<ByteBuffer> toBBList(Long ... values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.length);
        for (Long value : values) {
            if (value == null) {
                buffers.add(ByteBuffer.allocate(0));
                continue;
            }
            buffers.add(ByteBuffer.wrap(BytesUtils.longToBytes((long)value)));
        }
        return buffers;
    }

    private static Binary decimalBinary(String num) {
        return Binary.fromConstantByteArray((byte[])new BigDecimal(num).unscaledValue().toByteArray());
    }

    private static Binary stringBinary(String str) {
        return Binary.fromString((String)str);
    }

    private static void assertCorrectValues(List<ByteBuffer> values, Binary ... expectedValues) {
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (int i = 0; i < expectedValues.length; ++i) {
            Binary expectedValue = expectedValues[i];
            ByteBuffer value = values.get(i);
            if (expectedValue == null) {
                Assert.assertFalse((String)"The byte buffer should be empty for null pages", (boolean)value.hasRemaining());
                continue;
            }
            Assert.assertArrayEquals((String)("Invalid value for page " + i), (byte[])expectedValue.getBytesUnsafe(), (byte[])value.array());
        }
    }

    private static void assertCorrectValues(List<ByteBuffer> values, Boolean ... expectedValues) {
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (int i = 0; i < expectedValues.length; ++i) {
            Boolean expectedValue = expectedValues[i];
            ByteBuffer value = values.get(i);
            if (expectedValue == null) {
                Assert.assertFalse((String)"The byte buffer should be empty for null pages", (boolean)value.hasRemaining());
                continue;
            }
            Assert.assertEquals((String)"The byte buffer should be 1 byte long for boolean", (long)1L, (long)value.remaining());
            Assert.assertEquals((String)("Invalid value for page " + i), (Object)expectedValue, (Object)(value.get(0) != 0 ? 1 : 0));
        }
    }

    private static void assertCorrectValues(List<ByteBuffer> values, Double ... expectedValues) {
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (int i = 0; i < expectedValues.length; ++i) {
            Double expectedValue = expectedValues[i];
            ByteBuffer value = values.get(i);
            if (expectedValue == null) {
                Assert.assertFalse((String)"The byte buffer should be empty for null pages", (boolean)value.hasRemaining());
                continue;
            }
            Assert.assertEquals((String)"The byte buffer should be 8 bytes long for double", (long)8L, (long)value.remaining());
            Assert.assertTrue((String)("Invalid value for page " + i), (Double.compare(expectedValue, value.getDouble(0)) == 0 ? 1 : 0) != 0);
        }
    }

    private static void assertCorrectValues(List<ByteBuffer> values, Float ... expectedValues) {
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (int i = 0; i < expectedValues.length; ++i) {
            Float expectedValue = expectedValues[i];
            ByteBuffer value = values.get(i);
            if (expectedValue == null) {
                Assert.assertFalse((String)"The byte buffer should be empty for null pages", (boolean)value.hasRemaining());
                continue;
            }
            Assert.assertEquals((String)"The byte buffer should be 4 bytes long for double", (long)4L, (long)value.remaining());
            Assert.assertTrue((String)("Invalid value for page " + i), (Float.compare(expectedValue.floatValue(), value.getFloat(0)) == 0 ? 1 : 0) != 0);
        }
    }

    private static void assertCorrectValues(List<ByteBuffer> values, Integer ... expectedValues) {
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (int i = 0; i < expectedValues.length; ++i) {
            Integer expectedValue = expectedValues[i];
            ByteBuffer value = values.get(i);
            if (expectedValue == null) {
                Assert.assertFalse((String)"The byte buffer should be empty for null pages", (boolean)value.hasRemaining());
                continue;
            }
            Assert.assertEquals((String)"The byte buffer should be 4 bytes long for int32", (long)4L, (long)value.remaining());
            Assert.assertEquals((String)("Invalid value for page " + i), (long)expectedValue.intValue(), (long)value.getInt(0));
        }
    }

    private static void assertCorrectValues(List<ByteBuffer> values, Long ... expectedValues) {
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (int i = 0; i < expectedValues.length; ++i) {
            Long expectedValue = expectedValues[i];
            ByteBuffer value = values.get(i);
            if (expectedValue == null) {
                Assert.assertFalse((String)"The byte buffer should be empty for null pages", (boolean)value.hasRemaining());
                continue;
            }
            Assert.assertEquals((String)"The byte buffer should be 8 bytes long for int64", (long)8L, (long)value.remaining());
            Assert.assertEquals((String)("Invalid value for page " + i), (long)expectedValue.intValue(), (long)value.getLong(0));
        }
    }

    private static void assertCorrectNullCounts(ColumnIndex columnIndex, long ... expectedNullCounts) {
        List nullCounts = columnIndex.getNullCounts();
        Assert.assertEquals((long)expectedNullCounts.length, (long)nullCounts.size());
        for (int i = 0; i < expectedNullCounts.length; ++i) {
            Assert.assertEquals((String)("Invalid null count at page " + i), (long)expectedNullCounts[i], (long)((Long)nullCounts.get(i)));
        }
    }

    private static void assertCorrectNullPages(ColumnIndex columnIndex, boolean ... expectedNullPages) {
        List nullPages = columnIndex.getNullPages();
        Assert.assertEquals((long)expectedNullPages.length, (long)nullPages.size());
        for (int i = 0; i < expectedNullPages.length; ++i) {
            Assert.assertEquals((String)("Invalid null pages at page " + i), (Object)expectedNullPages[i], (Object)((Boolean)nullPages.get(i)));
        }
    }

    private static void assertCorrectFiltering(ColumnIndex ci, FilterPredicate predicate, int ... expectedIndexes) {
        TestIndexIterator.assertEquals((PrimitiveIterator.OfInt)predicate.accept((FilterPredicate.Visitor)ci), expectedIndexes);
    }

    static /* synthetic */ Binary access$000(String x0) {
        return TestColumnIndexBuilder.decimalBinary(x0);
    }

    static /* synthetic */ Binary access$100(String x0) {
        return TestColumnIndexBuilder.stringBinary(x0);
    }

    private static class StatsBuilder {
        private long minMaxSize;

        private StatsBuilder() {
        }

        Statistics<?> stats(PrimitiveType type, Object ... values) {
            Statistics stats = Statistics.createStats((Type)type);
            block8: for (Object value : values) {
                if (value == null) {
                    stats.incrementNumNulls();
                    continue;
                }
                switch (type.getPrimitiveTypeName()) {
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: 
                    case INT96: {
                        stats.updateStats((Binary)value);
                        continue block8;
                    }
                    case BOOLEAN: {
                        stats.updateStats(((Boolean)value).booleanValue());
                        continue block8;
                    }
                    case DOUBLE: {
                        stats.updateStats(((Double)value).doubleValue());
                        continue block8;
                    }
                    case FLOAT: {
                        stats.updateStats(((Float)value).floatValue());
                        continue block8;
                    }
                    case INT32: {
                        stats.updateStats(((Integer)value).intValue());
                        continue block8;
                    }
                    case INT64: {
                        stats.updateStats(((Long)value).longValue());
                        continue block8;
                    }
                    default: {
                        Assert.fail((String)("Unsupported value type for stats: " + value.getClass()));
                    }
                }
            }
            if (stats.hasNonNullValue()) {
                this.minMaxSize += (long)stats.getMinBytes().length;
                this.minMaxSize += (long)stats.getMaxBytes().length;
            }
            return stats;
        }

        long getMinMaxSize() {
            return this.minMaxSize;
        }
    }

    public static class LongIsDivisableWith3
    extends UserDefinedPredicate<Long> {
        public boolean keep(Long value) {
            return value != null && value % 3L == 0L;
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Long> statistics) {
            long min = (Long)statistics.getMin();
            long max = (Long)statistics.getMax();
            return min % 3L != 0L && max % 3L != 0L && max - min < 3L;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Long> statistics) {
            long max;
            long min = (Long)statistics.getMin();
            return min == (max = ((Long)statistics.getMax()).longValue()) && min % 3L == 0L;
        }
    }

    public static class IntegerIsDivisableWith3
    extends UserDefinedPredicate<Integer> {
        public boolean keep(Integer value) {
            return value != null && value % 3 == 0;
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Integer> statistics) {
            int min = (Integer)statistics.getMin();
            int max = (Integer)statistics.getMax();
            return min % 3 != 0 && max % 3 != 0 && max - min < 3;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Integer> statistics) {
            int max;
            int min = (Integer)statistics.getMin();
            return min == (max = ((Integer)statistics.getMax()).intValue()) && min % 3 == 0;
        }
    }

    public static class FloatIsInteger
    extends UserDefinedPredicate<Float> {
        private static float floor(float value) {
            return (float)Math.floor(value);
        }

        public boolean keep(Float value) {
            return value != null && Math.floor(value.floatValue()) == (double)value.floatValue();
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Float> statistics) {
            float min = ((Float)statistics.getMin()).floatValue();
            float max = ((Float)statistics.getMax()).floatValue();
            Comparator cmp = statistics.getComparator();
            return cmp.compare(Float.valueOf(FloatIsInteger.floor(min)), Float.valueOf(FloatIsInteger.floor(max))) == 0 && cmp.compare(Float.valueOf(FloatIsInteger.floor(min)), Float.valueOf(min)) != 0 && cmp.compare(Float.valueOf(FloatIsInteger.floor(max)), Float.valueOf(max)) != 0;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Float> statistics) {
            float min = ((Float)statistics.getMin()).floatValue();
            float max = ((Float)statistics.getMax()).floatValue();
            Comparator cmp = statistics.getComparator();
            return cmp.compare(Float.valueOf(min), Float.valueOf(max)) == 0 && cmp.compare(Float.valueOf(FloatIsInteger.floor(min)), Float.valueOf(min)) == 0;
        }
    }

    public static class DoubleIsInteger
    extends UserDefinedPredicate<Double> {
        public boolean keep(Double value) {
            return value != null && Math.floor(value) == value;
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Double> statistics) {
            double min = (Double)statistics.getMin();
            double max = (Double)statistics.getMax();
            Comparator cmp = statistics.getComparator();
            return cmp.compare(Math.floor(min), Math.floor(max)) == 0 && cmp.compare(Math.floor(min), min) != 0 && cmp.compare(Math.floor(max), max) != 0;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Double> statistics) {
            double min = (Double)statistics.getMin();
            double max = (Double)statistics.getMax();
            Comparator cmp = statistics.getComparator();
            return cmp.compare(min, max) == 0 && cmp.compare(Math.floor(min), min) == 0;
        }
    }

    public static class BooleanIsTrueOrNull
    extends UserDefinedPredicate<Boolean> {
        public boolean keep(Boolean value) {
            return value == null || value != false;
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Boolean> statistics) {
            return statistics.getComparator().compare((Boolean)statistics.getMax(), true) != 0;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Boolean> statistics) {
            return statistics.getComparator().compare((Boolean)statistics.getMin(), true) == 0;
        }
    }

    public static class BinaryUtf8StartsWithB
    extends UserDefinedPredicate<Binary> {
        private static final Binary B = TestColumnIndexBuilder.access$100("B");
        private static final Binary C = TestColumnIndexBuilder.access$100("C");

        public boolean keep(Binary value) {
            return value != null && value.length() > 0 && value.getBytesUnsafe()[0] == 66;
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Binary> statistics) {
            Comparator cmp = statistics.getComparator();
            return cmp.compare((Binary)statistics.getMin(), C) >= 0 || cmp.compare((Binary)statistics.getMax(), B) < 0;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Binary> statistics) {
            Comparator cmp = statistics.getComparator();
            return cmp.compare((Binary)statistics.getMin(), B) >= 0 && cmp.compare((Binary)statistics.getMax(), C) < 0;
        }
    }

    public static class BinaryDecimalIsNullOrZeroUdp
    extends UserDefinedPredicate<Binary> {
        private static final Binary ZERO = TestColumnIndexBuilder.access$000("0.0");

        public boolean keep(Binary value) {
            return value == null || value.equals((Object)ZERO);
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Binary> statistics) {
            Comparator cmp = statistics.getComparator();
            return cmp.compare((Binary)statistics.getMin(), ZERO) > 0 || cmp.compare((Binary)statistics.getMax(), ZERO) < 0;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Binary> statistics) {
            Comparator cmp = statistics.getComparator();
            return cmp.compare((Binary)statistics.getMin(), ZERO) == 0 && cmp.compare((Binary)statistics.getMax(), ZERO) == 0;
        }
    }
}

