/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class FixedBinaryTestUtils {
    public static Binary getFixedBinary(int length, BigInteger bigInt) {
        byte[] array = bigInt.toByteArray();
        if (array.length == length) {
            return Binary.fromConstantByteArray((byte[])array);
        }
        if (array.length < length) {
            byte[] padded = new byte[length];
            int paddingLength = length - array.length;
            if (bigInt.signum() < 0) {
                Arrays.fill(padded, 0, paddingLength, (byte)-1);
            } else {
                Arrays.fill(padded, 0, paddingLength, (byte)0);
            }
            System.arraycopy(array, 0, padded, paddingLength, array.length);
            return Binary.fromConstantByteArray((byte[])padded);
        }
        throw new IllegalArgumentException("Specified BigInteger (" + bigInt + ") is too long for fixed bytes (" + array.length + '>' + length + ')');
    }

    public static Binary getFixedBinary(PrimitiveType type, BigInteger bigInt) {
        switch (type.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: {
                return FixedBinaryTestUtils.getFixedBinary(type.getTypeLength(), bigInt);
            }
            case INT96: {
                return FixedBinaryTestUtils.getFixedBinary(12, bigInt);
            }
            case BINARY: {
                return Binary.fromConstantByteArray((byte[])bigInt.toByteArray());
            }
        }
        throw new IllegalArgumentException("Type " + type + " cannot be represented by a Binary");
    }

    @Test
    public void testGetFixedBinary() {
        Assert.assertArrayEquals((byte[])FixedBinaryTestUtils.b(255, 255, 255, 255, 255, 255, 128, 0, 0, 0), (byte[])FixedBinaryTestUtils.getFixedBinary(10, BigInteger.valueOf(Integer.MIN_VALUE)).getBytes());
        Assert.assertArrayEquals((byte[])FixedBinaryTestUtils.b(255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255), (byte[])FixedBinaryTestUtils.getFixedBinary(11, BigInteger.valueOf(-1L)).getBytes());
        Assert.assertArrayEquals((byte[])FixedBinaryTestUtils.b(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), (byte[])FixedBinaryTestUtils.getFixedBinary(12, BigInteger.valueOf(0L)).getBytes());
        Assert.assertArrayEquals((byte[])FixedBinaryTestUtils.b(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1), (byte[])FixedBinaryTestUtils.getFixedBinary(13, BigInteger.valueOf(1L)).getBytes());
        Assert.assertArrayEquals((byte[])FixedBinaryTestUtils.b(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255), (byte[])FixedBinaryTestUtils.getFixedBinary(14, BigInteger.valueOf(Integer.MAX_VALUE)).getBytes());
    }

    public void assertCorrectBytes(byte[] expectedBytes, int length, BigInteger bigInt) {
        byte[] actualBytes = FixedBinaryTestUtils.getFixedBinary(length, bigInt).getBytes();
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
        Assert.assertEquals((Object)bigInt, (Object)new BigInteger(actualBytes));
    }

    private static byte[] b(int ... bytes) {
        byte[] arr = new byte[bytes.length];
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i] = (byte)bytes[i];
        }
        return arr;
    }
}

