/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bytestreamsplit;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForDouble;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForFLBA;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForFloat;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForInteger;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForLong;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class ByteStreamSplitValuesReaderTest {
    private static <Reader extends ValuesReader> Reader makeReader(byte[] input, int length, Class<Reader> cls) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(input);
        ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
        ValuesReader reader = (ValuesReader)cls.newInstance();
        reader.initFromPage(length, stream);
        return (Reader)reader;
    }

    public static class FixedLenByteArrayTest {
        private static ByteStreamSplitValuesReaderForFLBA makeReader(byte[] input, int valuesCount) throws Exception {
            ByteBuffer buffer = ByteBuffer.wrap(input);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForFLBA reader = new ByteStreamSplitValuesReaderForFLBA(input.length / valuesCount);
            reader.initFromPage(valuesCount, stream);
            return reader;
        }

        private void testReader(byte[] input, byte[][] values) throws Exception {
            ByteStreamSplitValuesReaderForFLBA reader = FixedLenByteArrayTest.makeReader(input, values.length);
            Binary previousExpected = null;
            Binary previousActual = null;
            for (byte[] expectedValue : values) {
                Binary expected = Binary.fromReusedByteArray((byte[])expectedValue);
                Binary actual = reader.readBytes();
                Assert.assertEquals((Object)expected, (Object)actual);
                if (previousExpected != null) {
                    Assert.assertEquals((Object)previousExpected, previousActual);
                }
                previousExpected = expected;
                previousActual = actual;
            }
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readBytes());
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{18, 52, 86};
            byte[][] values = new byte[][]{{18, 52, 86}};
            this.testReader(byteData, values);
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{18, 52, 86, 120, -102, -68};
            byte[][] values = new byte[][]{{18, 86, -102}, {52, 120, -68}};
            this.testReader(byteData, values);
        }
    }

    public static class LongTest {
        private void testReader(byte[] input, long[] values) throws Exception {
            ByteStreamSplitValuesReaderForLong reader = (ByteStreamSplitValuesReaderForLong)ByteStreamSplitValuesReaderTest.makeReader(input, values.length, ByteStreamSplitValuesReaderForLong.class);
            for (long expectedValue : values) {
                long actual = reader.readLong();
                Assert.assertEquals((long)expectedValue, (long)actual);
            }
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readLong());
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{18, 52, 86, 120, -102, -68, -34, -16};
            this.testReader(byteData, new long[]{-1090226688147180526L});
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
            this.testReader(byteData, new long[]{-1239428294625713664L, -9645356378410223L});
        }
    }

    public static class IntegerTest {
        private void testReader(byte[] input, int[] values) throws Exception {
            ByteStreamSplitValuesReaderForInteger reader = (ByteStreamSplitValuesReaderForInteger)ByteStreamSplitValuesReaderTest.makeReader(input, values.length, ByteStreamSplitValuesReaderForInteger.class);
            for (int expectedValue : values) {
                int actual = reader.readInteger();
                Assert.assertEquals((long)expectedValue, (long)actual);
            }
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readInteger());
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{18, 52, 86, 120};
            this.testReader(byteData, new int[]{2018915346});
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{18, 52, 86, 120, -102, -68, -34, -16};
            this.testReader(byteData, new int[]{-560310766, -256083916});
        }
    }

    public static class DoubleTest {
        private void testReader(byte[] input, double[] values) throws Exception {
            ByteStreamSplitValuesReaderForDouble reader = (ByteStreamSplitValuesReaderForDouble)ByteStreamSplitValuesReaderTest.makeReader(input, values.length, ByteStreamSplitValuesReaderForDouble.class);
            for (double expectedValue : values) {
                double d = reader.readDouble();
                Assert.assertEquals((double)expectedValue, (double)d, (double)0.0);
            }
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readDouble());
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{-2, -1, -1, 13, -88, 119, -46, 64};
            this.testReader(byteData, new double[]{18910.62585449218});
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{-25, 114, -66, 9, -95, -63, 10, 10, 23, -41, 33, 38, 1, -57, 83, 10, 70, 5, 112, -13, -28, 64, -64, 63};
            double[] expectedValues = new double[]{256.625449218, -78956.4455667788, 0.62565};
            this.testReader(byteData, expectedValues);
        }

        @Test
        public void testRandomInput() throws Exception {
            Random rand = new Random(6557L);
            int numElements = 256;
            byte[] byteData = new byte[2048];
            double[] values = new double[256];
            for (int i = 0; i < 256; ++i) {
                double f;
                values[i] = f = rand.nextDouble() * 8192.0;
                long fAsLong = Double.doubleToLongBits(f);
                for (int j = 0; j < 8; ++j) {
                    byteData[256 * j + i] = (byte)(fAsLong >> 8 * j & 0xFFL);
                }
            }
            this.testReader(byteData, values);
        }
    }

    public static class FloatTest {
        private void testReader(byte[] input, float[] values) throws Exception {
            ByteStreamSplitValuesReaderForFloat reader = (ByteStreamSplitValuesReaderForFloat)ByteStreamSplitValuesReaderTest.makeReader(input, values.length, ByteStreamSplitValuesReaderForFloat.class);
            for (float expectedValue : values) {
                float f = reader.readFloat();
                Assert.assertEquals((float)expectedValue, (float)f, (float)0.0f);
            }
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readFloat());
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{0, 0, 16, 64};
            this.testReader(byteData, new float[]{2.25f});
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{64, 0, -128, 64, 5, -124, -59, -67, 50, -62, 65, 66};
            float[] expectedValues = new float[]{-98.62549f, 23.627441f, 44.629395f};
            this.testReader(byteData, expectedValues);
        }

        @Test
        public void testRandomInput() throws Exception {
            Random rand = new Random(1337L);
            int numElements = 256;
            byte[] byteData = new byte[1024];
            float[] values = new float[256];
            for (int i = 0; i < 256; ++i) {
                float f;
                values[i] = f = rand.nextFloat() * 1024.0f;
                int fAsInt = Float.floatToIntBits(f);
                byteData[i] = (byte)(fAsInt & 0xFF);
                byteData[256 + i] = (byte)(fAsInt >> 8 & 0xFF);
                byteData[512 + i] = (byte)(fAsInt >> 16 & 0xFF);
                byteData[768 + i] = (byte)(fAsInt >> 24 & 0xFF);
            }
            this.testReader(byteData, values);
        }

        @Test
        public void testExtraReads() throws Exception {
            byte[] byteData = new byte[]{0, 0, 16, 64};
            ByteStreamSplitValuesReaderForFloat reader = (ByteStreamSplitValuesReaderForFloat)ByteStreamSplitValuesReaderTest.makeReader(byteData, 1, ByteStreamSplitValuesReaderForFloat.class);
            float f = reader.readFloat();
            Assert.assertEquals((float)2.25f, (float)f, (float)0.0f);
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readFloat());
        }

        @Test
        public void testSkip() throws Exception {
            byte[] byteData = new byte[16];
            for (int i = 0; i < 16; ++i) {
                byteData[i] = -1;
            }
            byteData[3] = 0;
            byteData[7] = 0;
            byteData[11] = 16;
            byteData[15] = 64;
            ByteStreamSplitValuesReaderForFloat reader = (ByteStreamSplitValuesReaderForFloat)ByteStreamSplitValuesReaderTest.makeReader(byteData, 4, ByteStreamSplitValuesReaderForFloat.class);
            reader.skip(3);
            float f = reader.readFloat();
            Assert.assertEquals((float)2.25f, (float)f, (float)0.0f);
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.readFloat());
        }

        @Test
        public void testSkipOverflow() throws Exception {
            byte[] byteData = new byte[128];
            ByteStreamSplitValuesReaderForFloat reader = (ByteStreamSplitValuesReaderForFloat)ByteStreamSplitValuesReaderTest.makeReader(byteData, 32, ByteStreamSplitValuesReaderForFloat.class);
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.skip(33));
        }

        @Test
        public void testSkipUnderflow() throws Exception {
            byte[] byteData = new byte[128];
            ByteStreamSplitValuesReaderForFloat reader = (ByteStreamSplitValuesReaderForFloat)ByteStreamSplitValuesReaderTest.makeReader(byteData, 32, ByteStreamSplitValuesReaderForFloat.class);
            Assert.assertThrows(ParquetDecodingException.class, () -> reader.skip(-1));
        }
    }
}

