/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.parser;

import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestParquetParser {
    @Test
    public void testPaperExample() {
        String example = "message Document {\n  required int64 DocId;\n  optional group Links {\n    repeated int64 Backward;\n    repeated int64 Forward; }\n  repeated group Name {\n    repeated group Language {\n      required binary Code;\n      required binary Country; }\n    optional binary Url; }}";
        MessageType parsed = MessageTypeParser.parseMessageType((String)example);
        MessageType manuallyMade = new MessageType("Document", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")}), new GroupType(Type.Repetition.REPEATED, "Name", new Type[]{new GroupType(Type.Repetition.REPEATED, "Language", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Code"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Country")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Url")})});
        Assert.assertEquals((Object)manuallyMade, (Object)parsed);
        MessageType parsedThenReparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)manuallyMade, (Object)parsedThenReparsed);
        parsed = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;} required group c { required int64 d; }}");
        manuallyMade = new MessageType("m", new Type[]{new GroupType(Type.Repetition.REQUIRED, "a", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "b")}), new GroupType(Type.Repetition.REQUIRED, "c", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "d")})});
        Assert.assertEquals((Object)manuallyMade, (Object)parsed);
        parsedThenReparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)manuallyMade, (Object)parsedThenReparsed);
    }

    @Test
    public void testEachPrimitiveType() {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        StringBuilder schema = new StringBuilder();
        schema.append("message EachType {\n");
        for (PrimitiveType.PrimitiveTypeName type : PrimitiveType.PrimitiveTypeName.values()) {
            if (type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                schema.append("  required fixed_len_byte_array(3) fixed_;");
                ((Types.PrimitiveBuilder)builder.required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(3)).named("fixed_");
                continue;
            }
            schema.append("  required ").append(type).append(" ").append(type).append("_;\n");
            builder.required(type).named(type.toString() + "_");
        }
        schema.append("}\n");
        MessageType expected = builder.named("EachType");
        MessageType parsed = MessageTypeParser.parseMessageType((String)schema.toString());
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testSTRINGAnnotation() {
        String message = "message StringMessage {\n  required binary string (STRING);\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("string")).named("StringMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testUTF8Annotation() {
        String message = "message StringMessage {\n  required binary string (UTF8);\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string")).named("StringMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testIDs() {
        String message = "message Message {\n  required binary string (UTF8) = 6;\n  required int32 i=1;\n  required binary s2= 3;\n  required binary s3 =4;\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).id(6)).named("string")).required(PrimitiveType.PrimitiveTypeName.INT32).id(1)).named("i")).required(PrimitiveType.PrimitiveTypeName.BINARY).id(3)).named("s2")).required(PrimitiveType.PrimitiveTypeName.BINARY).id(4)).named("s3")).named("Message");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testMAPAnnotations() {
        String message = "message Message {\n  optional group aMap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().as(OriginalType.MAP_KEY_VALUE)).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("value")).named("map")).named("aMap")).named("Message");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testLISTAnnotation() {
        String message = "message Message {\n  required group aList (LIST) {\n    repeated binary string (UTF8);\n  }\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().requiredGroup().as(OriginalType.LIST)).repeated(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string")).named("aList")).named("Message");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testDecimalFixedAnnotation() {
        String message = "message DecimalMessage {\n  required FIXED_LEN_BYTE_ARRAY(4) aDecimal (DECIMAL(9,2));\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testDecimalBinaryAnnotation() {
        String message = "message DecimalMessage {\n  required binary aDecimal (DECIMAL(9,2));\n}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testTimeAnnotations() {
        String message = "message TimeMessage {  required int32 date (DATE);  required int32 time (TIME_MILLIS);  required int64 timestamp (TIMESTAMP_MILLIS);  required FIXED_LEN_BYTE_ARRAY(12) interval (INTERVAL);  required int32 newTime (TIME(MILLIS,true));  required int64 nanoTime (TIME(NANOS,true));  required int64 newTimestamp (TIMESTAMP(MILLIS,false));  required int64 nanoTimestamp (TIMESTAMP(NANOS,false));}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DATE)).named("date")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.TIME_MILLIS)).named("time")).required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MILLIS)).named("timestamp")).required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named("interval")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("newTime")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("nanoTime")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("newTimestamp")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("nanoTimestamp")).named("TimeMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testIntAnnotations() {
        String message = "message IntMessage {  required int32 i8 (INT_8);  required int32 i16 (INT_16);  required int32 i32 (INT_32);  required int64 i64 (INT_64);  required int32 u8 (UINT_8);  required int32 u16 (UINT_16);  required int32 u32 (UINT_32);  required int64 u64 (UINT_64);}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_8)).named("i8")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_16)).named("i16")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_32)).named("i32")).required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.INT_64)).named("i64")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_8)).named("u8")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_16)).named("u16")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_32)).named("u32")).required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.UINT_64)).named("u64")).named("IntMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testIntegerAnnotations() {
        String message = "message IntMessage {  required int32 i8 (INTEGER(8,true));  required int32 i16 (INTEGER(16,true));  required int32 i32 (INTEGER(32,true));  required int64 i64 (INTEGER(64,true));  required int32 u8 (INTEGER(8,false));  required int32 u16 (INTEGER(16,false));  required int32 u32 (INTEGER(32,false));  required int64 u64 (INTEGER(64,false));}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named("i8")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named("i16")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)true))).named("i32")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)true))).named("i64")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)false))).named("u8")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)false))).named("u16")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)false))).named("u32")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)false))).named("u64")).named("IntMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }

    @Test
    public void testEmbeddedAnnotations() {
        String message = "message EmbeddedMessage {  required binary json (JSON);  required binary bson (BSON);}\n";
        MessageType parsed = MessageTypeParser.parseMessageType((String)message);
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.JSON)).named("json")).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.BSON)).named("bson")).named("EmbeddedMessage");
        Assert.assertEquals((Object)expected, (Object)parsed);
        MessageType reparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)expected, (Object)reparsed);
    }
}

