/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ResourceIntensiveTestRule
implements TestRule {
    private static final TestRule INSTANCE = new ResourceIntensiveTestRule(Boolean.getBoolean("enableResourceIntensiveTests"));
    private final boolean enabled;

    public static TestRule get() {
        return INSTANCE;
    }

    private ResourceIntensiveTestRule(boolean enabled) {
        this.enabled = enabled;
    }

    public Statement apply(Statement base, Description description) {
        return this.enabled ? base : new Statement(){

            public void evaluate() {
                Assume.assumeTrue((String)"Resource intensive test is not executed due to the limitations of the environment", (boolean)ResourceIntensiveTestRule.this.enabled);
            }
        };
    }
}

