/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.mem;

import java.io.IOException;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMemPageStore {
    private static final Logger LOG = LoggerFactory.getLogger(TestMemPageStore.class);
    private String[] path = new String[]{"foo", "bar"};

    @Test
    public void test() throws IOException {
        DataPage readPage;
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnDescriptor col = new ColumnDescriptor(this.path, PrimitiveType.PrimitiveTypeName.INT64, 2, 2);
        LongStatistics stats = new LongStatistics();
        PageWriter pageWriter = memPageStore.getPageWriter(col);
        pageWriter.writePage(BytesInput.from((byte[])new byte[735]), 209, (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])new byte[743]), 209, (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])new byte[743]), 209, (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])new byte[735]), 209, (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        PageReader pageReader = memPageStore.getPageReader(col);
        long totalValueCount = pageReader.getTotalValueCount();
        LOG.info(String.valueOf(totalValueCount));
        int total = 0;
        do {
            readPage = pageReader.readPage();
            LOG.info(readPage.toString());
        } while ((long)(total += readPage.getValueCount()) < totalValueCount);
    }
}

