/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bytestreamsplit;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForDouble;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForFLBA;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForFloat;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForInteger;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForLong;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class ByteStreamSplitValuesEndToEndTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFloatPipeline() throws Exception {
        Random rand = new Random(1337L);
        int numElements = 1024;
        float[] values = new float[1024];
        for (int i = 0; i < 1024; ++i) {
            float f;
            values[i] = f = rand.nextFloat() * 4096.0f;
        }
        ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter writer = null;
        try {
            writer = new ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter(4096, 4096, (ByteBufferAllocator)new DirectByteBufferAllocator());
            for (float v : values) {
                writer.writeFloat(v);
            }
            Assert.assertEquals((long)4096L, (long)writer.getBufferedSize());
            BytesInput input = writer.getBytes();
            Assert.assertEquals((long)4096L, (long)input.size());
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
            for (float expectedValue : values) {
                float newValue = reader.readFloat();
                Assert.assertEquals((float)expectedValue, (float)newValue, (float)0.0f);
            }
        }
        finally {
            if (writer != null) {
                writer.reset();
                writer.close();
            }
        }
    }

    @Test
    public void testDoublePipeline() throws Exception {
        Random rand = new Random(18990L);
        int numElements = 1024;
        double[] values = rand.doubles(1024L).toArray();
        ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter writer = new ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter(8192, 8192, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (double v : values) {
            writer.writeDouble(v);
        }
        Assert.assertEquals((long)8192L, (long)writer.getBufferedSize());
        BytesInput input = writer.getBytes();
        Assert.assertEquals((long)8192L, (long)input.size());
        ByteStreamSplitValuesReaderForDouble reader = new ByteStreamSplitValuesReaderForDouble();
        reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
        for (double expectedValue : values) {
            double newValue = reader.readDouble();
            Assert.assertEquals((double)expectedValue, (double)newValue, (double)0.0);
        }
        writer.reset();
        writer.close();
    }

    @Test
    public void testIntegerPipeline() throws Exception {
        Random rand = new Random(18990L);
        int numElements = 1024;
        int[] values = rand.ints(1024L).toArray();
        ByteStreamSplitValuesWriter.IntegerByteStreamSplitValuesWriter writer = new ByteStreamSplitValuesWriter.IntegerByteStreamSplitValuesWriter(4096, 4096, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (int v : values) {
            writer.writeInteger(v);
        }
        Assert.assertEquals((long)4096L, (long)writer.getBufferedSize());
        BytesInput input = writer.getBytes();
        Assert.assertEquals((long)4096L, (long)input.size());
        ByteStreamSplitValuesReaderForInteger reader = new ByteStreamSplitValuesReaderForInteger();
        reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
        for (int expectedValue : values) {
            int newValue = reader.readInteger();
            Assert.assertEquals((long)expectedValue, (long)newValue);
        }
        writer.reset();
        writer.close();
    }

    @Test
    public void testLongPipeline() throws Exception {
        Random rand = new Random(18990L);
        int numElements = 1024;
        long[] values = rand.longs(1024L).toArray();
        ByteStreamSplitValuesWriter.LongByteStreamSplitValuesWriter writer = new ByteStreamSplitValuesWriter.LongByteStreamSplitValuesWriter(8192, 8192, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (long v : values) {
            writer.writeLong(v);
        }
        Assert.assertEquals((long)8192L, (long)writer.getBufferedSize());
        BytesInput input = writer.getBytes();
        Assert.assertEquals((long)8192L, (long)input.size());
        ByteStreamSplitValuesReaderForLong reader = new ByteStreamSplitValuesReaderForLong();
        reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
        for (long expectedValue : values) {
            long newValue = reader.readLong();
            Assert.assertEquals((long)expectedValue, (long)newValue);
        }
        writer.reset();
        writer.close();
    }

    @Test
    public void testFixedLenByteArrayPipeline() throws Exception {
        Random rand = new Random(18990L);
        int numElements = 1024;
        int typeLength = 3;
        byte[][] values = new byte[1024][];
        for (int i = 0; i < 1024; ++i) {
            values[i] = new byte[3];
            rand.nextBytes(values[i]);
        }
        ByteStreamSplitValuesWriter.FixedLenByteArrayByteStreamSplitValuesWriter writer = new ByteStreamSplitValuesWriter.FixedLenByteArrayByteStreamSplitValuesWriter(3, 3072, 3072, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (byte[] v : values) {
            writer.writeBytes(Binary.fromConstantByteArray((byte[])v));
        }
        Assert.assertEquals((long)3072L, (long)writer.getBufferedSize());
        BytesInput input = writer.getBytes();
        Assert.assertEquals((long)3072L, (long)input.size());
        ByteStreamSplitValuesReaderForFLBA reader = new ByteStreamSplitValuesReaderForFLBA(3);
        reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
        Binary previousExpected = null;
        Binary previousActual = null;
        for (byte[] expectedValue : values) {
            Binary expected = Binary.fromConstantByteArray((byte[])expectedValue);
            Binary actual = reader.readBytes();
            Assert.assertEquals((Object)expected, (Object)actual);
            if (previousExpected != null) {
                Assert.assertEquals((Object)previousExpected, previousActual);
            }
            previousExpected = expected;
            previousActual = actual;
        }
        writer.reset();
        writer.close();
    }
}

