/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.delta.benchmark;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import java.util.Random;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriterForInteger;
import org.apache.parquet.column.values.delta.benchmark.BenchMarkTest;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="benchmark-encoding-writing-random")
public class RandomWritingBenchmarkTest
extends BenchMarkTest {
    public static int blockSize = 128;
    public static int miniBlockNum = 4;
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();

    @BeforeClass
    public static void prepare() {
        Random random = new Random();
        data = new int[10000 * blockSize];
        for (int i = 0; i < data.length; ++i) {
            RandomWritingBenchmarkTest.data[i] = random.nextInt(100) - 200;
        }
    }

    @BenchmarkOptions(benchmarkRounds=10, warmupRounds=2)
    @Test
    public void writeDeltaPackingTest() {
        DeltaBinaryPackingValuesWriterForInteger writer = new DeltaBinaryPackingValuesWriterForInteger(blockSize, miniBlockNum, 100, 20000, (ByteBufferAllocator)new DirectByteBufferAllocator());
        this.runWriteTest((ValuesWriter)writer);
    }

    @BenchmarkOptions(benchmarkRounds=10, warmupRounds=2)
    @Test
    public void writeRLETest() {
        RunLengthBitPackingHybridValuesWriter writer = new RunLengthBitPackingHybridValuesWriter(32, 100, 20000, (ByteBufferAllocator)new DirectByteBufferAllocator());
        this.runWriteTest((ValuesWriter)writer);
    }

    @BenchmarkOptions(benchmarkRounds=10, warmupRounds=2)
    @Test
    public void writeDeltaPackingTest2() {
        DeltaBinaryPackingValuesWriterForInteger writer = new DeltaBinaryPackingValuesWriterForInteger(blockSize, miniBlockNum, 100, 20000, (ByteBufferAllocator)new DirectByteBufferAllocator());
        this.runWriteTest((ValuesWriter)writer);
    }
}

