/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.predicate;

import org.apache.parquet.filter2.predicate.ContainsRewriter;
import org.apache.parquet.filter2.predicate.DummyUdp;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.junit.Assert;
import org.junit.Test;

public class TestContainsRewriter {
    private static final Operators.IntColumn intColumn = FilterApi.intColumn((String)"a.b.c");
    private static final Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"a.b.c");

    private static void assertNoOp(FilterPredicate p) {
        Assert.assertEquals((Object)p, (Object)ContainsRewriter.rewrite((FilterPredicate)p));
    }

    @Test
    public void testBaseCases() {
        Operators.UserDefined ud = FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class);
        TestContainsRewriter.assertNoOp((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestContainsRewriter.assertNoOp((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestContainsRewriter.assertNoOp((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestContainsRewriter.assertNoOp((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestContainsRewriter.assertNoOp((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestContainsRewriter.assertNoOp((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestContainsRewriter.assertNoOp(FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))));
        TestContainsRewriter.assertNoOp(FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))));
        TestContainsRewriter.assertNoOp((FilterPredicate)ud);
        Operators.Contains containsLhs = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        Operators.Contains containsRhs = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)));
        TestContainsRewriter.assertNoOp((FilterPredicate)containsLhs);
        Assert.assertEquals((Object)containsLhs.and((FilterPredicate)containsRhs), (Object)ContainsRewriter.rewrite((FilterPredicate)FilterApi.and((FilterPredicate)containsLhs, (FilterPredicate)containsRhs)));
        Assert.assertEquals((Object)containsLhs.or((FilterPredicate)containsRhs), (Object)ContainsRewriter.rewrite((FilterPredicate)FilterApi.or((FilterPredicate)containsLhs, (FilterPredicate)containsRhs)));
    }

    @Test
    public void testNested() {
        Operators.Contains contains1 = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(1)));
        Operators.Contains contains2 = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(2)));
        Operators.Contains contains3 = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(3)));
        Operators.Contains contains4 = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(4)));
        Assert.assertEquals((Object)contains1.and((FilterPredicate)contains2.or((FilterPredicate)contains3)), (Object)ContainsRewriter.rewrite((FilterPredicate)FilterApi.and((FilterPredicate)contains1, (FilterPredicate)FilterApi.or((FilterPredicate)contains2, (FilterPredicate)contains3))));
        Assert.assertEquals((Object)contains1.and((FilterPredicate)contains2).or((FilterPredicate)contains3), (Object)ContainsRewriter.rewrite((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)contains1, (FilterPredicate)contains2), (FilterPredicate)contains3)));
        Assert.assertEquals((Object)contains1.and((FilterPredicate)contains2).and((FilterPredicate)contains2.or((FilterPredicate)contains3)), (Object)ContainsRewriter.rewrite((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)contains1, (FilterPredicate)contains2), (FilterPredicate)FilterApi.or((FilterPredicate)contains2, (FilterPredicate)contains3))));
        Assert.assertEquals((Object)contains1.and((FilterPredicate)contains2).or((FilterPredicate)contains3.or((FilterPredicate)contains4)), (Object)ContainsRewriter.rewrite((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)contains1, (FilterPredicate)contains2), (FilterPredicate)FilterApi.or((FilterPredicate)contains3, (FilterPredicate)contains4))));
    }
}

