/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Float16;
import org.junit.Assert;
import org.junit.Test;

public class TestFloat16 {
    private static final short LOWEST_VALUE = -1025;
    private static final short MAX_VALUE = 31743;
    private static final short MIN_VALUE = 1;
    private static final short POSITIVE_ZERO = 0;
    private static final short NEGATIVE_ZERO = Short.MIN_VALUE;
    private static final short NaN = 32256;
    private static final short POSITIVE_INFINITY = 31744;
    private static final short NEGATIVE_INFINITY = -1024;

    @Test
    public void testFloat16ToFloat() {
        Assert.assertEquals((float)0.0f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, 0})), (float)0.0f);
        Assert.assertEquals((float)-0.0f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, -128})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-64, 127})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, 126})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, 127})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, -2})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, -1})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{127, 126})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{127, -2})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, -2})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, 127})), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, -1})), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, 124})), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, -4})), (float)0.0f);
        Assert.assertEquals((float)5.9604645E-8f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{1, 0})), (float)0.0f);
        Assert.assertEquals((float)-65504.0f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, -5})), (float)0.0f);
        Assert.assertEquals((float)65504.0f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, 123})), (float)0.0f);
        Assert.assertEquals((float)-6.097555E-5f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, -125})), (float)0.0f);
        Assert.assertEquals((float)-5.9604645E-8f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{1, -128})), (float)0.0f);
        Assert.assertEquals((float)1.0009766f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{1, 60})), (float)0.0f);
        Assert.assertEquals((float)-2.0f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, -64})), (float)0.0f);
        Assert.assertEquals((float)6.1035156E-5f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{0, 4})), (float)0.0f);
        Assert.assertEquals((float)65504.0f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, 123})), (float)0.0f);
        Assert.assertEquals((float)0.33325195f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{85, 53})), (float)0.0f);
        Assert.assertEquals((float)6.097555E-5f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, 3})), (float)0.0f);
        Assert.assertEquals((float)5.9604645E-8f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{1, 0})), (float)0.0f);
        Assert.assertEquals((float)-6.097555E-5f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{-1, -125})), (float)0.0f);
        Assert.assertEquals((float)-5.9604645E-8f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{1, -128})), (float)0.0f);
        Assert.assertEquals((float)5.016327E-4f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, 16})), (float)0.0f);
        Assert.assertEquals((float)-5.016327E-4f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, -112})), (float)0.0f);
        Assert.assertEquals((float)5.021095E-4f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{29, 16})), (float)0.0f);
        Assert.assertEquals((float)-5.021095E-4f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{29, -112})), (float)0.0f);
        Assert.assertEquals((float)7.457733E-4f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, 18})), (float)0.0f);
        Assert.assertEquals((float)-7.457733E-4f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, -110})), (float)0.0f);
        Assert.assertEquals((float)0.0010032654f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, 20})), (float)0.0f);
        Assert.assertEquals((float)-0.0010032654f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, -108})), (float)0.0f);
        Assert.assertEquals((float)32.875f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, 80})), (float)0.0f);
        Assert.assertEquals((float)-32.875f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, -48})), (float)0.0f);
        Assert.assertEquals((float)1.66893E-6f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, 0})), (float)0.0f);
        Assert.assertEquals((float)-1.66893E-6f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, -128})), (float)0.0f);
        Assert.assertEquals((float)3.2186508E-5f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, 2})), (float)0.0f);
        Assert.assertEquals((float)-3.2186508E-5f, (float)Float16.toFloat((Binary)Binary.fromConstantByteArray((byte[])new byte[]{28, -126})), (float)0.0f);
    }

    @Test
    public void testFloatToFloat16() {
        Assert.assertEquals((long)0L, (long)Float16.toFloat16((float)0.0f));
        Assert.assertEquals((long)-32768L, (long)Float16.toFloat16((float)-0.0f));
        Assert.assertEquals((long)32256L, (long)Float16.toFloat16((float)Float.NaN));
        Assert.assertEquals((long)31744L, (long)Float16.toFloat16((float)Float.POSITIVE_INFINITY));
        Assert.assertEquals((long)-1024L, (long)Float16.toFloat16((float)Float.NEGATIVE_INFINITY));
        Assert.assertEquals((long)15361L, (long)Float16.toFloat16((float)1.0009766f));
        Assert.assertEquals((long)-16384L, (long)Float16.toFloat16((float)-2.0f));
        Assert.assertEquals((long)1024L, (long)Float16.toFloat16((float)6.10352E-5f));
        Assert.assertEquals((long)31743L, (long)Float16.toFloat16((float)65504.0f));
        Assert.assertEquals((long)13653L, (long)Float16.toFloat16((float)0.33333334f));
        Assert.assertEquals((long)1023L, (long)Float16.toFloat16((float)6.09756E-5f));
        Assert.assertEquals((long)1L, (long)Float16.toFloat16((float)5.96046E-8f));
        Assert.assertEquals((long)-31745L, (long)Float16.toFloat16((float)-6.09756E-5f));
        Assert.assertEquals((long)-32767L, (long)Float16.toFloat16((float)-5.96046E-8f));
        Assert.assertEquals((long)0L, (long)Float16.toFloat16((float)5.96046E-9f));
        Assert.assertEquals((long)-32768L, (long)Float16.toFloat16((float)-5.96046E-9f));
        Assert.assertEquals((long)4096L, (long)Float16.toFloat16((float)Float.intBitsToFloat(973074432)));
        Assert.assertEquals((long)1024L, (long)Float16.toFloat16((float)Float.intBitsToFloat(947904512)));
        Assert.assertEquals((long)31743L, (long)Float16.toFloat16((float)65519.0f));
        Assert.assertEquals((long)31743L, (long)Float16.toFloat16((float)65519.9f));
        Assert.assertEquals((long)31744L, (long)Float16.toFloat16((float)65520.0f));
        Assert.assertEquals((long)-1024L, (long)Float16.toFloat16((float)-65520.0f));
        Assert.assertEquals((long)26624L, (long)Float16.toFloat16((float)2049.0f));
        Assert.assertEquals((long)27648L, (long)Float16.toFloat16((float)4098.0f));
        Assert.assertEquals((long)28672L, (long)Float16.toFloat16((float)8196.0f));
        Assert.assertEquals((long)29696L, (long)Float16.toFloat16((float)16392.0f));
        Assert.assertEquals((long)30720L, (long)Float16.toFloat16((float)32784.0f));
        Assert.assertEquals((long)4124L, (long)Float16.toFloat16((float)5.016327E-4f));
        Assert.assertEquals((long)-28644L, (long)Float16.toFloat16((float)-5.016327E-4f));
        Assert.assertEquals((long)4125L, (long)Float16.toFloat16((float)5.021095E-4f));
        Assert.assertEquals((long)-28643L, (long)Float16.toFloat16((float)-5.021095E-4f));
        Assert.assertEquals((long)4636L, (long)Float16.toFloat16((float)7.457733E-4f));
        Assert.assertEquals((long)-28132L, (long)Float16.toFloat16((float)-7.457733E-4f));
        Assert.assertEquals((long)5148L, (long)Float16.toFloat16((float)0.0010032654f));
        Assert.assertEquals((long)-27620L, (long)Float16.toFloat16((float)-0.0010032654f));
        Assert.assertEquals((long)20508L, (long)Float16.toFloat16((float)32.875f));
        Assert.assertEquals((long)-12260L, (long)Float16.toFloat16((float)-32.875f));
        Assert.assertEquals((long)28L, (long)Float16.toFloat16((float)1.66893E-6f));
        Assert.assertEquals((long)-32740L, (long)Float16.toFloat16((float)-1.66893E-6f));
        Assert.assertEquals((long)540L, (long)Float16.toFloat16((float)3.2186508E-5f));
        Assert.assertEquals((long)-32228L, (long)Float16.toFloat16((float)-3.2186508E-5f));
    }

    @Test
    public void testIsNaN() {
        Assert.assertFalse((boolean)Float16.isNaN((short)31744));
        Assert.assertFalse((boolean)Float16.isNaN((short)-1024));
        Assert.assertFalse((boolean)Float16.isNaN((short)0));
        Assert.assertFalse((boolean)Float16.isNaN((short)Short.MIN_VALUE));
        Assert.assertTrue((boolean)Float16.isNaN((short)32256));
        Assert.assertTrue((boolean)Float16.isNaN((short)31745));
        Assert.assertTrue((boolean)Float16.isNaN((short)31768));
        Assert.assertTrue((boolean)Float16.isNaN((short)-1023));
        Assert.assertTrue((boolean)Float16.isNaN((short)-872));
        Assert.assertFalse((boolean)Float16.isNaN((short)31743));
        Assert.assertFalse((boolean)Float16.isNaN((short)-1025));
        Assert.assertFalse((boolean)Float16.isNaN((short)Float16.toFloat16((float)-128.3f)));
        Assert.assertFalse((boolean)Float16.isNaN((short)Float16.toFloat16((float)128.3f)));
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((long)0L, (long)Float16.compare((short)32256, (short)32256));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)32256, (short)-872));
        Assert.assertEquals((long)1L, (long)Float16.compare((short)32256, (short)31744));
        Assert.assertEquals((long)-1L, (long)Float16.compare((short)31744, (short)32256));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)31744, (short)31744));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)-1024, (short)-1024));
        Assert.assertEquals((long)1L, (long)Float16.compare((short)31744, (short)-1024));
        Assert.assertEquals((long)-1L, (long)Float16.compare((short)-1024, (short)31744));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)0, (short)0));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)Short.MIN_VALUE, (short)Short.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Float16.compare((short)0, (short)Short.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)Float16.compare((short)Short.MIN_VALUE, (short)0));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)Float16.toFloat16((float)12.462f), (short)Float16.toFloat16((float)12.462f)));
        Assert.assertEquals((long)0L, (long)Float16.compare((short)Float16.toFloat16((float)-12.462f), (short)Float16.toFloat16((float)-12.462f)));
        Assert.assertEquals((long)1L, (long)Float16.compare((short)Float16.toFloat16((float)12.462f), (short)Float16.toFloat16((float)-12.462f)));
        Assert.assertEquals((long)-1L, (long)Float16.compare((short)Float16.toFloat16((float)-12.462f), (short)Float16.toFloat16((float)12.462f)));
    }
}

