/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.page.mem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.Log;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.UnknownColumnException;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageReader;
import org.apache.parquet.column.page.mem.MemPageWriter;

public class MemPageStore
implements PageReadStore,
PageWriteStore {
    private static final Log LOG = Log.getLog(MemPageStore.class);
    private Map<ColumnDescriptor, MemPageWriter> pageWriters = new HashMap<ColumnDescriptor, MemPageWriter>();
    private long rowCount;

    public MemPageStore(long rowCount) {
        this.rowCount = rowCount;
    }

    public PageWriter getPageWriter(ColumnDescriptor path) {
        MemPageWriter pageWriter = this.pageWriters.get(path);
        if (pageWriter == null) {
            pageWriter = new MemPageWriter();
            this.pageWriters.put(path, pageWriter);
        }
        return pageWriter;
    }

    public PageReader getPageReader(ColumnDescriptor descriptor) {
        MemPageWriter pageWriter = this.pageWriters.get(descriptor);
        if (pageWriter == null) {
            throw new UnknownColumnException(descriptor);
        }
        ArrayList<DataPage> pages = new ArrayList<DataPage>(pageWriter.getPages());
        if (Log.DEBUG) {
            LOG.debug((Object)("initialize page reader with " + pageWriter.getTotalValueCount() + " values and " + pages.size() + " pages"));
        }
        return new MemPageReader(pageWriter.getTotalValueCount(), pages.iterator(), pageWriter.getDictionaryPage());
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void addRowCount(long count) {
        this.rowCount += count;
    }
}

