/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.rle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.junit.Assert;
import org.junit.Test;

public class TestRunLengthBitPackingHybridEncoder {
    @Test
    public void testRLEOnly() throws Exception {
        int i;
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(3, 5, 10);
        for (i = 0; i < 100; ++i) {
            encoder.writeInt(4);
        }
        for (i = 0; i < 100; ++i) {
            encoder.writeInt(5);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)200L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)4L, (long)BytesUtils.readIntLittleEndianOnOneByte((InputStream)is));
        Assert.assertEquals((long)200L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)5L, (long)BytesUtils.readIntLittleEndianOnOneByte((InputStream)is));
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testRepeatedZeros() throws Exception {
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(3, 5, 10);
        for (int i = 0; i < 10; ++i) {
            encoder.writeInt(0);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)20L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)0L, (long)BytesUtils.readIntLittleEndianOnOneByte((InputStream)is));
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testBitWidthZero() throws Exception {
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(0, 5, 10);
        for (int i = 0; i < 10; ++i) {
            encoder.writeInt(0);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)20L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testBitPackingOnly() throws Exception {
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(3, 5, 10);
        for (int i = 0; i < 100; ++i) {
            encoder.writeInt(i % 3);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)27L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        List<Integer> values = TestRunLengthBitPackingHybridEncoder.unpack(3, 104, is);
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((long)(i % 3), (long)values.get(i).intValue());
        }
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testBitPackingOverflow() throws Exception {
        int i;
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(3, 5, 10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            encoder.writeInt(i2 % 3);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)127L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        List<Integer> values = TestRunLengthBitPackingHybridEncoder.unpack(3, 504, is);
        for (i = 0; i < 504; ++i) {
            Assert.assertEquals((long)(i % 3), (long)values.get(i).intValue());
        }
        Assert.assertEquals((long)125L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        values = TestRunLengthBitPackingHybridEncoder.unpack(3, 496, is);
        for (i = 0; i < 496; ++i) {
            Assert.assertEquals((long)((i + 504) % 3), (long)values.get(i).intValue());
        }
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testTransitionFromBitPackingToRle() throws Exception {
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(3, 5, 10);
        encoder.writeInt(0);
        encoder.writeInt(1);
        encoder.writeInt(0);
        encoder.writeInt(1);
        encoder.writeInt(0);
        encoder.writeInt(2);
        encoder.writeInt(2);
        encoder.writeInt(2);
        for (int i = 0; i < 100; ++i) {
            encoder.writeInt(2);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)3L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        List<Integer> values = TestRunLengthBitPackingHybridEncoder.unpack(3, 8, is);
        Assert.assertEquals(Arrays.asList(0, 1, 0, 1, 0, 2, 2, 2), values);
        Assert.assertEquals((long)200L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)2L, (long)BytesUtils.readIntLittleEndianOnOneByte((InputStream)is));
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testPaddingZerosOnUnfinishedBitPackedRuns() throws Exception {
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(5, 5, 10);
        for (int i = 0; i < 9; ++i) {
            encoder.writeInt(i + 1);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)5L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        List<Integer> values = TestRunLengthBitPackingHybridEncoder.unpack(5, 16, is);
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0), values);
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testSwitchingModes() throws Exception {
        int i;
        int i2;
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(9, 100, 1000);
        for (i2 = 0; i2 < 25; ++i2) {
            encoder.writeInt(17);
        }
        for (i2 = 0; i2 < 7; ++i2) {
            encoder.writeInt(7);
        }
        encoder.writeInt(8);
        encoder.writeInt(9);
        encoder.writeInt(10);
        for (i2 = 0; i2 < 25; ++i2) {
            encoder.writeInt(6);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            encoder.writeInt(5);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encoder.toBytes().toByteArray());
        Assert.assertEquals((long)50L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)17L, (long)BytesUtils.readIntLittleEndianOnTwoBytes((InputStream)is));
        Assert.assertEquals((long)5L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        List<Integer> values = TestRunLengthBitPackingHybridEncoder.unpack(9, 16, is);
        int v = 0;
        for (i = 0; i < 7; ++i) {
            Assert.assertEquals((long)7L, (long)values.get(v).intValue());
            ++v;
        }
        Assert.assertEquals((long)8L, (long)values.get(v++).intValue());
        Assert.assertEquals((long)9L, (long)values.get(v++).intValue());
        Assert.assertEquals((long)10L, (long)values.get(v++).intValue());
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)6L, (long)values.get(v).intValue());
            ++v;
        }
        Assert.assertEquals((long)38L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)6L, (long)BytesUtils.readIntLittleEndianOnTwoBytes((InputStream)is));
        Assert.assertEquals((long)16L, (long)BytesUtils.readUnsignedVarInt((InputStream)is));
        Assert.assertEquals((long)5L, (long)BytesUtils.readIntLittleEndianOnTwoBytes((InputStream)is));
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    public void testGroupBoundary() throws Exception {
        byte[] bytes = new byte[]{3, 57};
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        RunLengthBitPackingHybridDecoder decoder = new RunLengthBitPackingHybridDecoder(2, stream);
        Assert.assertEquals((long)decoder.readInt(), (long)1L);
        Assert.assertEquals((long)decoder.readInt(), (long)2L);
        Assert.assertEquals((long)decoder.readInt(), (long)3L);
        Assert.assertEquals((long)stream.available(), (long)0L);
    }

    private static List<Integer> unpack(int bitWidth, int numValues, ByteArrayInputStream is) throws Exception {
        BytePacker packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
        int[] unpacked = new int[8];
        byte[] next8Values = new byte[bitWidth];
        ArrayList<Integer> values = new ArrayList<Integer>(numValues);
        while (values.size() < numValues) {
            for (int i = 0; i < bitWidth; ++i) {
                next8Values[i] = (byte)is.read();
            }
            packer.unpack8Values(next8Values, 0, unpacked, 0);
            for (int v = 0; v < 8; ++v) {
                values.add(unpacked[v]);
            }
        }
        return values;
    }
}

