/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.parquet.Log;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.example.Paper;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupWriter;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.ConverterConsumer;
import org.apache.parquet.io.ExpectationValidatingConverter;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.io.RecordConsumerLoggingWrapper;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.RecordReaderImplementation;
import org.apache.parquet.io.ValidatingColumnWriteStore;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestColumnIO {
    private static final Log LOG = Log.getLog(TestColumnIO.class);
    private static final String oneOfEach = "message Document {\n  required int64 a;\n  required int32 b;\n  required float c;\n  required double d;\n  required boolean e;\n  required binary f;\n  required int96 g;\n  required fixed_len_byte_array(3) h;\n}\n";
    private static final String schemaString = "message Document {\n  required int64 DocId;\n  optional group Links {\n    repeated int64 Backward;\n    repeated int64 Forward;\n  }\n  repeated group Name {\n    repeated group Language {\n      required binary Code;\n      optional binary Country;\n    }\n    optional binary Url;\n  }\n}\n";
    int[][] expectedFSA = new int[][]{{1}, {2, 1}, {3, 2}, {4, 4, 4}, {5, 5, 3}, {6, 3}};
    int[][] expectedFSA2 = new int[][]{{1}, {2, 1, 1}};
    public static final String[] expectedEventsForR1 = new String[]{"startMessage()", "DocId.addLong(10)", "Links.start()", "Links.Forward.addLong(20)", "Links.Forward.addLong(40)", "Links.Forward.addLong(60)", "Links.end()", "Name.start()", "Name.Language.start()", "Name.Language.Code.addBinary(en-us)", "Name.Language.Country.addBinary(us)", "Name.Language.end()", "Name.Language.start()", "Name.Language.Code.addBinary(en)", "Name.Language.end()", "Name.Url.addBinary(http://A)", "Name.end()", "Name.start()", "Name.Url.addBinary(http://B)", "Name.end()", "Name.start()", "Name.Language.start()", "Name.Language.Code.addBinary(en-gb)", "Name.Language.Country.addBinary(gb)", "Name.Language.end()", "Name.end()", "endMessage()"};
    private boolean useDictionary;

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException {
        Object[][] data = new Object[][]{{true}, {false}};
        return Arrays.asList(data);
    }

    public TestColumnIO(boolean useDictionary) {
        this.useDictionary = useDictionary;
    }

    @Test
    public void testSchema() {
        Assert.assertEquals((Object)schemaString, (Object)Paper.schema.toString());
    }

    @Test
    public void testReadUsingRequestedSchemaWithExtraFields() {
        MessageType orginalSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b")});
        MessageType schemaWithExtraField = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c")});
        MemPageStore memPageStoreForOriginalSchema = new MemPageStore(1L);
        MemPageStore memPageStoreForSchemaWithExtraField = new MemPageStore(1L);
        SimpleGroupFactory groupFactory = new SimpleGroupFactory(orginalSchema);
        this.writeGroups(orginalSchema, memPageStoreForOriginalSchema, groupFactory.newGroup().append("a", 1).append("b", 2));
        SimpleGroupFactory groupFactory2 = new SimpleGroupFactory(schemaWithExtraField);
        this.writeGroups(schemaWithExtraField, memPageStoreForSchemaWithExtraField, groupFactory2.newGroup().append("a", 1).append("b", 2).append("c", 3));
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.addAll(this.readGroups(memPageStoreForOriginalSchema, orginalSchema, schemaWithExtraField, 1));
        groups.addAll(this.readGroups(memPageStoreForSchemaWithExtraField, schemaWithExtraField, schemaWithExtraField, 1));
        Object[][] expected = new Object[][]{{2, 1, null}, {2, 1, 3}};
        this.validateGroups(groups, expected);
    }

    @Test
    public void testReadUsingRequestedSchemaWithIncompatibleField() {
        MessageType originalSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "e")});
        MemPageStore store = new MemPageStore(1L);
        SimpleGroupFactory groupFactory = new SimpleGroupFactory(originalSchema);
        this.writeGroups(originalSchema, store, groupFactory.newGroup().append("e", 4));
        try {
            MessageType schemaWithIncompatibleField = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "e")});
            this.readGroups(store, originalSchema, schemaWithIncompatibleField, 1);
            Assert.fail((String)"should have thrown an incompatible schema exception");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"The requested schema is not compatible with the file schema. incompatible types: optional binary e != optional int32 e", (Object)e.getMessage());
        }
    }

    @Test
    public void testReadUsingSchemaWithRequiredFieldThatWasOptional() {
        MessageType originalSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "e")});
        MemPageStore store = new MemPageStore(1L);
        SimpleGroupFactory groupFactory = new SimpleGroupFactory(originalSchema);
        this.writeGroups(originalSchema, store, groupFactory.newGroup().append("e", 4));
        try {
            MessageType schemaWithRequiredFieldThatWasOptional = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "e")});
            this.readGroups(store, originalSchema, schemaWithRequiredFieldThatWasOptional, 1);
            Assert.fail((String)"should have thrown an incompatible schema exception");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"The requested schema is not compatible with the file schema. incompatible types: required int32 e != optional int32 e", (Object)e.getMessage());
        }
    }

    @Test
    public void testReadUsingProjectedSchema() {
        MessageType orginalSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "b")});
        MessageType projectedSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b")});
        MemPageStore store = new MemPageStore(1L);
        SimpleGroupFactory groupFactory = new SimpleGroupFactory(orginalSchema);
        this.writeGroups(orginalSchema, store, groupFactory.newGroup().append("a", 1).append("b", 2));
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.addAll(this.readGroups(store, orginalSchema, projectedSchema, 1));
        Object[][] expected = new Object[][]{{2}};
        this.validateGroups(groups, expected);
    }

    private void validateGroups(List<Group> groups1, Object[][] e1) {
        Iterator<Group> i1 = groups1.iterator();
        for (int i = 0; i < e1.length; ++i) {
            Object[] objects = e1[i];
            Group next = i1.next();
            for (int j = 0; j < objects.length; ++j) {
                Object object = objects[j];
                if (object == null) {
                    Assert.assertEquals((long)0L, (long)next.getFieldRepetitionCount(j));
                    continue;
                }
                Assert.assertEquals((String)("looking for r[" + i + "][" + j + "][0]=" + object), (long)1L, (long)next.getFieldRepetitionCount(j));
                Assert.assertEquals((Object)object, (Object)next.getInteger(j, 0));
            }
        }
    }

    private List<Group> readGroups(MemPageStore memPageStore, MessageType fileSchema, MessageType requestedSchema, int n) {
        ColumnIOFactory columnIOFactory = new ColumnIOFactory(true);
        MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema);
        RecordReaderImplementation<Group> recordReader = this.getRecordReader(columnIO, requestedSchema, memPageStore);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (int i = 0; i < n; ++i) {
            groups.add((Group)recordReader.read());
        }
        return groups;
    }

    private void writeGroups(MessageType writtenSchema, MemPageStore memPageStore, Group ... groups) {
        ColumnIOFactory columnIOFactory = new ColumnIOFactory(true);
        ColumnWriteStoreV1 columns = this.newColumnWriteStore(memPageStore);
        MessageColumnIO columnIO = columnIOFactory.getColumnIO(writtenSchema);
        GroupWriter groupWriter = new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)writtenSchema);
        for (Group group : groups) {
            groupWriter.write(group);
        }
        columns.flush();
    }

    @Test
    public void testColumnIO() {
        this.log(Paper.schema);
        this.log("r1");
        this.log(Paper.r1);
        this.log("r2");
        this.log(Paper.r2);
        MemPageStore memPageStore = new MemPageStore(2L);
        ColumnWriteStoreV1 columns = this.newColumnWriteStore(memPageStore);
        ColumnIOFactory columnIOFactory = new ColumnIOFactory(true);
        MessageColumnIO columnIO = columnIOFactory.getColumnIO(Paper.schema);
        this.log(columnIO);
        GroupWriter groupWriter = new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)Paper.schema);
        groupWriter.write((Group)Paper.r1);
        groupWriter.write((Group)Paper.r2);
        columns.flush();
        this.log(columns);
        this.log("=========");
        RecordReaderImplementation<Group> recordReader = this.getRecordReader(columnIO, Paper.schema, memPageStore);
        this.validateFSA(this.expectedFSA, columnIO, recordReader);
        ArrayList<Object> records = new ArrayList<Object>();
        records.add(recordReader.read());
        records.add(recordReader.read());
        int i = 0;
        for (Group group : records) {
            this.log("r" + ++i);
            this.log(group);
        }
        Assert.assertEquals((String)"deserialization does not display the same result", (Object)Paper.r1.toString(), (Object)((Group)records.get(0)).toString());
        Assert.assertEquals((String)"deserialization does not display the same result", (Object)Paper.r2.toString(), (Object)((Group)records.get(1)).toString());
        MessageColumnIO columnIO2 = columnIOFactory.getColumnIO(Paper.schema2);
        ArrayList<Object> records2 = new ArrayList<Object>();
        recordReader = this.getRecordReader(columnIO2, Paper.schema2, memPageStore);
        this.validateFSA(this.expectedFSA2, columnIO2, recordReader);
        records2.add(recordReader.read());
        records2.add(recordReader.read());
        int i2 = 0;
        for (Group group : records2) {
            this.log("r" + ++i2);
            this.log(group);
        }
        Assert.assertEquals((String)"deserialization does not display the expected result", (Object)Paper.pr1.toString(), (Object)((Group)records2.get(0)).toString());
        Assert.assertEquals((String)"deserialization does not display the expected result", (Object)Paper.pr2.toString(), (Object)((Group)records2.get(1)).toString());
    }

    @Test
    public void testOneOfEach() {
        MessageType oneOfEachSchema = MessageTypeParser.parseMessageType((String)oneOfEach);
        SimpleGroupFactory gf = new SimpleGroupFactory(oneOfEachSchema);
        Group g1 = gf.newGroup().append("a", 1L).append("b", 2).append("c", 3.0f).append("d", 4.0).append("e", true).append("f", Binary.fromString((String)"6")).append("g", new NanoTime(1234, System.currentTimeMillis() * 1000L)).append("h", Binary.fromString((String)"abc"));
        this.testSchema(oneOfEachSchema, Arrays.asList(g1));
    }

    @Test
    public void testRequiredOfRequired() {
        MessageType reqreqSchema = MessageTypeParser.parseMessageType((String)"message Document {\n  required group foo {\n    required int64 bar;\n  }\n}\n");
        SimpleGroupFactory gf = new SimpleGroupFactory(reqreqSchema);
        Group g1 = gf.newGroup();
        g1.addGroup("foo").append("bar", 2L);
        this.testSchema(reqreqSchema, Arrays.asList(g1));
    }

    @Test
    public void testOptionalRequiredInteraction() {
        int j;
        Group currentUndefinedGroup;
        Group rootUndefined;
        Group rootDefined;
        ArrayList<Group> groups;
        SimpleGroupFactory gf;
        MessageType groupSchema;
        PrimitiveType current;
        int i;
        for (i = 0; i < 6; ++i) {
            Group root;
            current = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "primitive");
            for (int j2 = 0; j2 < i; ++j2) {
                current = new GroupType(Type.Repetition.REQUIRED, "req" + j2, new Type[]{current});
            }
            groupSchema = new MessageType("schema" + i, new Type[]{current});
            gf = new SimpleGroupFactory(groupSchema);
            groups = new ArrayList<Group>();
            Group currentGroup = root = gf.newGroup();
            for (int j3 = 0; j3 < i; ++j3) {
                currentGroup = currentGroup.addGroup(0);
            }
            currentGroup.add(0, Binary.fromString((String)"foo"));
            groups.add(root);
            this.testSchema(groupSchema, groups);
        }
        for (i = 0; i < 6; ++i) {
            current = new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "primitive");
            for (int j4 = 0; j4 < i; ++j4) {
                current = new GroupType(Type.Repetition.REQUIRED, "req" + j4, new Type[]{current});
            }
            groupSchema = new MessageType("schema" + (i + 6), new Type[]{current});
            gf = new SimpleGroupFactory(groupSchema);
            groups = new ArrayList();
            rootDefined = gf.newGroup();
            rootUndefined = gf.newGroup();
            Group currentDefinedGroup = rootDefined;
            currentUndefinedGroup = rootUndefined;
            for (j = 0; j < i; ++j) {
                currentDefinedGroup = currentDefinedGroup.addGroup(0);
                currentUndefinedGroup = currentUndefinedGroup.addGroup(0);
            }
            currentDefinedGroup.add(0, Binary.fromString((String)"foo"));
            groups.add(rootDefined);
            groups.add(rootUndefined);
            this.testSchema(groupSchema, groups);
        }
        for (i = 0; i < 6; ++i) {
            current = new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "primitive");
            for (int j5 = 0; j5 < 6; ++j5) {
                current = new GroupType(i == j5 ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, "req" + j5, new Type[]{current});
            }
            groupSchema = new MessageType("schema" + (i + 12), new Type[]{current});
            gf = new SimpleGroupFactory(groupSchema);
            groups = new ArrayList();
            rootDefined = gf.newGroup();
            rootUndefined = gf.newGroup();
            Group currentDefinedGroup = rootDefined;
            currentUndefinedGroup = rootUndefined;
            for (j = 0; j < 6; ++j) {
                currentDefinedGroup = currentDefinedGroup.addGroup(0);
                if (i >= j) continue;
                currentUndefinedGroup = currentUndefinedGroup.addGroup(0);
            }
            currentDefinedGroup.add(0, Binary.fromString((String)"foo"));
            groups.add(rootDefined);
            groups.add(rootUndefined);
            this.testSchema(groupSchema, groups);
        }
    }

    private void testSchema(MessageType messageSchema, List<Group> groups) {
        MemPageStore memPageStore = new MemPageStore(groups.size());
        ColumnWriteStoreV1 columns = this.newColumnWriteStore(memPageStore);
        ColumnIOFactory columnIOFactory = new ColumnIOFactory(true);
        MessageColumnIO columnIO = columnIOFactory.getColumnIO(messageSchema);
        this.log(columnIO);
        GroupWriter groupWriter = new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)messageSchema);
        for (Group group : groups) {
            groupWriter.write(group);
        }
        columns.flush();
        RecordReaderImplementation<Group> recordReader = this.getRecordReader(columnIO, messageSchema, memPageStore);
        for (Group group : groups) {
            Group got = (Group)recordReader.read();
            Assert.assertEquals((String)"deserialization does not display the same result", (Object)group.toString(), (Object)got.toString());
        }
    }

    private RecordReaderImplementation<Group> getRecordReader(MessageColumnIO columnIO, MessageType schema, PageReadStore pageReadStore) {
        GroupRecordConverter recordConverter = new GroupRecordConverter(schema);
        return (RecordReaderImplementation)columnIO.getRecordReader(pageReadStore, (RecordMaterializer)recordConverter);
    }

    private void log(Object o) {
        LOG.info(o);
    }

    private void validateFSA(int[][] expectedFSA, MessageColumnIO columnIO, RecordReaderImplementation<?> recordReader) {
        this.log("FSA: ----");
        List leaves = columnIO.getLeaves();
        for (int i = 0; i < leaves.size(); ++i) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)leaves.get(i);
            this.log(Arrays.toString(primitiveColumnIO.getFieldPath()));
            for (int r = 0; r < expectedFSA[i].length; ++r) {
                int next = expectedFSA[i][r];
                this.log(" " + r + " -> " + (next == leaves.size() ? "end" : Arrays.toString(((PrimitiveColumnIO)leaves.get(next)).getFieldPath())) + ": " + recordReader.getNextLevel(i, r));
                Assert.assertEquals((String)(Arrays.toString(primitiveColumnIO.getFieldPath()) + ": " + r + " -> "), (long)next, (long)recordReader.getNextReader(i, r));
            }
        }
        this.log("----");
    }

    @Test
    public void testPushParser() {
        MemPageStore memPageStore = new MemPageStore(1L);
        ColumnWriteStoreV1 columns = this.newColumnWriteStore(memPageStore);
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(Paper.schema);
        new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)Paper.schema).write((Group)Paper.r1);
        columns.flush();
        RecordReader recordReader = columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)new ExpectationValidatingConverter(expectedEventsForR1, Paper.schema));
        recordReader.read();
    }

    private ColumnWriteStoreV1 newColumnWriteStore(MemPageStore memPageStore) {
        return new ColumnWriteStoreV1((PageWriteStore)memPageStore, 800, 800, this.useDictionary, ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testEmptyField() {
        MemPageStore memPageStore = new MemPageStore(1L);
        ColumnWriteStoreV1 columns = this.newColumnWriteStore(memPageStore);
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        RecordConsumer recordWriter = columnIO.getRecordWriter((ColumnWriteStore)columns);
        recordWriter.startMessage();
        recordWriter.startField("DocId", 0);
        recordWriter.addLong(0L);
        recordWriter.endField("DocId", 0);
        recordWriter.startField("Links", 1);
        try {
            recordWriter.endField("Links", 1);
            Assert.fail((String)"expected exception because of empty field");
        }
        catch (ParquetEncodingException e) {
            Assert.assertEquals((Object)"empty fields are illegal, the field should be ommited completely instead", (Object)e.getMessage());
        }
    }

    @Test
    public void testGroupWriter() {
        ArrayList<Group> result = new ArrayList<Group>();
        GroupRecordConverter groupRecordConverter = new GroupRecordConverter(Paper.schema);
        ConverterConsumer groupConsumer = new ConverterConsumer(groupRecordConverter.getRootConverter(), Paper.schema);
        GroupWriter groupWriter = new GroupWriter((RecordConsumer)new RecordConsumerLoggingWrapper((RecordConsumer)groupConsumer), (GroupType)Paper.schema);
        groupWriter.write((Group)Paper.r1);
        result.add(groupRecordConverter.getCurrentRecord());
        groupWriter.write((Group)Paper.r2);
        result.add(groupRecordConverter.getCurrentRecord());
        Assert.assertEquals((String)"deserialization does not display the expected result", (Object)((Group)result.get(0)).toString(), (Object)Paper.r1.toString());
        Assert.assertEquals((String)"deserialization does not display the expected result", (Object)((Group)result.get(1)).toString(), (Object)Paper.r2.toString());
    }

    @Test
    public void testWriteWithGroupWriter() {
        String[] expected = new String[]{"[DocId]: 10, r:0, d:0", "[Links, Forward]: 20, r:0, d:2", "[Links, Forward]: 40, r:1, d:2", "[Links, Forward]: 60, r:1, d:2", "[Links, Backward]: null, r:0, d:1", "[Name, Language, Code]: en-us, r:0, d:2", "[Name, Language, Country]: us, r:0, d:3", "[Name, Language, Code]: en, r:2, d:2", "[Name, Language, Country]: null, r:2, d:2", "[Name, Url]: http://A, r:0, d:2", "[Name, Url]: http://B, r:1, d:2", "[Name, Language, Code]: null, r:1, d:1", "[Name, Language, Country]: null, r:1, d:1", "[Name, Language, Code]: en-gb, r:1, d:2", "[Name, Language, Country]: gb, r:1, d:3", "[Name, Url]: null, r:1, d:1", "[DocId]: 20, r:0, d:0", "[Links, Backward]: 10, r:0, d:2", "[Links, Backward]: 30, r:1, d:2", "[Links, Forward]: 80, r:0, d:2", "[Name, Url]: http://C, r:0, d:2", "[Name, Language, Code]: null, r:0, d:1", "[Name, Language, Country]: null, r:0, d:1"};
        ValidatingColumnWriteStore columns = new ValidatingColumnWriteStore(expected);
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(Paper.schema);
        GroupWriter groupWriter = new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)Paper.schema);
        groupWriter.write((Group)Paper.r1);
        groupWriter.write((Group)Paper.r2);
        columns.validate();
    }
}

