/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.example.Paper;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupWriter;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.filter.AndRecordFilter;
import org.apache.parquet.filter.ColumnPredicates;
import org.apache.parquet.filter.ColumnRecordFilter;
import org.apache.parquet.filter.NotRecordFilter;
import org.apache.parquet.filter.OrRecordFilter;
import org.apache.parquet.filter.PagedRecordFilter;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.RecordReaderImplementation;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.junit.Assert;
import org.junit.Test;

public class TestFiltered {
    private List<Group> readAll(RecordReader<Group> reader) {
        Group g;
        ArrayList<Group> result = new ArrayList<Group>();
        while ((g = (Group)reader.read()) != null) {
            result.add(g);
        }
        return result;
    }

    private void readOne(RecordReader<Group> reader, String message, Group expected) {
        List<Group> result = this.readAll(reader);
        Assert.assertEquals((String)(message + ": " + result), (long)1L, (long)result.size());
        Assert.assertEquals((String)"filtering did not return the correct record", (Object)expected.toString(), (Object)result.get(0).toString());
    }

    @Test
    public void testFilterOnInteger() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 1);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)10L))));
        this.readOne((RecordReader<Group>)recordReader, "r2 filtered out", (Group)Paper.r1);
        recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)20L))));
        this.readOne((RecordReader<Group>)recordReader, "r1 filtered out", (Group)Paper.r2);
    }

    @Test
    public void testApplyFunctionFilterOnLong() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 1);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)10L))));
        this.readOne((RecordReader<Group>)recordReader, "r2 filtered out", (Group)Paper.r1);
        recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.applyFunctionToLong((ColumnPredicates.LongPredicateFunction)new LongGreaterThan15Predicate()))));
        this.readOne((RecordReader<Group>)recordReader, "r1 filtered out", (Group)Paper.r2);
    }

    @Test
    public void testFilterOnString() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 1);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"Name.Url", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"http://A"))));
        this.readOne((RecordReader<Group>)recordReader, "r2 filtered out", (Group)Paper.r1);
        recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"Name.Url", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"http://B"))));
        List<Group> all = this.readAll((RecordReader<Group>)recordReader);
        Assert.assertEquals((String)("There should be no matching records: " + all), (long)0L, (long)all.size());
        recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"Name.Url", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"http://C"))));
        this.readOne((RecordReader<Group>)recordReader, "r1 filtered out", (Group)Paper.r2);
    }

    @Test
    public void testApplyFunctionFilterOnString() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 1);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"Name.Url", (ColumnPredicates.Predicate)ColumnPredicates.applyFunctionToString((ColumnPredicates.PredicateFunction)new StringEndsWithAPredicate()))));
        this.readOne((RecordReader<Group>)recordReader, "r2 filtered out", (Group)Paper.r1);
        recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"Name.Url", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"http://B"))));
        List<Group> all = this.readAll((RecordReader<Group>)recordReader);
        Assert.assertEquals((String)("There should be no matching records: " + all), (long)0L, (long)all.size());
        recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)ColumnRecordFilter.column((String)"Name.Url", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"http://C"))));
        this.readOne((RecordReader<Group>)recordReader, "r1 filtered out", (Group)Paper.r2);
    }

    @Test
    public void testPaged() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 6);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)PagedRecordFilter.page((long)4L, (long)4L)));
        List<Group> all = this.readAll((RecordReader<Group>)recordReader);
        Assert.assertEquals((String)("expecting records " + all), (long)4L, (long)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Assert.assertEquals((String)"expecting record", (Object)(i % 2 == 0 ? Paper.r2 : Paper.r1).toString(), (Object)all.get(i).toString());
        }
    }

    @Test
    public void testFilteredAndPaged() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 8);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)AndRecordFilter.and((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)10L)), (UnboundRecordFilter)PagedRecordFilter.page((long)2L, (long)4L))));
        List<Group> all = this.readAll((RecordReader<Group>)recordReader);
        Assert.assertEquals((String)("expecting 4 records " + all), (long)4L, (long)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Assert.assertEquals((String)"expecting record1", (Object)Paper.r1.toString(), (Object)all.get(i).toString());
        }
    }

    @Test
    public void testFilteredOrPaged() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 8);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)OrRecordFilter.or((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)10L)), (UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)20L)))));
        List<Group> all = this.readAll((RecordReader<Group>)recordReader);
        Assert.assertEquals((String)("expecting 8 records " + all), (long)16L, (long)all.size());
        for (int i = 0; i < all.size() / 2; ++i) {
            Assert.assertEquals((String)"expecting record1", (Object)Paper.r1.toString(), (Object)all.get(2 * i).toString());
            Assert.assertEquals((String)"expecting record2", (Object)Paper.r2.toString(), (Object)all.get(2 * i + 1).toString());
        }
    }

    @Test
    public void testFilteredNotPaged() {
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(Paper.schema);
        MemPageStore memPageStore = this.writeTestRecords(columnIO, 8);
        GroupRecordConverter recordConverter = new GroupRecordConverter(Paper.schema);
        RecordReaderImplementation recordReader = (RecordReaderImplementation)columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConverter, FilterCompat.get((UnboundRecordFilter)NotRecordFilter.not((UnboundRecordFilter)ColumnRecordFilter.column((String)"DocId", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((long)10L)))));
        List<Group> all = this.readAll((RecordReader<Group>)recordReader);
        Assert.assertEquals((String)("expecting 8 records " + all), (long)8L, (long)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Assert.assertEquals((String)"expecting record2", (Object)Paper.r2.toString(), (Object)all.get(i).toString());
        }
    }

    private MemPageStore writeTestRecords(MessageColumnIO columnIO, int number) {
        MemPageStore memPageStore = new MemPageStore(number * 2);
        ColumnWriteStoreV1 columns = new ColumnWriteStoreV1((PageWriteStore)memPageStore, 800, 800, false, ParquetProperties.WriterVersion.PARQUET_1_0);
        GroupWriter groupWriter = new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)Paper.schema);
        for (int i = 0; i < number; ++i) {
            groupWriter.write((Group)Paper.r1);
            groupWriter.write((Group)Paper.r2);
        }
        columns.flush();
        return memPageStore;
    }

    public class StringEndsWithAPredicate
    implements ColumnPredicates.PredicateFunction<String> {
        public boolean functionToApply(String input) {
            return input.endsWith("A");
        }
    }

    public class LongGreaterThan15Predicate
    implements ColumnPredicates.LongPredicateFunction {
        public boolean functionToApply(long input) {
            return input > 15L;
        }
    }
}

