/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.Arrays;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;

final class ValidatingColumnWriteStore
implements ColumnWriteStore {
    private final String[] expected;
    int counter = 0;

    ValidatingColumnWriteStore(String[] expected) {
        this.expected = expected;
    }

    public ColumnWriter getColumnWriter(final ColumnDescriptor path) {
        return new ColumnWriter(){

            private void validate(Object value, int repetitionLevel, int definitionLevel) {
                String actual = Arrays.toString(path.getPath()) + ": " + value + ", r:" + repetitionLevel + ", d:" + definitionLevel;
                Assert.assertEquals((String)("event #" + ValidatingColumnWriteStore.this.counter), (Object)ValidatingColumnWriteStore.this.expected[ValidatingColumnWriteStore.this.counter], (Object)actual);
                ++ValidatingColumnWriteStore.this.counter;
            }

            public void writeNull(int repetitionLevel, int definitionLevel) {
                this.validate(null, repetitionLevel, definitionLevel);
            }

            public void write(Binary value, int repetitionLevel, int definitionLevel) {
                this.validate(value.toStringUsingUTF8(), repetitionLevel, definitionLevel);
            }

            public void write(boolean value, int repetitionLevel, int definitionLevel) {
                this.validate(value, repetitionLevel, definitionLevel);
            }

            public void write(int value, int repetitionLevel, int definitionLevel) {
                this.validate(value, repetitionLevel, definitionLevel);
            }

            public void write(long value, int repetitionLevel, int definitionLevel) {
                this.validate(value, repetitionLevel, definitionLevel);
            }

            public void write(float value, int repetitionLevel, int definitionLevel) {
                this.validate(Float.valueOf(value), repetitionLevel, definitionLevel);
            }

            public void write(double value, int repetitionLevel, int definitionLevel) {
                this.validate(value, repetitionLevel, definitionLevel);
            }
        };
    }

    public void validate() {
        Assert.assertEquals((String)"read all events", (long)this.expected.length, (long)this.counter);
    }

    public void endRecord() {
    }

    public void flush() {
    }

    public long getAllocatedSize() {
        return 0L;
    }

    public long getBufferedSize() {
        return 0L;
    }

    public String memUsageString() {
        return null;
    }
}

