/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.parquet.example.Paper;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestMessageType {
    @Test
    public void test() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)Paper.schema.toString());
        Assert.assertEquals((Object)Paper.schema, (Object)schema);
        Assert.assertEquals((Object)schema.toString(), (Object)Paper.schema.toString());
    }

    @Test
    public void testNestedTypes() {
        MessageType schema = MessageTypeParser.parseMessageType((String)Paper.schema.toString());
        Type type = schema.getType(new String[]{"Links", "Backward"});
        Assert.assertEquals((Object)PrimitiveType.PrimitiveTypeName.INT64, (Object)type.asPrimitiveType().getPrimitiveTypeName());
        Assert.assertEquals((long)0L, (long)schema.getMaxRepetitionLevel(new String[]{"DocId"}));
        Assert.assertEquals((long)1L, (long)schema.getMaxRepetitionLevel(new String[]{"Name"}));
        Assert.assertEquals((long)2L, (long)schema.getMaxRepetitionLevel(new String[]{"Name", "Language"}));
        Assert.assertEquals((long)0L, (long)schema.getMaxDefinitionLevel(new String[]{"DocId"}));
        Assert.assertEquals((long)1L, (long)schema.getMaxDefinitionLevel(new String[]{"Links"}));
        Assert.assertEquals((long)2L, (long)schema.getMaxDefinitionLevel(new String[]{"Links", "Backward"}));
    }

    @Test
    public void testMergeSchema() {
        MessageType t1 = new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")});
        MessageType t2 = new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")});
        Assert.assertEquals((Object)t1.union(t2), (Object)new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}));
        Assert.assertEquals((Object)t2.union(t1), (Object)new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")}));
        MessageType t3 = new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")});
        MessageType t4 = new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "a")});
        try {
            t3.union(t4);
            Assert.fail((String)"moving from optional to required");
        }
        catch (IncompatibleSchemaModificationException e) {
            Assert.assertEquals((Object)"repetition constraint is more restrictive: can not merge type required binary a into optional binary a", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)t4.union(t3), (Object)new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}));
        MessageType t5 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
        MessageType t6 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g3", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
        Assert.assertEquals((Object)t5.union(t6), (Object)new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new GroupType(Type.Repetition.REQUIRED, "g3", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c")})})}));
        MessageType t7 = new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")});
        MessageType t8 = new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a")});
        try {
            t7.union(t8);
            Assert.fail((String)"moving from BINARY to INT32");
        }
        catch (IncompatibleSchemaModificationException e) {
            Assert.assertEquals((Object)"can not merge type optional int32 a into optional binary a", (Object)e.getMessage());
        }
    }

    @Test
    public void testIDs() throws Exception {
        MessageType schema = new MessageType("test", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "foo").withId(4), new GroupType(Type.Repetition.REQUIRED, "bar", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "baz").withId(3)}).withId(8)});
        MessageType schema2 = MessageTypeParser.parseMessageType((String)schema.toString());
        Assert.assertEquals((Object)schema, (Object)schema2);
        Assert.assertEquals((Object)schema.toString(), (Object)schema2.toString());
    }

    @Test
    public void testEmptyGroup() {
        try {
            MessageType t5 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[0]), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
            Assert.fail((String)"should throw InvalidSchemaException when GroupType contains no child");
        }
        catch (InvalidSchemaException e) {
            Assert.assertEquals((Object)"A group type can not be empty. Parquet does not support empty group without leaves. Empty group: g1", (Object)e.getMessage());
        }
    }
}

