/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import org.apache.parquet.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class TestPreconditions {
    @Test
    public void testCheckArgumentWithoutParams() {
        try {
            Preconditions.checkArgument((boolean)true, (String)"Test message");
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkArgument((boolean)false, (String)"Test message");
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckArgumentWithOneParam() {
        try {
            Preconditions.checkArgument((boolean)true, (String)"Test message %s", (Object)12);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkArgument((boolean)false, (String)"Test message %s", (Object)12);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckArgumentWithTwoParams() {
        try {
            Preconditions.checkArgument((boolean)true, (String)"Test message %s %s", (Object)12, null);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkArgument((boolean)false, (String)"Test message %s %s", (Object)12, null);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12 null", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckArgumentWithThreeParams() {
        try {
            Preconditions.checkArgument((boolean)true, (String)"Test message %s %s %s", (Object)12, null, (Object)"column");
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkArgument((boolean)false, (String)"Test message %s %s %s", (Object)12, null, (Object)"column");
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12 null column", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckArgumentWithMoreThanThreeParams() {
        try {
            Preconditions.checkArgument((boolean)true, (String)"Test message %s %s %s %s", (Object[])new Object[]{12, null, "column", true});
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkArgument((boolean)false, (String)"Test message %s %s %s %s", (Object[])new Object[]{12, null, "column", true});
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12 null column true", (Object)e.getMessage());
        }
    }

    @Test
    public void checkArgumentMessageOnlySupportsStringTypeTemplate() {
        try {
            Preconditions.checkArgument((boolean)true, (String)"Test message %d", (Object)12);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkArgument((boolean)false, (String)"Test message %d", (Object)12);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"%d is not a valid format option", (Object)"d != java.lang.String", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckState() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message: %s %s", (Object)12, null);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message: %s %s", (Object)12, null);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message: 12 null", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckStateWithoutArguments() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message");
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message");
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckStateWithOneArgument() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message %s", (Object)12);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message %s", (Object)12);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckStateWithTwoArguments() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message %s %s", (Object)12, null);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message %s %s", (Object)12, null);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12 null", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckStateWithThreeArguments() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message %s %s %s", (Object)12, null, (Object)"column");
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message %s %s %s", (Object)12, null, (Object)"column");
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12 null column", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckStateWithMoreThanThreeParams() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message %s %s %s %s", (Object[])new Object[]{12, null, "column", true});
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message %s %s %s %s", (Object[])new Object[]{12, null, "column", true});
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Should format message", (Object)"Test message 12 null column true", (Object)e.getMessage());
        }
    }

    @Test
    public void checkStateMessageOnlySupportsStringTypeTemplate() {
        try {
            Preconditions.checkState((boolean)true, (String)"Test message %d", (Object)12);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should not throw exception when isValid is true");
        }
        try {
            Preconditions.checkState((boolean)false, (String)"Test message %d", (Object)12);
            Assert.fail((String)"Should throw exception when isValid is false");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"%d is not a valid format option", (Object)"d != java.lang.String", (Object)e.getMessage());
        }
    }
}

