/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.glob;

import java.util.Arrays;
import org.apache.parquet.Strings;
import org.apache.parquet.glob.GlobParser;
import org.junit.Assert;
import org.junit.Test;

public class TestGlob {
    @Test
    public void testNoGlobs() {
        Assert.assertEquals(Arrays.asList("foo"), (Object)Strings.expandGlob((String)"foo"));
    }

    @Test
    public void testEmptyGroup() {
        Assert.assertEquals(Arrays.asList(""), (Object)Strings.expandGlob((String)""));
        Assert.assertEquals(Arrays.asList(""), (Object)Strings.expandGlob((String)"{}"));
        Assert.assertEquals(Arrays.asList("a"), (Object)Strings.expandGlob((String)"a{}"));
        Assert.assertEquals(Arrays.asList("ab"), (Object)Strings.expandGlob((String)"a{}b"));
        Assert.assertEquals(Arrays.asList("a"), (Object)Strings.expandGlob((String)"{}a"));
        Assert.assertEquals(Arrays.asList("a"), (Object)Strings.expandGlob((String)"a{}"));
        Assert.assertEquals(Arrays.asList("", ""), (Object)Strings.expandGlob((String)"{,}"));
        Assert.assertEquals(Arrays.asList("ab", "a", "ac"), (Object)Strings.expandGlob((String)"a{b,{},c}"));
    }

    @Test
    public void testSingleLevel() {
        Assert.assertEquals(Arrays.asList("foobar", "foobaz"), (Object)Strings.expandGlob((String)"foo{bar,baz}"));
        Assert.assertEquals(Arrays.asList("startfooend", "startbarend"), (Object)Strings.expandGlob((String)"start{foo,bar}end"));
        Assert.assertEquals(Arrays.asList("fooend", "barend"), (Object)Strings.expandGlob((String)"{foo,bar}end"));
        Assert.assertEquals(Arrays.asList("startfooenda", "startfooendb", "startfooendc", "startfooendd", "startbarenda", "startbarendb", "startbarendc", "startbarendd"), (Object)Strings.expandGlob((String)"start{foo,bar}end{a,b,c,d}"));
        Assert.assertEquals(Arrays.asList("xa", "xb", "xc", "ya", "yb", "yc"), (Object)Strings.expandGlob((String)"{x,y}{a,b,c}"));
        Assert.assertEquals(Arrays.asList("x", "y", "z"), (Object)Strings.expandGlob((String)"{x,y,z}"));
    }

    @Test
    public void testNested() {
        Assert.assertEquals(Arrays.asList("startoneend", "startpretwopostend", "startprethreepostend", "startfourend", "startfiveend", "a", "b", "foox", "fooy"), (Object)Strings.expandGlob((String)"{start{one,pre{two,three}post,{four,five}}end,a,b,foo{x,y}}"));
    }

    @Test
    public void testExtraBraces() {
        Assert.assertEquals(Arrays.asList("x", "y", "z"), (Object)Strings.expandGlob((String)"{{x,y,z}}"));
        Assert.assertEquals(Arrays.asList("x", "y", "z"), (Object)Strings.expandGlob((String)"{{{x,y,z}}}"));
        Assert.assertEquals(Arrays.asList("startx", "starta", "startb", "starty"), (Object)Strings.expandGlob((String)"start{x,{a,b},y}"));
    }

    @Test
    public void testCommaInTopLevel() {
        try {
            Strings.expandGlob((String)"foo,bar");
            junit.framework.Assert.fail((String)"This should throw");
        }
        catch (GlobParser.GlobParseException e) {
            junit.framework.Assert.assertEquals((String)"Unexpected comma outside of a {} group:\nfoo,bar\n---^", (String)e.getMessage());
        }
    }

    @Test
    public void testCommaCornerCases() {
        Assert.assertEquals(Arrays.asList("foobar", "foo", "foobaz"), (Object)Strings.expandGlob((String)"foo{bar,,baz}"));
        Assert.assertEquals(Arrays.asList("foo", "foobar", "foobaz"), (Object)Strings.expandGlob((String)"foo{,bar,baz}"));
        Assert.assertEquals(Arrays.asList("foobar", "foobaz", "foo"), (Object)Strings.expandGlob((String)"foo{bar,baz,}"));
        Assert.assertEquals(Arrays.asList("foobar", "foo", "foo", "foobaz"), (Object)Strings.expandGlob((String)"foo{bar,,,baz}"));
        Assert.assertEquals(Arrays.asList("foo", "foo", "foobar", "foobaz"), (Object)Strings.expandGlob((String)"foo{,,bar,baz}"));
        Assert.assertEquals(Arrays.asList("foobar", "foobaz", "foo", "foo"), (Object)Strings.expandGlob((String)"foo{bar,baz,,}"));
        Assert.assertEquals(Arrays.asList("x", "y", "", "a", "b"), (Object)Strings.expandGlob((String)"{{x,y},,{a,b}}"));
    }

    private void assertNotEnoughCloseBraces(String s) {
        String expected = "Not enough close braces in: ";
        try {
            Strings.expandGlob((String)s);
            junit.framework.Assert.fail((String)"this should throw");
        }
        catch (GlobParser.GlobParseException e) {
            junit.framework.Assert.assertEquals((String)expected, (String)e.getMessage().substring(0, expected.length()));
        }
    }

    private void assertTooManyCloseBraces(String s) {
        String expected = "Unexpected closing }:";
        try {
            Strings.expandGlob((String)s);
            junit.framework.Assert.fail((String)"this should throw");
        }
        catch (GlobParser.GlobParseException e) {
            junit.framework.Assert.assertEquals((String)expected, (String)e.getMessage().substring(0, expected.length()));
        }
    }

    @Test
    public void testMismatchedBraces() {
        this.assertNotEnoughCloseBraces("{");
        this.assertNotEnoughCloseBraces("{}{}{}{{}{}{");
        this.assertNotEnoughCloseBraces("foo{bar");
        this.assertNotEnoughCloseBraces("foo{{bar}");
        this.assertNotEnoughCloseBraces("foo{}{{bar}");
        this.assertTooManyCloseBraces("{}}{");
        this.assertTooManyCloseBraces("}");
        this.assertTooManyCloseBraces("{}{}{}}{}{}{");
        this.assertTooManyCloseBraces("foo}bar");
        this.assertTooManyCloseBraces("foo}}bar}");
        this.assertTooManyCloseBraces("foo{}{{bar}}}");
    }
}

