/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.util;

import org.apache.parquet.TestUtils;
import org.apache.parquet.util.Concatenator;
import org.apache.parquet.util.DynConstructors;
import org.apache.parquet.util.DynMethods;
import org.junit.Assert;
import org.junit.Test;

public class TestDynConstructors {
    @Test
    public void testNoImplCall() {
        DynConstructors.Builder builder = new DynConstructors.Builder();
        TestUtils.assertThrows("Checked build should throw NoSuchMethodException", NoSuchMethodException.class, () -> ((DynConstructors.Builder)builder).buildChecked());
        TestUtils.assertThrows("Normal build should throw RuntimeException", RuntimeException.class, () -> ((DynConstructors.Builder)builder).build());
    }

    @Test
    public void testMissingClass() {
        DynConstructors.Builder builder = new DynConstructors.Builder().impl("not.a.RealClass", new Class[0]);
        TestUtils.assertThrows("Checked build should throw NoSuchMethodException", NoSuchMethodException.class, () -> ((DynConstructors.Builder)builder).buildChecked());
        TestUtils.assertThrows("Normal build should throw RuntimeException", RuntimeException.class, () -> ((DynConstructors.Builder)builder).build());
    }

    @Test
    public void testMissingConstructor() {
        DynConstructors.Builder builder = new DynConstructors.Builder().impl(Concatenator.class, new Class[]{String.class, String.class});
        TestUtils.assertThrows("Checked build should throw NoSuchMethodException", NoSuchMethodException.class, () -> ((DynConstructors.Builder)builder).buildChecked());
        TestUtils.assertThrows("Normal build should throw RuntimeException", RuntimeException.class, () -> ((DynConstructors.Builder)builder).build());
    }

    @Test
    public void testFirstImplReturned() throws Exception {
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().impl("not.a.RealClass", new Class[]{String.class}).impl(Concatenator.class, new Class[]{String.class}).impl(Concatenator.class, new Class[0]).buildChecked();
        Concatenator dashCat = (Concatenator)sepCtor.newInstanceChecked(new Object[]{"-"});
        Assert.assertEquals((String)"Should construct with the 1-arg version", (Object)"a-b", (Object)dashCat.concat("a", "b"));
        TestUtils.assertThrows("Should complain about extra arguments", IllegalArgumentException.class, () -> sepCtor.newInstanceChecked(new Object[]{"/", "-"}));
        TestUtils.assertThrows("Should complain about extra arguments", IllegalArgumentException.class, () -> sepCtor.newInstance(new Object[]{"/", "-"}));
        DynConstructors.Ctor defaultCtor = new DynConstructors.Builder().impl("not.a.RealClass", new Class[]{String.class}).impl(Concatenator.class, new Class[0]).impl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Concatenator cat = (Concatenator)defaultCtor.newInstanceChecked(new Object[0]);
        Assert.assertEquals((String)"Should construct with the no-arg version", (Object)"ab", (Object)cat.concat("a", "b"));
    }

    @Test
    public void testExceptionThrown() throws Exception {
        Concatenator.SomeCheckedException exc = new Concatenator.SomeCheckedException();
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().impl("not.a.RealClass", new Class[]{String.class}).impl(Concatenator.class, new Class[]{Exception.class}).buildChecked();
        TestUtils.assertThrows("Should re-throw the exception", Concatenator.SomeCheckedException.class, () -> sepCtor.newInstanceChecked(new Object[]{exc}));
        TestUtils.assertThrows("Should wrap the exception in RuntimeException", RuntimeException.class, () -> sepCtor.newInstance(new Object[]{exc}));
    }

    @Test
    public void testStringClassname() throws Exception {
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().impl(Concatenator.class.getName(), new Class[]{String.class}).buildChecked();
        Assert.assertNotNull((String)"Should find 1-arg constructor", (Object)sepCtor.newInstance(new Object[]{"-"}));
    }

    @Test
    public void testHiddenMethod() throws Exception {
        TestUtils.assertThrows("Should fail to find hidden method", NoSuchMethodException.class, () -> new DynMethods.Builder("setSeparator").impl(Concatenator.class, new Class[]{Character.TYPE}).buildChecked());
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().hiddenImpl(Concatenator.class.getName(), new Class[]{Character.TYPE}).buildChecked();
        Assert.assertNotNull((String)"Should find hidden ctor with hiddenImpl", (Object)sepCtor);
        Concatenator slashCat = (Concatenator)sepCtor.newInstanceChecked(new Object[]{Character.valueOf('/')});
        Assert.assertEquals((String)"Should use separator /", (Object)"a/b", (Object)slashCat.concat("a", "b"));
    }

    @Test
    public void testBind() throws Exception {
        DynConstructors.Ctor ctor = new DynConstructors.Builder().impl(Concatenator.class.getName(), new Class[0]).buildChecked();
        Assert.assertTrue((String)"Should always be static", (boolean)ctor.isStatic());
        TestUtils.assertThrows("Should complain that method is static", IllegalStateException.class, () -> ctor.bind(null));
    }

    @Test
    public void testInvoke() throws Exception {
        DynConstructors.Ctor ctor = new DynConstructors.Builder().impl(Concatenator.class.getName(), new Class[0]).buildChecked();
        TestUtils.assertThrows("Should complain that target must be null", IllegalArgumentException.class, () -> TestDynConstructors.lambda$testInvoke$6((DynMethods.UnboundMethod)ctor));
        TestUtils.assertThrows("Should complain that target must be null", IllegalArgumentException.class, () -> TestDynConstructors.lambda$testInvoke$7((DynMethods.UnboundMethod)ctor));
        Assert.assertNotNull((String)"Should allow invokeChecked(null, ...)", (Object)ctor.invokeChecked(null, new Object[0]));
        Assert.assertNotNull((String)"Should allow invoke(null, ...)", (Object)ctor.invoke(null, new Object[0]));
    }

    private static /* synthetic */ Object lambda$testInvoke$7(DynMethods.UnboundMethod ctor) throws Exception {
        return ctor.invoke((Object)"a", new Object[0]);
    }

    private static /* synthetic */ Object lambda$testInvoke$6(DynMethods.UnboundMethod ctor) throws Exception {
        return ctor.invokeChecked((Object)"a", new Object[0]);
    }
}

