/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public abstract class IncrementallyUpdatedFilterPredicateBuilderBase
implements FilterPredicate.Visitor<IncrementallyUpdatedFilterPredicate> {
    private boolean built = false;
    private final Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn = new HashMap<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>>();

    public final IncrementallyUpdatedFilterPredicate build(FilterPredicate pred) {
        Preconditions.checkArgument(!this.built, "This builder has already been used");
        IncrementallyUpdatedFilterPredicate incremental = pred.accept(this);
        this.built = true;
        return incremental;
    }

    protected final void addValueInspector(ColumnPath columnPath, IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector) {
        List<IncrementallyUpdatedFilterPredicate.ValueInspector> valueInspectors = this.valueInspectorsByColumn.get(columnPath);
        if (valueInspectors == null) {
            valueInspectors = new ArrayList<IncrementallyUpdatedFilterPredicate.ValueInspector>();
            this.valueInspectorsByColumn.put(columnPath, valueInspectors);
        }
        valueInspectors.add(valueInspector);
    }

    public Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> getValueInspectorsByColumn() {
        return this.valueInspectorsByColumn;
    }

    @Override
    public final IncrementallyUpdatedFilterPredicate visit(Operators.And and) {
        return new IncrementallyUpdatedFilterPredicate.And(and.getLeft().accept(this), and.getRight().accept(this));
    }

    @Override
    public final IncrementallyUpdatedFilterPredicate visit(Operators.Or or) {
        return new IncrementallyUpdatedFilterPredicate.Or(or.getLeft().accept(this), or.getRight().accept(this));
    }

    @Override
    public final IncrementallyUpdatedFilterPredicate visit(Operators.Not not) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? " + not);
    }
}

