/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.PrintFooter;
import org.apache.parquet.hadoop.TestUtils;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.GlobalMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParquetFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TestParquetFileWriter.class);
    private static final MessageType SCHEMA = MessageTypeParser.parseMessageType((String)"message m {  required group a {    required binary b;  }  required group c {    required int64 d;  }}");
    private static final String[] PATH1 = new String[]{"a", "b"};
    private static final ColumnDescriptor C1 = SCHEMA.getColumnDescription(PATH1);
    private static final String[] PATH2 = new String[]{"c", "d"};
    private static final ColumnDescriptor C2 = SCHEMA.getColumnDescription(PATH2);
    private static final byte[] BYTES1 = new byte[]{0, 1, 2, 3};
    private static final byte[] BYTES2 = new byte[]{1, 2, 3, 4};
    private static final byte[] BYTES3 = new byte[]{2, 3, 4, 5};
    private static final byte[] BYTES4 = new byte[]{3, 4, 5, 6};
    private static final CompressionCodecName CODEC = CompressionCodecName.UNCOMPRESSED;
    private static final Statistics<?> EMPTY_STATS = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("test_binary"))).build();
    private String writeSchema;
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testWriteMode() throws Exception {
        File testFile = this.temp.newFile();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;} required group c { required int64 d; }}");
        Configuration conf = new Configuration();
        ParquetFileWriter writer = null;
        boolean exceptionThrown = false;
        Path path = new Path(testFile.toURI());
        try {
            writer = new ParquetFileWriter(conf, schema, path, ParquetFileWriter.Mode.CREATE);
        }
        catch (IOException ioe1) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            writer = new ParquetFileWriter(conf, schema, path, ParquetFileWriter.Mode.OVERWRITE);
        }
        catch (IOException ioe2) {
            exceptionThrown = true;
        }
        Assert.assertTrue((!exceptionThrown ? 1 : 0) != 0);
        testFile.delete();
    }

    @Test
    public void testWriteRead() throws Exception {
        File testFile = this.temp.newFile();
        testFile.delete();
        Path path = new Path(testFile.toURI());
        Configuration configuration = new Configuration();
        ParquetFileWriter w = new ParquetFileWriter(configuration, SCHEMA, path);
        w.start();
        w.startBlock(3L);
        w.startColumn(C1, 5L, CODEC);
        long c1Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])BYTES1), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])BYTES1), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c1Ends = w.getPos();
        w.startColumn(C2, 6L, CODEC);
        long c2Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c2Ends = w.getPos();
        w.endBlock();
        w.startBlock(4L);
        w.startColumn(C1, 7L, CODEC);
        w.writeDataPage(7, 4, BytesInput.from((byte[])BYTES3), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(C2, 8L, CODEC);
        w.writeDataPage(8, 4, BytesInput.from((byte[])BYTES4), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.end(new HashMap());
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
        Assert.assertEquals((String)("footer: " + readFooter), (long)2L, (long)readFooter.getBlocks().size());
        Assert.assertEquals((long)(c1Ends - c1Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c2Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(1)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c1Starts), (long)((BlockMetaData)readFooter.getBlocks().get(0)).getTotalByteSize());
        HashSet<Encoding> expectedEncoding = new HashSet<Encoding>();
        expectedEncoding.add(Encoding.PLAIN);
        expectedEncoding.add(Encoding.BIT_PACKED);
        Assert.assertEquals(expectedEncoding, (Object)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getEncodings());
        ParquetFileReader r = new ParquetFileReader(configuration, readFooter.getFileMetaData(), path, Arrays.asList((BlockMetaData)readFooter.getBlocks().get(0)), Arrays.asList(SCHEMA.getColumnDescription(PATH1)));
        PageReadStore pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 2, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH1, 3, BytesInput.from((byte[])BYTES1));
        Assert.assertNull((Object)r.readNextRowGroup());
        r = new ParquetFileReader(configuration, readFooter.getFileMetaData(), path, readFooter.getBlocks(), Arrays.asList(SCHEMA.getColumnDescription(PATH1), SCHEMA.getColumnDescription(PATH2)));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 2, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH1, 3, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH2, 2, BytesInput.from((byte[])BYTES2));
        this.validateContains(SCHEMA, pages, PATH2, 3, BytesInput.from((byte[])BYTES2));
        this.validateContains(SCHEMA, pages, PATH2, 1, BytesInput.from((byte[])BYTES2));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)4L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 7, BytesInput.from((byte[])BYTES3));
        this.validateContains(SCHEMA, pages, PATH2, 8, BytesInput.from((byte[])BYTES4));
        Assert.assertNull((Object)r.readNextRowGroup());
        PrintFooter.main((String[])new String[]{path.toString()});
    }

    @Test
    public void testAlignmentWithPadding() throws Exception {
        File testFile = this.temp.newFile();
        Path path = new Path(testFile.toURI());
        Configuration conf = new Configuration();
        ParquetFileWriter w = new ParquetFileWriter(conf, SCHEMA, path, 120L, 60);
        w.start();
        w.startBlock(3L);
        w.startColumn(C1, 5L, CODEC);
        long c1Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])BYTES1), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])BYTES1), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c1Ends = w.getPos();
        w.startColumn(C2, 6L, CODEC);
        long c2Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c2Ends = w.getPos();
        w.endBlock();
        long firstRowGroupEnds = w.getPos();
        w.startBlock(4L);
        w.startColumn(C1, 7L, CODEC);
        w.writeDataPage(7, 4, BytesInput.from((byte[])BYTES3), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(C2, 8L, CODEC);
        w.writeDataPage(8, 4, BytesInput.from((byte[])BYTES4), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        long secondRowGroupEnds = w.getPos();
        w.end(new HashMap());
        FileSystem fs = path.getFileSystem(conf);
        long fileLen = fs.getFileStatus(path).getLen();
        FSDataInputStream data = fs.open(path);
        data.seek(fileLen - 8L);
        long footerLen = BytesUtils.readIntLittleEndian((InputStream)data);
        long startFooter = fileLen - footerLen - 8L;
        Assert.assertEquals((String)"Footer should start after second row group without padding", (long)secondRowGroupEnds, (long)startFooter);
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)conf, (Path)path);
        Assert.assertEquals((String)("footer: " + readFooter), (long)2L, (long)readFooter.getBlocks().size());
        Assert.assertEquals((long)(c1Ends - c1Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c2Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(1)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c1Starts), (long)((BlockMetaData)readFooter.getBlocks().get(0)).getTotalByteSize());
        HashSet<Encoding> expectedEncoding = new HashSet<Encoding>();
        expectedEncoding.add(Encoding.PLAIN);
        expectedEncoding.add(Encoding.BIT_PACKED);
        Assert.assertEquals(expectedEncoding, (Object)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getEncodings());
        Assert.assertEquals((String)"First row group should start after magic", (long)4L, (long)((BlockMetaData)readFooter.getBlocks().get(0)).getStartingPos());
        Assert.assertTrue((String)"First row group should end before the block size (120)", (firstRowGroupEnds < 120L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Second row group should start at the block size", (long)120L, (long)((BlockMetaData)readFooter.getBlocks().get(1)).getStartingPos());
        ParquetFileReader r = new ParquetFileReader(conf, readFooter.getFileMetaData(), path, Arrays.asList((BlockMetaData)readFooter.getBlocks().get(0)), Arrays.asList(SCHEMA.getColumnDescription(PATH1)));
        PageReadStore pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 2, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH1, 3, BytesInput.from((byte[])BYTES1));
        Assert.assertNull((Object)r.readNextRowGroup());
        r = new ParquetFileReader(conf, readFooter.getFileMetaData(), path, readFooter.getBlocks(), Arrays.asList(SCHEMA.getColumnDescription(PATH1), SCHEMA.getColumnDescription(PATH2)));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 2, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH1, 3, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH2, 2, BytesInput.from((byte[])BYTES2));
        this.validateContains(SCHEMA, pages, PATH2, 3, BytesInput.from((byte[])BYTES2));
        this.validateContains(SCHEMA, pages, PATH2, 1, BytesInput.from((byte[])BYTES2));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)4L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 7, BytesInput.from((byte[])BYTES3));
        this.validateContains(SCHEMA, pages, PATH2, 8, BytesInput.from((byte[])BYTES4));
        Assert.assertNull((Object)r.readNextRowGroup());
        PrintFooter.main((String[])new String[]{path.toString()});
    }

    @Test
    public void testAlignmentWithNoPaddingNeeded() throws Exception {
        File testFile = this.temp.newFile();
        Path path = new Path(testFile.toURI());
        Configuration conf = new Configuration();
        ParquetFileWriter w = new ParquetFileWriter(conf, SCHEMA, path, 100L, 50);
        w.start();
        w.startBlock(3L);
        w.startColumn(C1, 5L, CODEC);
        long c1Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])BYTES1), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])BYTES1), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c1Ends = w.getPos();
        w.startColumn(C2, 6L, CODEC);
        long c2Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])BYTES2), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c2Ends = w.getPos();
        w.endBlock();
        long firstRowGroupEnds = w.getPos();
        w.startBlock(4L);
        w.startColumn(C1, 7L, CODEC);
        w.writeDataPage(7, 4, BytesInput.from((byte[])BYTES3), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(C2, 8L, CODEC);
        w.writeDataPage(8, 4, BytesInput.from((byte[])BYTES4), EMPTY_STATS, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        long secondRowGroupEnds = w.getPos();
        w.end(new HashMap());
        FileSystem fs = path.getFileSystem(conf);
        long fileLen = fs.getFileStatus(path).getLen();
        FSDataInputStream data = fs.open(path);
        data.seek(fileLen - 8L);
        long footerLen = BytesUtils.readIntLittleEndian((InputStream)data);
        long startFooter = fileLen - footerLen - 8L;
        Assert.assertEquals((String)"Footer should start after second row group without padding", (long)secondRowGroupEnds, (long)startFooter);
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)conf, (Path)path);
        Assert.assertEquals((String)("footer: " + readFooter), (long)2L, (long)readFooter.getBlocks().size());
        Assert.assertEquals((long)(c1Ends - c1Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c2Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(1)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c1Starts), (long)((BlockMetaData)readFooter.getBlocks().get(0)).getTotalByteSize());
        HashSet<Encoding> expectedEncoding = new HashSet<Encoding>();
        expectedEncoding.add(Encoding.PLAIN);
        expectedEncoding.add(Encoding.BIT_PACKED);
        Assert.assertEquals(expectedEncoding, (Object)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getEncodings());
        Assert.assertEquals((String)"First row group should start after magic", (long)4L, (long)((BlockMetaData)readFooter.getBlocks().get(0)).getStartingPos());
        Assert.assertTrue((String)"First row group should end before the block size (120)", (firstRowGroupEnds > 100L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Second row group should start after no padding", (long)109L, (long)((BlockMetaData)readFooter.getBlocks().get(1)).getStartingPos());
        ParquetFileReader r = new ParquetFileReader(conf, readFooter.getFileMetaData(), path, Arrays.asList((BlockMetaData)readFooter.getBlocks().get(0)), Arrays.asList(SCHEMA.getColumnDescription(PATH1)));
        PageReadStore pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 2, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH1, 3, BytesInput.from((byte[])BYTES1));
        Assert.assertNull((Object)r.readNextRowGroup());
        r = new ParquetFileReader(conf, readFooter.getFileMetaData(), path, readFooter.getBlocks(), Arrays.asList(SCHEMA.getColumnDescription(PATH1), SCHEMA.getColumnDescription(PATH2)));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 2, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH1, 3, BytesInput.from((byte[])BYTES1));
        this.validateContains(SCHEMA, pages, PATH2, 2, BytesInput.from((byte[])BYTES2));
        this.validateContains(SCHEMA, pages, PATH2, 3, BytesInput.from((byte[])BYTES2));
        this.validateContains(SCHEMA, pages, PATH2, 1, BytesInput.from((byte[])BYTES2));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)4L, (long)pages.getRowCount());
        this.validateContains(SCHEMA, pages, PATH1, 7, BytesInput.from((byte[])BYTES3));
        this.validateContains(SCHEMA, pages, PATH2, 8, BytesInput.from((byte[])BYTES4));
        Assert.assertNull((Object)r.readNextRowGroup());
        PrintFooter.main((String[])new String[]{path.toString()});
    }

    @Test
    public void testConvertToThriftStatistics() throws Exception {
        long[] longArray = new long[]{39L, 99L, 12L, 1000L, 65L, 542L, 2533461316L, -253346131996L, Long.MAX_VALUE, Long.MIN_VALUE};
        LongStatistics parquetMRstats = new LongStatistics();
        for (long l : longArray) {
            parquetMRstats.updateStats(l);
        }
        String createdBy = "parquet-mr version 1.8.0 (build d4d5a07ec9bd262ca1e93c309f1d7d4a74ebda4c)";
        org.apache.parquet.format.Statistics thriftStats = ParquetMetadataConverter.toParquetStatistics((Statistics)parquetMRstats);
        LongStatistics convertedBackStats = (LongStatistics)ParquetMetadataConverter.fromParquetStatistics((String)"parquet-mr version 1.8.0 (build d4d5a07ec9bd262ca1e93c309f1d7d4a74ebda4c)", (org.apache.parquet.format.Statistics)thriftStats, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64);
        Assert.assertEquals((long)parquetMRstats.getMax(), (long)convertedBackStats.getMax());
        Assert.assertEquals((long)parquetMRstats.getMin(), (long)convertedBackStats.getMin());
        Assert.assertEquals((long)parquetMRstats.getNumNulls(), (long)convertedBackStats.getNumNulls());
    }

    @Test
    public void testWriteReadStatistics() throws Exception {
        Assume.assumeTrue((!CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.10.1 (build a89df8f9932b6ef6633d06069e50c9b7970bebd1)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY) ? 1 : 0) != 0);
        File testFile = this.temp.newFile();
        testFile.delete();
        Path path = new Path(testFile.toURI());
        Configuration configuration = new Configuration();
        configuration.setBoolean("parquet.strings.signed-min-max.enabled", true);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b (UTF8);} required group c { required int64 d; }}");
        String[] path1 = new String[]{"a", "b"};
        ColumnDescriptor c1 = schema.getColumnDescription(path1);
        String[] path2 = new String[]{"c", "d"};
        ColumnDescriptor c2 = schema.getColumnDescription(path2);
        byte[] bytes1 = new byte[]{0, 1, 2, 3};
        byte[] bytes2 = new byte[]{1, 2, 3, 4};
        byte[] bytes3 = new byte[]{2, 3, 4, 5};
        byte[] bytes4 = new byte[]{3, 4, 5, 6};
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        BinaryStatistics statsB1C1P1 = new BinaryStatistics();
        BinaryStatistics statsB1C1P2 = new BinaryStatistics();
        LongStatistics statsB1C2P1 = new LongStatistics();
        LongStatistics statsB1C2P2 = new LongStatistics();
        BinaryStatistics statsB2C1P1 = new BinaryStatistics();
        LongStatistics statsB2C2P1 = new LongStatistics();
        statsB1C1P1.setMinMax(Binary.fromString((String)"s"), Binary.fromString((String)"z"));
        statsB1C1P2.setMinMax(Binary.fromString((String)"a"), Binary.fromString((String)"b"));
        statsB1C2P1.setMinMax(2L, 10L);
        statsB1C2P2.setMinMax(-6L, 4L);
        statsB2C1P1.setMinMax(Binary.fromString((String)"d"), Binary.fromString((String)"e"));
        statsB2C2P1.setMinMax(11L, 122L);
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, path);
        w.start();
        w.startBlock(3L);
        w.startColumn(c1, 5L, codec);
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes1), (Statistics)statsB1C1P1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes1), (Statistics)statsB1C1P2, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 6L, codec);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes2), (Statistics)statsB1C2P1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])bytes2), (Statistics)statsB1C2P2, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.startBlock(4L);
        w.startColumn(c1, 7L, codec);
        w.writeDataPage(7, 4, BytesInput.from((byte[])bytes3), (Statistics)statsB2C1P1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 8L, codec);
        w.writeDataPage(8, 4, BytesInput.from((byte[])bytes4), (Statistics)statsB2C2P1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.end(new HashMap());
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
        for (BlockMetaData block : readFooter.getBlocks()) {
            for (ColumnChunkMetaData col : block.getColumns()) {
                col.getPath();
            }
        }
        BinaryStatistics bs1 = new BinaryStatistics();
        bs1.setMinMax(Binary.fromString((String)"a"), Binary.fromString((String)"z"));
        LongStatistics ls1 = new LongStatistics();
        ls1.setMinMax(-6L, 10L);
        BinaryStatistics bs2 = new BinaryStatistics();
        bs2.setMinMax(Binary.fromString((String)"d"), Binary.fromString((String)"e"));
        LongStatistics ls2 = new LongStatistics();
        ls2.setMinMax(11L, 122L);
        BinaryStatistics bsout = (BinaryStatistics)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getStatistics();
        String str = new String(bsout.getMaxBytes());
        String str2 = new String(bsout.getMinBytes());
        TestUtils.assertStatsValuesEqual(bs1, ((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getStatistics());
        TestUtils.assertStatsValuesEqual(ls1, ((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(1)).getStatistics());
        TestUtils.assertStatsValuesEqual(bs2, ((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(1)).getColumns().get(0)).getStatistics());
        TestUtils.assertStatsValuesEqual(ls2, ((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(1)).getColumns().get(1)).getStatistics());
    }

    @Test
    public void testMetaDataFile() throws Exception {
        File testDir = this.temp.newFolder();
        Path testDirPath = new Path(testDir.toURI());
        Configuration configuration = new Configuration();
        FileSystem fs = testDirPath.getFileSystem(configuration);
        TestUtils.enforceEmptyDir(configuration, testDirPath);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;} required group c { required int64 d; }}");
        this.createFile(configuration, new Path(testDirPath, "part0"), schema);
        this.createFile(configuration, new Path(testDirPath, "part1"), schema);
        this.createFile(configuration, new Path(testDirPath, "part2"), schema);
        FileStatus outputStatus = fs.getFileStatus(testDirPath);
        List footers = ParquetFileReader.readFooters((Configuration)configuration, (FileStatus)outputStatus, (boolean)false);
        this.validateFooters(footers);
        ParquetFileWriter.writeMetadataFile((Configuration)configuration, (Path)testDirPath, (List)footers, (ParquetOutputFormat.JobSummaryLevel)ParquetOutputFormat.JobSummaryLevel.ALL);
        footers = ParquetFileReader.readFooters((Configuration)configuration, (FileStatus)outputStatus, (boolean)false);
        this.validateFooters(footers);
        footers = ParquetFileReader.readFooters((Configuration)configuration, (FileStatus)fs.getFileStatus(new Path(testDirPath, "part0")), (boolean)false);
        Assert.assertEquals((long)1L, (long)footers.size());
        FileStatus metadataFile = fs.getFileStatus(new Path(testDirPath, "_metadata"));
        FileStatus metadataFileLight = fs.getFileStatus(new Path(testDirPath, "_common_metadata"));
        List metadata = ParquetFileReader.readSummaryFile((Configuration)configuration, (FileStatus)metadataFile);
        this.validateFooters(metadata);
        footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles((Configuration)configuration, Arrays.asList(fs.listStatus(testDirPath, (PathFilter)HiddenFileFilter.INSTANCE)), (boolean)false);
        this.validateFooters(footers);
        fs.delete(metadataFile.getPath(), false);
        fs.delete(metadataFileLight.getPath(), false);
        footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles((Configuration)configuration, Arrays.asList(fs.listStatus(testDirPath)), (boolean)false);
        this.validateFooters(footers);
    }

    @Test
    public void testWriteReadStatisticsAllNulls() throws Exception {
        Assume.assumeTrue((!CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.10.1 (build a89df8f9932b6ef6633d06069e50c9b7970bebd1)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY) ? 1 : 0) != 0);
        File testFile = this.temp.newFile();
        testFile.delete();
        this.writeSchema = "message example {\nrequired binary content (UTF8);\n}";
        Path path = new Path(testFile.toURI());
        MessageType schema = MessageTypeParser.parseMessageType((String)this.writeSchema);
        Configuration configuration = new Configuration();
        configuration.setBoolean("parquet.strings.signed-min-max.enabled", true);
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)configuration);
        ParquetWriter writer = new ParquetWriter(path, configuration, (WriteSupport)new GroupWriteSupport());
        SimpleGroup r1 = new SimpleGroup((GroupType)schema);
        writer.write((Object)r1);
        writer.close();
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
        Statistics stats = ((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getStatistics();
        Assert.assertFalse((String)("is empty: " + stats), (boolean)stats.isEmpty());
        Assert.assertEquals((String)("nulls: " + stats), (long)1L, (long)stats.getNumNulls());
    }

    private void validateFooters(List<Footer> metadata) {
        LOG.debug("{}", metadata);
        Assert.assertEquals((String)String.valueOf(metadata), (long)3L, (long)metadata.size());
        for (Footer footer : metadata) {
            File file = new File(footer.getFile().toUri());
            Assert.assertTrue((String)file.getName(), (boolean)file.getName().startsWith("part"));
            Assert.assertTrue((String)file.getPath(), (boolean)file.exists());
            ParquetMetadata parquetMetadata = footer.getParquetMetadata();
            Assert.assertEquals((long)2L, (long)parquetMetadata.getBlocks().size());
            Map keyValueMetaData = parquetMetadata.getFileMetaData().getKeyValueMetaData();
            Assert.assertEquals((Object)"bar", keyValueMetaData.get("foo"));
            Assert.assertEquals((Object)footer.getFile().getName(), keyValueMetaData.get(footer.getFile().getName()));
        }
    }

    private void createFile(Configuration configuration, Path path, MessageType schema) throws IOException {
        String[] path1 = new String[]{"a", "b"};
        ColumnDescriptor c1 = schema.getColumnDescription(path1);
        String[] path2 = new String[]{"c", "d"};
        ColumnDescriptor c2 = schema.getColumnDescription(path2);
        byte[] bytes1 = new byte[]{0, 1, 2, 3};
        byte[] bytes2 = new byte[]{1, 2, 3, 4};
        byte[] bytes3 = new byte[]{2, 3, 4, 5};
        byte[] bytes4 = new byte[]{3, 4, 5, 6};
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        BinaryStatistics stats1 = new BinaryStatistics();
        BinaryStatistics stats2 = new BinaryStatistics();
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, path);
        w.start();
        w.startBlock(3L);
        w.startColumn(c1, 5L, codec);
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes1), (Statistics)stats1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes1), (Statistics)stats1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 6L, codec);
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes2), (Statistics)stats2, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes2), (Statistics)stats2, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])bytes2), (Statistics)stats2, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.startBlock(4L);
        w.startColumn(c1, 7L, codec);
        w.writeDataPage(7, 4, BytesInput.from((byte[])bytes3), (Statistics)stats1, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 8L, codec);
        w.writeDataPage(8, 4, BytesInput.from((byte[])bytes4), (Statistics)stats2, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put("foo", "bar");
        extraMetaData.put(path.getName(), path.getName());
        w.end(extraMetaData);
    }

    private void validateContains(MessageType schema, PageReadStore pages, String[] path, int values, BytesInput bytes) throws IOException {
        PageReader pageReader = pages.getPageReader(schema.getColumnDescription(path));
        DataPage page = pageReader.readPage();
        Assert.assertEquals((long)values, (long)page.getValueCount());
        Assert.assertArrayEquals((byte[])bytes.toByteArray(), (byte[])((DataPageV1)page).getBytes().toByteArray());
    }

    @Test
    public void testMergeMetadata() {
        FileMetaData md1 = new FileMetaData(new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")}), new HashMap(), "test");
        FileMetaData md2 = new FileMetaData(new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), new HashMap(), "test2");
        GlobalMetaData merged = ParquetFileWriter.mergeInto((FileMetaData)md2, (GlobalMetaData)ParquetFileWriter.mergeInto((FileMetaData)md1, null));
        Assert.assertEquals((Object)merged.getSchema(), (Object)new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}));
    }

    @Test
    public void testMergeFooters() {
        ArrayList<BlockMetaData> oneBlocks = new ArrayList<BlockMetaData>();
        oneBlocks.add(new BlockMetaData());
        oneBlocks.add(new BlockMetaData());
        ArrayList<BlockMetaData> twoBlocks = new ArrayList<BlockMetaData>();
        twoBlocks.add(new BlockMetaData());
        ArrayList<BlockMetaData> expected = new ArrayList<BlockMetaData>();
        expected.addAll(oneBlocks);
        expected.addAll(twoBlocks);
        Footer one = new Footer(new Path("file:/tmp/output/one.parquet"), new ParquetMetadata(new FileMetaData(new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")}), new HashMap(), "test"), oneBlocks));
        Footer two = new Footer(new Path("/tmp/output/two.parquet"), new ParquetMetadata(new FileMetaData(new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), new HashMap(), "test2"), twoBlocks));
        ArrayList<Footer> footers = new ArrayList<Footer>();
        footers.add(one);
        footers.add(two);
        ParquetMetadata merged = ParquetFileWriter.mergeFooters((Path)new Path("/tmp"), footers);
        Assert.assertEquals((Object)new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), (Object)merged.getFileMetaData().getSchema());
        Assert.assertEquals((String)"Should have all blocks", expected, (Object)merged.getBlocks());
    }

    @Test
    public void testWriteMetadataFileWithRelativeOutputPath() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path relativeRoot = new Path("target/_test_relative");
        Path qualifiedRoot = fs.makeQualified(relativeRoot);
        ParquetMetadata mock = (ParquetMetadata)Mockito.mock(ParquetMetadata.class);
        FileMetaData fileMetaData = new FileMetaData(new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new HashMap(), "test");
        Mockito.when((Object)mock.getFileMetaData()).thenReturn((Object)fileMetaData);
        ArrayList<Footer> footers = new ArrayList<Footer>();
        Footer footer = new Footer(new Path(qualifiedRoot, "one"), mock);
        footers.add(footer);
        ParquetFileWriter.writeMetadataFile((Configuration)conf, (Path)relativeRoot, footers, (ParquetOutputFormat.JobSummaryLevel)ParquetOutputFormat.JobSummaryLevel.ALL);
    }
}

