/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import net.openhft.hashing.LongHashFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.TestUtils;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriter {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        Path root = new Path("target/tests/TestParquetWriter/");
        TestUtils.enforceEmptyDir(conf, root);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(3) flba_field; required int96 int96_field; } ");
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        HashMap<String, Encoding> expected = new HashMap<String, Encoding>();
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN);
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.RLE_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.DELTA_BYTE_ARRAY);
        for (int modulo : Arrays.asList(10, 1000)) {
            for (ParquetProperties.WriterVersion version : ParquetProperties.WriterVersion.values()) {
                Path file = new Path(root, version.name() + "_" + modulo);
                ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new TestOutputFile(file, conf)).withCompressionCodec(CompressionCodecName.UNCOMPRESSED)).withRowGroupSize(1024)).withPageSize(1024)).withDictionaryPageSize(512)).enableDictionaryEncoding()).withValidation(false)).withWriterVersion(version)).withConf(conf)).build();
                for (int i = 0; i < 1000; ++i) {
                    writer.write((Object)f.newGroup().append("binary_field", "test" + i % modulo).append("int32_field", 32).append("int64_field", 64L).append("boolean_field", true).append("float_field", 1.0f).append("double_field", 2.0).append("flba_field", "foo").append("int96_field", Binary.fromConstantByteArray((byte[])new byte[12])));
                }
                writer.close();
                ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).build();
                for (int i = 0; i < 1000; ++i) {
                    Group group = (Group)reader.read();
                    Assert.assertEquals((Object)("test" + i % modulo), (Object)group.getBinary("binary_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((long)32L, (long)group.getInteger("int32_field", 0));
                    Assert.assertEquals((long)64L, (long)group.getLong("int64_field", 0));
                    Assert.assertEquals((Object)true, (Object)group.getBoolean("boolean_field", 0));
                    Assert.assertEquals((double)1.0, (double)group.getFloat("float_field", 0), (double)0.001);
                    Assert.assertEquals((double)2.0, (double)group.getDouble("double_field", 0), (double)0.001);
                    Assert.assertEquals((Object)"foo", (Object)group.getBinary("flba_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((Object)Binary.fromConstantByteArray((byte[])new byte[12]), (Object)group.getInt96("int96_field", 0));
                }
                reader.close();
                ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                for (BlockMetaData blockMetaData : footer.getBlocks()) {
                    for (ColumnChunkMetaData column : blockMetaData.getColumns()) {
                        if (!column.getPath().toDotString().equals("binary_field")) continue;
                        String key = modulo + "-" + version;
                        Encoding expectedEncoding = (Encoding)expected.get(key);
                        Assert.assertTrue((String)(key + ":" + column.getEncodings() + " should contain " + expectedEncoding), (boolean)column.getEncodings().contains(expectedEncoding));
                    }
                }
                Assert.assertEquals((String)"Object model property should be example", (Object)"example", footer.getFileMetaData().getKeyValueMetaData().get("writer.model.name"));
            }
        }
    }

    @Test
    public void testBadWriteSchema() throws IOException {
        File file = this.temp.newFile("test.parquet");
        file.delete();
        TestUtils.assertThrows("Should reject a schema with an empty group", InvalidSchemaException.class, () -> {
            ExampleParquetWriter.builder((Path)new Path(file.toString())).withType((MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)new GroupType(Type.Repetition.REQUIRED, "invalid_group", new Type[0]))).named("invalid_message")).build();
            return null;
        });
        Assert.assertFalse((String)"Should not create a file when schema is rejected", (boolean)file.exists());
    }

    @Test
    public void testNullValuesWithPageRowLimit() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.BaseListBuilder.ElementBuilder)Types.buildMessage().optionalList().optionalElement(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("str_list")).named("msg");
        int recordCount = 100;
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Group listNull = factory.newGroup();
        File file = this.temp.newFile();
        file.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withPageRowCountLimit(10)).withConf(conf)).build();){
            for (int i = 0; i < 100; ++i) {
                writer.write((Object)listNull);
            }
        }
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)path).build();){
            int readRecordCount = 0;
            Group group = (Group)reader.read();
            while (group != null) {
                Assert.assertEquals((Object)listNull.toString(), (Object)group.toString());
                ++readRecordCount;
                group = (Group)reader.read();
            }
            Assert.assertEquals((String)"Number of written records should be equal to the read one", (long)100L, (long)readRecordCount);
        }
    }

    @Test
    public void testParquetFileWithBloomFilter() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        String[] testNames = new String[]{"hello", "parquet", "bloom", "filter"};
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        File file = this.temp.newFile();
        file.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withPageRowCountLimit(10)).withConf(conf)).withDictionaryEncoding(false)).withBloomFilterEnabled("name", true)).build();){
            for (String testName : testNames) {
                writer.write((Object)factory.newGroup().append("name", testName));
            }
        }
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            BlockMetaData blockMetaData = (BlockMetaData)reader.getFooter().getBlocks().get(0);
            BloomFilter bloomFilter = reader.getBloomFilterDataReader(blockMetaData).readBloomFilter((ColumnChunkMetaData)blockMetaData.getColumns().get(0));
            for (String name : testNames) {
                Assert.assertTrue((boolean)bloomFilter.findHash(LongHashFunction.xx((long)0L).hashBytes(Binary.fromString((String)name).toByteBuffer())));
            }
        }
    }

    @Test
    public void testParquetFileWritesExpectedNumberOfBlocks() throws IOException {
        this.testParquetFileNumberOfBlocks(100, 10000, 1);
        this.testParquetFileNumberOfBlocks(1, 1, 3);
    }

    private void testParquetFileNumberOfBlocks(int minRowCountForPageSizeCheck, int maxRowCountForPageSizeCheck, int expectedNumberOfBlocks) throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("str")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        File file = this.temp.newFile();
        this.temp.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withConf(conf)).withRowGroupSize(1)).withMinRowCountForPageSizeCheck(minRowCountForPageSizeCheck)).withMaxRowCountForPageSizeCheck(maxRowCountForPageSizeCheck)).build();){
            SimpleGroupFactory factory = new SimpleGroupFactory(schema);
            writer.write((Object)factory.newGroup().append("str", "foo"));
            writer.write((Object)factory.newGroup().append("str", "bar"));
            writer.write((Object)factory.newGroup().append("str", "baz"));
        }
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)conf));){
            ParquetMetadata footer = reader.getFooter();
            Assert.assertEquals((long)expectedNumberOfBlocks, (long)footer.getBlocks().size());
        }
    }

    private static class TestOutputFile
    implements OutputFile {
        private final OutputFile outputFile;

        TestOutputFile(Path path, Configuration conf) throws IOException {
            this.outputFile = HadoopOutputFile.fromPath((Path)path, (Configuration)conf);
        }

        public PositionOutputStream create(long blockSizeHint) throws IOException {
            return this.outputFile.create(blockSizeHint);
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
            return this.outputFile.createOrOverwrite(blockSizeHint);
        }

        public boolean supportsBlockSize() {
            return this.outputFile.supportsBlockSize();
        }

        public long defaultBlockSize() {
            return this.outputFile.defaultBlockSize();
        }
    }
}

