/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInteropReadLz4RawCodec {
    private static final String PARQUET_TESTING_REPO = "https://github.com/apache/parquet-testing/raw/19fcd4d/data/";
    private static String PARQUET_TESTING_PATH = "target/parquet-testing/data";
    private static String SIMPLE_FILE = "lz4_raw_compressed.parquet";
    private static String LARGER_FILE = "lz4_raw_compressed_larger.parquet";
    private static final Logger LOG = LoggerFactory.getLogger(TestInteropReadLz4RawCodec.class);
    private OkHttpClient httpClient = new OkHttpClient();

    @Test
    public void testInteropReadLz4RawSimpleParquetFiles() throws IOException {
        Path rootPath = new Path(PARQUET_TESTING_PATH);
        LOG.info("======== testInteropReadLz4RawSimpleParquetFiles {} ========", (Object)rootPath.toString());
        Path simpleFile = this.downloadInteropFiles(rootPath, SIMPLE_FILE, this.httpClient);
        int expectRows = 4;
        long[] c0ExpectValues = new long[]{1593604800L, 1593604800L, 1593604801L, 1593604801L};
        String[] c1ExpectValues = new String[]{"abc", "def", "abc", "def"};
        double[] c2ExpectValues = new double[]{42.0, 7.7, 42.125, 7.7};
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)simpleFile).build();){
            for (int i = 0; i < 4; ++i) {
                Group group = (Group)reader.read();
                Assert.assertTrue((group != null ? 1 : 0) != 0);
                Assert.assertEquals((long)c0ExpectValues[i], (long)group.getLong(0, 0));
                Assert.assertEquals((Object)c1ExpectValues[i], (Object)group.getString(1, 0));
                Assert.assertEquals((double)c2ExpectValues[i], (double)group.getDouble(2, 0), (double)1.0E-6);
            }
            Assert.assertTrue((reader.read() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInteropReadLz4RawLargerParquetFiles() throws IOException {
        Path rootPath = new Path(PARQUET_TESTING_PATH);
        LOG.info("======== testInteropReadLz4RawLargerParquetFiles {} ========", (Object)rootPath.toString());
        int expectRows = 10000;
        Path largerFile = this.downloadInteropFiles(rootPath, LARGER_FILE, this.httpClient);
        String[] c0ExpectValues = new String[]{"c7ce6bef-d5b0-4863-b199-8ea8c7fb117b", "e8fb9197-cb9f-4118-b67f-fbfa65f61843", "ab52a0cc-c6bb-4d61-8a8f-166dc4b8b13c", "85440778-460a-41ac-aa2e-ac3ee41696bf"};
        int index = 0;
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)largerFile).build();){
            for (int i = 0; i < 10000; ++i) {
                Group group = (Group)reader.read();
                Assert.assertTrue((group != null ? 1 : 0) != 0);
                if (i != 0 && i != 1 && i != 9998 && i != 9999) continue;
                Assert.assertEquals((Object)c0ExpectValues[index], (Object)group.getString(0, 0));
                ++index;
            }
            Assert.assertTrue((reader.read() == null ? 1 : 0) != 0);
        }
    }

    private Path downloadInteropFiles(Path rootPath, String fileName, OkHttpClient httpClient) throws IOException {
        Path file;
        LOG.info("Download interop files if needed");
        Configuration conf = new Configuration();
        FileSystem fs = rootPath.getFileSystem(conf);
        LOG.info(rootPath + " exists?: " + fs.exists(rootPath));
        if (!fs.exists(rootPath)) {
            LOG.info("Create folder for interop files: " + rootPath);
            if (!fs.mkdirs(rootPath)) {
                throw new IOException("Cannot create path " + rootPath);
            }
        }
        if (!fs.exists(file = new Path(rootPath, fileName))) {
            String downloadUrl = PARQUET_TESTING_REPO + fileName;
            LOG.info("Download interop file: " + downloadUrl);
            Request request = new Request.Builder().url(downloadUrl).build();
            Response response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Failed to download file: " + response);
            }
            try (FSDataOutputStream fdos = fs.create(file);){
                fdos.write(response.body().bytes());
            }
        }
        return file;
    }
}

