/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ColumnPruner;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class ColumnPrunerTest {
    private final int numRecord = 1000;
    private ColumnPruner columnPruner = new ColumnPruner();
    private Configuration conf = new Configuration();

    @Test
    public void testPruneOneColumn() throws Exception {
        String inputFile = this.createParquetFile("input");
        String outputFile = ColumnPrunerTest.createTempFile("output");
        List<String> cols = Arrays.asList("Gender");
        this.columnPruner.pruneColumns(this.conf, new Path(inputFile), new Path(outputFile), cols);
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)3L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"DocId");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"Name");
        Assert.assertEquals((Object)((Type)fields.get(2)).getName(), (Object)"Links");
        List subFields = ((Type)fields.get(2)).asGroupType().getFields();
        Assert.assertEquals((long)subFields.size(), (long)2L);
        Assert.assertEquals((Object)((Type)subFields.get(0)).getName(), (Object)"Backward");
        Assert.assertEquals((Object)((Type)subFields.get(1)).getName(), (Object)"Forward");
        List<String> prunePaths = Arrays.asList("Gender");
        this.validateColumns(inputFile, prunePaths);
    }

    @Test
    public void testPruneMultiColumns() throws Exception {
        String inputFile = this.createParquetFile("input");
        String outputFile = ColumnPrunerTest.createTempFile("output");
        String[] cargs = new String[]{inputFile, outputFile, "Name", "Gender"};
        List<String> cols = Arrays.asList("Name", "Gender");
        this.columnPruner.pruneColumns(this.conf, new Path(inputFile), new Path(outputFile), cols);
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)2L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"DocId");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"Links");
        List subFields = ((Type)fields.get(1)).asGroupType().getFields();
        Assert.assertEquals((long)subFields.size(), (long)2L);
        Assert.assertEquals((Object)((Type)subFields.get(0)).getName(), (Object)"Backward");
        Assert.assertEquals((Object)((Type)subFields.get(1)).getName(), (Object)"Forward");
        List<String> prunePaths = Arrays.asList("Name", "Gender");
        this.validateColumns(inputFile, prunePaths);
    }

    @Test
    public void testNotExistsColumn() throws Exception {
        String inputFile = this.createParquetFile("input");
        String outputFile = ColumnPrunerTest.createTempFile("output");
        List<String> cols = Arrays.asList("no_exist");
        this.columnPruner.pruneColumns(this.conf, new Path(inputFile), new Path(outputFile), cols);
    }

    @Test
    public void testPruneNestedColumn() throws Exception {
        String inputFile = this.createParquetFile("input");
        String outputFile = ColumnPrunerTest.createTempFile("output");
        List<String> cols = Arrays.asList("Links.Backward");
        this.columnPruner.pruneColumns(this.conf, new Path(inputFile), new Path(outputFile), cols);
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)4L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"DocId");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"Name");
        Assert.assertEquals((Object)((Type)fields.get(2)).getName(), (Object)"Gender");
        Assert.assertEquals((Object)((Type)fields.get(3)).getName(), (Object)"Links");
        List subFields = ((Type)fields.get(3)).asGroupType().getFields();
        Assert.assertEquals((long)subFields.size(), (long)1L);
        Assert.assertEquals((Object)((Type)subFields.get(0)).getName(), (Object)"Forward");
        List<String> prunePaths = Arrays.asList("Links.Backward");
        this.validateColumns(inputFile, prunePaths);
    }

    @Test
    public void testPruneNestedParentColumn() throws Exception {
        String inputFile = this.createParquetFile("input");
        String outputFile = ColumnPrunerTest.createTempFile("output");
        List<String> cols = Arrays.asList("Links");
        this.columnPruner.pruneColumns(this.conf, new Path(inputFile), new Path(outputFile), cols);
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)3L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"DocId");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"Name");
        Assert.assertEquals((Object)((Type)fields.get(2)).getName(), (Object)"Gender");
        List<String> prunePaths = Arrays.asList("Links");
        this.validateColumns(inputFile, prunePaths);
    }

    @Test
    public void testNotExistsNestedColumn() throws Exception {
        String inputFile = this.createParquetFile("input");
        String outputFile = ColumnPrunerTest.createTempFile("output");
        List<String> cols = Arrays.asList("Links.Not_exists");
        this.columnPruner.pruneColumns(this.conf, new Path(inputFile), new Path(outputFile), cols);
    }

    private void validateColumns(String inputFile, List<String> prunePaths) throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(inputFile)).withConf(this.conf).build();
        for (int i = 0; i < 1000; ++i) {
            Group group = (Group)reader.read();
            if (!prunePaths.contains("DocId")) {
                Assert.assertEquals((long)1L, (long)group.getLong("DocId", 0));
            }
            if (!prunePaths.contains("Name")) {
                Assert.assertEquals((Object)"foo", (Object)group.getBinary("Name", 0).toStringUsingUTF8());
            }
            if (!prunePaths.contains("Gender")) {
                Assert.assertEquals((Object)"male", (Object)group.getBinary("Gender", 0).toStringUsingUTF8());
            }
            if (prunePaths.contains("Links")) continue;
            Group subGroup = group.getGroup("Links", 0);
            if (!prunePaths.contains("Links.Backward")) {
                Assert.assertEquals((long)2L, (long)subGroup.getLong("Backward", 0));
            }
            if (prunePaths.contains("Links.Forward")) continue;
            Assert.assertEquals((long)3L, (long)subGroup.getLong("Forward", 0));
        }
        reader.close();
    }

    private String createParquetFile(String prefix) throws IOException {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")})});
        this.conf.set("parquet.example.schema", schema.toString());
        String file = ColumnPrunerTest.createTempFile(prefix);
        ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(file)).withConf(this.conf);
        try (ParquetWriter writer = builder.build();){
            for (int i = 0; i < 1000; ++i) {
                SimpleGroup g = new SimpleGroup((GroupType)schema);
                g.add("DocId", 1L);
                g.add("Name", "foo");
                g.add("Gender", "male");
                Group links = g.addGroup("Links");
                links.add(0, 2L);
                links.add(1, 3L);
                writer.write((Object)g);
            }
        }
        return file;
    }

    private static String createTempFile(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath().toString() + "/test.parquet";
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }
}

