/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.encodings;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.apache.parquet.statistics.RandomValues;
import org.apache.parquet.statistics.TestStatistics;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class FileEncodingsIT {
    private static final Logger LOG = LoggerFactory.getLogger(FileEncodingsIT.class);
    private static final int RANDOM_SEED = 1;
    private static final int RECORD_COUNT = 2000000;
    private static final int FIXED_LENGTH = 60;
    private static final int TEST_PAGE_SIZE = 16384;
    private static final int TEST_ROW_GROUP_SIZE = 131072;
    private static final int TEST_DICT_PAGE_SIZE = 16384;
    private static final Configuration configuration = new Configuration();
    private static RandomValues.IntGenerator intGenerator;
    private static RandomValues.LongGenerator longGenerator;
    private static RandomValues.Int96Generator int96Generator;
    private static RandomValues.FloatGenerator floatGenerator;
    private static RandomValues.DoubleGenerator doubleGenerator;
    private static RandomValues.BinaryGenerator binaryGenerator;
    private static RandomValues.FixedGenerator fixedBinaryGenerator;
    private PrimitiveType.PrimitiveTypeName paramTypeName;
    private CompressionCodecName compression;
    private TrackingByteBufferAllocator allocator;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        List<Object> codecs;
        List<PrimitiveType.PrimitiveTypeName> types = Arrays.asList(PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        String codecList = System.getenv("TEST_CODECS");
        if (codecList != null) {
            codecs = new ArrayList();
            for (String codec : codecList.split(",")) {
                codecs.add(CompressionCodecName.valueOf((String)codec.toUpperCase(Locale.ENGLISH)));
            }
        } else {
            codecs = Arrays.asList(CompressionCodecName.UNCOMPRESSED);
        }
        System.err.println("Testing codecs: " + codecs);
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (PrimitiveType.PrimitiveTypeName type : types) {
            for (CompressionCodecName compressionCodecName : codecs) {
                parameters.add(new Object[]{type, compressionCodecName});
            }
        }
        return parameters;
    }

    public FileEncodingsIT(PrimitiveType.PrimitiveTypeName typeName, CompressionCodecName compression) {
        this.paramTypeName = typeName;
        this.compression = compression;
    }

    @BeforeClass
    public static void initialize() throws IOException {
        Random random = new Random(1L);
        intGenerator = new RandomValues.IntGenerator(random.nextLong());
        longGenerator = new RandomValues.LongGenerator(random.nextLong());
        int96Generator = new RandomValues.Int96Generator(random.nextLong());
        floatGenerator = new RandomValues.FloatGenerator(random.nextLong());
        doubleGenerator = new RandomValues.DoubleGenerator(random.nextLong());
        binaryGenerator = new RandomValues.BinaryGenerator(random.nextLong());
        fixedBinaryGenerator = new RandomValues.FixedGenerator(random.nextLong(), 60);
    }

    @Before
    public void initAllocator() {
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @After
    public void closeAllocator() {
        this.allocator.close();
    }

    @Test
    public void testFileEncodingsWithoutDictionary() throws Exception {
        boolean DISABLE_DICTIONARY = false;
        List<?> randomValues = this.generateRandomValues(this.paramTypeName, 2000000);
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            LOG.info(String.format("Testing %s/%s/%s encodings using ROW_GROUP_SIZE=%d PAGE_SIZE=%d", writerVersion, this.paramTypeName, this.compression, 131072, 16384));
            Path parquetFile = this.createTempFile();
            this.writeValuesToFile(parquetFile, this.paramTypeName, randomValues, 131072, 16384, false, writerVersion);
            PageGroupValidator.validatePages(parquetFile, randomValues);
        }
    }

    @Test
    public void testFileEncodingsWithDictionary() throws Exception {
        boolean ENABLE_DICTIONARY = true;
        List<?> dictionaryValues = this.generateDictionaryValues(this.paramTypeName, 2000000);
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            LOG.info(String.format("Testing %s/%s/%s + DICTIONARY encodings using ROW_GROUP_SIZE=%d PAGE_SIZE=%d", writerVersion, this.paramTypeName, this.compression, 131072, 16384));
            Path parquetFile = this.createTempFile();
            this.writeValuesToFile(parquetFile, this.paramTypeName, dictionaryValues, 131072, 16384, true, writerVersion);
            PageGroupValidator.validatePages(parquetFile, dictionaryValues);
        }
    }

    private Path createTempFile() throws IOException {
        File tempFile = this.tempFolder.newFile();
        tempFile.delete();
        return new Path(tempFile.getAbsolutePath());
    }

    private void writeValuesToFile(Path file, PrimitiveType.PrimitiveTypeName type, List<?> values, int rowGroupSize, int pageSize, boolean enableDictionary, ParquetProperties.WriterVersion version) throws IOException {
        MessageType schema = type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(type).length(60)).named("field")).named("test") : (MessageType)((Types.GroupBuilder)Types.buildMessage().required(type).named("field")).named("test");
        SimpleGroupFactory message = new SimpleGroupFactory(schema);
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)configuration);
        ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withAllocator((ByteBufferAllocator)this.allocator)).withCompressionCodec(this.compression)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withDictionaryPageSize(16384)).withDictionaryEncoding(enableDictionary)).withWriterVersion(version)).withConf(configuration)).build();
        block8: for (Object o : values) {
            switch (type) {
                case BOOLEAN: {
                    writer.write((Object)message.newGroup().append("field", ((Boolean)o).booleanValue()));
                    continue block8;
                }
                case INT32: {
                    writer.write((Object)message.newGroup().append("field", ((Integer)o).intValue()));
                    continue block8;
                }
                case INT64: {
                    writer.write((Object)message.newGroup().append("field", ((Long)o).longValue()));
                    continue block8;
                }
                case FLOAT: {
                    writer.write((Object)message.newGroup().append("field", ((Float)o).floatValue()));
                    continue block8;
                }
                case DOUBLE: {
                    writer.write((Object)message.newGroup().append("field", ((Double)o).doubleValue()));
                    continue block8;
                }
                case INT96: 
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    writer.write((Object)message.newGroup().append("field", (Binary)o));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown type name: " + type);
        }
        writer.close();
    }

    private List<?> generateRandomValues(PrimitiveType.PrimitiveTypeName type, int count) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            Constable value;
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.valueOf(intGenerator.nextValue() % 2 == 0);
                    break;
                }
                case INT32: {
                    value = intGenerator.nextValue();
                    break;
                }
                case INT64: {
                    value = longGenerator.nextValue();
                    break;
                }
                case FLOAT: {
                    value = floatGenerator.nextValue();
                    break;
                }
                case DOUBLE: {
                    value = doubleGenerator.nextValue();
                    break;
                }
                case INT96: {
                    value = int96Generator.nextBinaryValue();
                    break;
                }
                case BINARY: {
                    value = binaryGenerator.nextBinaryValue();
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    value = fixedBinaryGenerator.nextBinaryValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type name: " + type);
                }
            }
            values.add((Integer)value);
        }
        return values;
    }

    private List<?> generateDictionaryValues(PrimitiveType.PrimitiveTypeName type, int count) {
        int DICT_VALUES_SIZE = 100;
        List<?> DICT_BINARY_VALUES = this.generateRandomValues(PrimitiveType.PrimitiveTypeName.BINARY, 100);
        List<?> DICT_INT96_VALUES = this.generateRandomValues(PrimitiveType.PrimitiveTypeName.INT96, 100);
        List<?> DICT_FIXED_LEN_VALUES = this.generateRandomValues(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 100);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            Constable value;
            int dictValue = i % 100;
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.valueOf(i % 2 == 0);
                    break;
                }
                case INT32: {
                    value = dictValue;
                    break;
                }
                case INT64: {
                    value = dictValue;
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(dictValue);
                    break;
                }
                case DOUBLE: {
                    value = dictValue;
                    break;
                }
                case INT96: {
                    value = DICT_INT96_VALUES.get(dictValue);
                    break;
                }
                case BINARY: {
                    value = DICT_BINARY_VALUES.get(dictValue);
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    value = DICT_FIXED_LEN_VALUES.get(dictValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type name: " + type);
                }
            }
            values.add((Integer)value);
        }
        return values;
    }

    private static class PageValuesValidator {
        private List<?> expectedValues;
        private int currentPos;
        private int pageID;
        private int rowGroupID;

        public PageValuesValidator(int rowGroupID, int pageID, List<?> expectedValues) {
            this.rowGroupID = rowGroupID;
            this.pageID = pageID;
            this.expectedValues = expectedValues;
        }

        public void validateNextValue(Object value) {
            Assert.assertEquals((String)String.format("Value from page is different than expected, ROW_GROUP_ID=%d PAGE_ID=%d VALUE_POS=%d", this.rowGroupID, this.pageID, this.currentPos), this.expectedValues.get(this.currentPos++), (Object)value);
        }

        public static void validateValuesForPage(int rowGroupID, int pageID, DictionaryPage dictPage, DataPage page, ColumnDescriptor columnDesc, List<?> expectedValues) {
            TestStatistics.SingletonPageReader pageReader = new TestStatistics.SingletonPageReader(dictPage, page);
            PrimitiveConverter converter = PageValuesValidator.getConverter(rowGroupID, pageID, columnDesc.getType(), expectedValues);
            ColumnReaderImpl column = new ColumnReaderImpl(columnDesc, (PageReader)pageReader, converter, null);
            int i = 0;
            while ((long)i < pageReader.getTotalValueCount()) {
                column.writeCurrentValueToConverter();
                column.consume();
                ++i;
            }
        }

        private static PrimitiveConverter getConverter(final int rowGroupID, final int pageID, PrimitiveType.PrimitiveTypeName type, final List<?> expectedValues) {
            return (PrimitiveConverter)type.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<PrimitiveConverter, RuntimeException>(){

                public PrimitiveConverter convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    final PageValuesValidator validator = new PageValuesValidator(rowGroupID, pageID, expectedValues);
                    return new PrimitiveConverter(){

                        public void addFloat(float value) {
                            validator.validateNextValue(Float.valueOf(value));
                        }
                    };
                }

                public PrimitiveConverter convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    final PageValuesValidator validator = new PageValuesValidator(rowGroupID, pageID, expectedValues);
                    return new PrimitiveConverter(){

                        public void addDouble(double value) {
                            validator.validateNextValue(value);
                        }
                    };
                }

                public PrimitiveConverter convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    final PageValuesValidator validator = new PageValuesValidator(rowGroupID, pageID, expectedValues);
                    return new PrimitiveConverter(){

                        public void addInt(int value) {
                            validator.validateNextValue(value);
                        }
                    };
                }

                public PrimitiveConverter convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    final PageValuesValidator validator = new PageValuesValidator(rowGroupID, pageID, expectedValues);
                    return new PrimitiveConverter(){

                        public void addLong(long value) {
                            validator.validateNextValue(value);
                        }
                    };
                }

                public PrimitiveConverter convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    return this.convertBINARY(primitiveTypeName);
                }

                public PrimitiveConverter convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    return this.convertBINARY(primitiveTypeName);
                }

                public PrimitiveConverter convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    final PageValuesValidator validator = new PageValuesValidator(rowGroupID, pageID, expectedValues);
                    return new PrimitiveConverter(){

                        public void addBoolean(boolean value) {
                            validator.validateNextValue(value);
                        }
                    };
                }

                public PrimitiveConverter convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                    final PageValuesValidator validator = new PageValuesValidator(rowGroupID, pageID, expectedValues);
                    return new PrimitiveConverter(){

                        public void addBinary(Binary value) {
                            validator.validateNextValue(value);
                        }
                    };
                }
            });
        }
    }

    private static class PageGroupValidator {
        private PageGroupValidator() {
        }

        public static void validatePages(Path file, List<?> expectedValues) throws IOException {
            List<PageReadStore> blockReaders = PageGroupValidator.readBlocksFromFile(file);
            MessageType fileSchema = PageGroupValidator.readSchemaFromFile(file);
            int rowGroupID = 0;
            int rowsRead = 0;
            for (PageReadStore pageReadStore : blockReaders) {
                for (ColumnDescriptor columnsDesc : fileSchema.getColumns()) {
                    List<DataPage> pageGroup = PageGroupValidator.getPageGroupForColumn(pageReadStore, columnsDesc);
                    DictionaryPage dictPage = PageGroupValidator.reusableCopy(PageGroupValidator.getDictionaryPageForColumn(pageReadStore, columnsDesc));
                    List<?> expectedRowGroupValues = expectedValues.subList(rowsRead, (int)((long)rowsRead + pageReadStore.getRowCount()));
                    PageGroupValidator.validateFirstToLast(rowGroupID, dictPage, pageGroup, columnsDesc, expectedRowGroupValues);
                    PageGroupValidator.validateLastToFirst(rowGroupID, dictPage, pageGroup, columnsDesc, expectedRowGroupValues);
                }
                rowsRead = (int)((long)rowsRead + pageReadStore.getRowCount());
                ++rowGroupID;
            }
        }

        private static DictionaryPage reusableCopy(DictionaryPage dict) {
            if (dict == null) {
                return null;
            }
            try {
                return new DictionaryPage(BytesInput.from((byte[])dict.getBytes().toByteArray()), dict.getDictionarySize(), dict.getEncoding());
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Cannot read dictionary", (Throwable)e);
            }
        }

        private static DataPage reusableCopy(DataPage page) {
            return (DataPage)page.accept((DataPage.Visitor)new DataPage.Visitor<DataPage>(){

                public DataPage visit(DataPageV1 data) {
                    try {
                        return new DataPageV1(BytesInput.from((byte[])data.getBytes().toByteArray()), data.getValueCount(), data.getUncompressedSize(), data.getStatistics(), data.getRlEncoding(), data.getDlEncoding(), data.getValueEncoding());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("Cannot read data", (Throwable)e);
                    }
                }

                public DataPage visit(DataPageV2 data) {
                    try {
                        return new DataPageV2(data.getRowCount(), data.getNullCount(), data.getValueCount(), BytesInput.from((byte[])data.getRepetitionLevels().toByteArray()), BytesInput.from((byte[])data.getDefinitionLevels().toByteArray()), data.getDataEncoding(), BytesInput.from((byte[])data.getData().toByteArray()), data.getUncompressedSize(), data.getStatistics(), data.isCompressed());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("Cannot read data", (Throwable)e);
                    }
                }
            });
        }

        private static void validateFirstToLast(int rowGroupID, DictionaryPage dictPage, List<DataPage> pageGroup, ColumnDescriptor desc, List<?> expectedValues) {
            int rowsRead = 0;
            int pageID = 0;
            for (DataPage page : pageGroup) {
                List<?> expectedPageValues = expectedValues.subList(rowsRead, rowsRead + page.getValueCount());
                PageValuesValidator.validateValuesForPage(rowGroupID, pageID, dictPage, page, desc, expectedPageValues);
                rowsRead += page.getValueCount();
                ++pageID;
            }
        }

        private static void validateLastToFirst(int rowGroupID, DictionaryPage dictPage, List<DataPage> pageGroup, ColumnDescriptor desc, List<?> expectedValues) {
            int rowsLeft = expectedValues.size();
            for (int pageID = pageGroup.size() - 1; pageID >= 0; --pageID) {
                DataPage page = pageGroup.get(pageID);
                int offset = rowsLeft - page.getValueCount();
                List<?> expectedPageValues = expectedValues.subList(offset, offset + page.getValueCount());
                PageValuesValidator.validateValuesForPage(rowGroupID, pageID, dictPage, page, desc, expectedPageValues);
                rowsLeft -= page.getValueCount();
            }
        }

        private static DictionaryPage getDictionaryPageForColumn(PageReadStore pageReadStore, ColumnDescriptor columnDescriptor) {
            PageReader pageReader = pageReadStore.getPageReader(columnDescriptor);
            return pageReader.readDictionaryPage();
        }

        private static List<DataPage> getPageGroupForColumn(PageReadStore pageReadStore, ColumnDescriptor columnDescriptor) {
            DataPage page;
            PageReader pageReader = pageReadStore.getPageReader(columnDescriptor);
            ArrayList<DataPage> pageGroup = new ArrayList<DataPage>();
            while ((page = pageReader.readPage()) != null) {
                pageGroup.add(PageGroupValidator.reusableCopy(page));
            }
            return pageGroup;
        }

        private static MessageType readSchemaFromFile(Path file) throws IOException {
            ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            return metadata.getFileMetaData().getSchema();
        }

        private static List<PageReadStore> readBlocksFromFile(Path file) throws IOException {
            PageReadStore group;
            ArrayList<PageReadStore> rowGroups = new ArrayList<PageReadStore>();
            ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            ParquetFileReader fileReader = new ParquetFileReader(configuration, metadata.getFileMetaData(), file, metadata.getBlocks(), metadata.getFileMetaData().getSchema().getColumns());
            while ((group = fileReader.readNextRowGroup()) != null) {
                rowGroups.add(group);
            }
            return rowGroups;
        }
    }
}

