/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.IndexCache;
import org.apache.parquet.hadoop.NoneIndexCache;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.PrefetchIndexCache;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.util.TestFileBuilder;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIndexCache {
    private final Configuration conf = new Configuration();
    private final int numRecords = 100000;
    private final MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    private final ParquetProperties.WriterVersion writerVersion;

    @Parameterized.Parameters(name="WriterVersion = {0}, IndexCacheStrategy = {1}")
    public static Object[] parameters() {
        return new Object[]{"v1", "v2"};
    }

    public TestIndexCache(String writerVersion) {
        this.writerVersion = ParquetProperties.WriterVersion.fromString((String)writerVersion);
    }

    @Test
    public void testNoneCacheStrategy() throws IOException {
        String file = this.createTestFile("DocID");
        ParquetReadOptions options = ParquetReadOptions.builder().build();
        ParquetFileReader fileReader = new ParquetFileReader((InputFile)new LocalInputFile(Paths.get(file, new String[0])), options);
        IndexCache indexCache = IndexCache.create((ParquetFileReader)fileReader, new HashSet(), (IndexCache.CacheStrategy)IndexCache.CacheStrategy.NONE, (boolean)false);
        Assert.assertTrue((boolean)(indexCache instanceof NoneIndexCache));
        List blocks = fileReader.getFooter().getBlocks();
        for (BlockMetaData blockMetaData : blocks) {
            indexCache.setBlockMetadata(blockMetaData);
            for (ColumnChunkMetaData chunk : blockMetaData.getColumns()) {
                TestIndexCache.validateColumnIndex(fileReader.readColumnIndex(chunk), indexCache.getColumnIndex(chunk));
                TestIndexCache.validateOffsetIndex(fileReader.readOffsetIndex(chunk), indexCache.getOffsetIndex(chunk));
                Assert.assertEquals((String)"BloomFilter should match", (Object)fileReader.readBloomFilter(chunk), (Object)indexCache.getBloomFilter(chunk));
            }
        }
    }

    @Test
    public void testPrefetchCacheStrategy() throws IOException {
        String file = this.createTestFile("DocID", "Name");
        ParquetReadOptions options = ParquetReadOptions.builder().build();
        ParquetFileReader fileReader = new ParquetFileReader((InputFile)new LocalInputFile(Paths.get(file, new String[0])), options);
        HashSet<ColumnPath> columns = new HashSet<ColumnPath>();
        columns.add(ColumnPath.fromDotString((String)"DocId"));
        columns.add(ColumnPath.fromDotString((String)"Name"));
        columns.add(ColumnPath.fromDotString((String)"Gender"));
        columns.add(ColumnPath.fromDotString((String)"Links.Backward"));
        columns.add(ColumnPath.fromDotString((String)"Links.Forward"));
        IndexCache indexCache = IndexCache.create((ParquetFileReader)fileReader, columns, (IndexCache.CacheStrategy)IndexCache.CacheStrategy.PREFETCH_BLOCK, (boolean)false);
        Assert.assertTrue((boolean)(indexCache instanceof PrefetchIndexCache));
        TestIndexCache.validPrecacheIndexCache(fileReader, indexCache, columns, false);
        indexCache = IndexCache.create((ParquetFileReader)fileReader, columns, (IndexCache.CacheStrategy)IndexCache.CacheStrategy.PREFETCH_BLOCK, (boolean)true);
        Assert.assertTrue((boolean)(indexCache instanceof PrefetchIndexCache));
        TestIndexCache.validPrecacheIndexCache(fileReader, indexCache, columns, true);
    }

    private String createTestFile(String ... bloomFilterEnabledColumns) throws IOException {
        return new TestFileBuilder(this.conf, this.schema).withNumRecord(100000).withCodec("ZSTD").withRowGroupSize(0x800000L).withBloomFilterEnabled(bloomFilterEnabledColumns).withWriterVersion(this.writerVersion).build().getFileName();
    }

    private static void validPrecacheIndexCache(ParquetFileReader fileReader, IndexCache indexCache, Set<ColumnPath> columns, boolean freeCacheAfterGet) throws IOException {
        List blocks = fileReader.getFooter().getBlocks();
        for (BlockMetaData blockMetaData : blocks) {
            indexCache.setBlockMetadata(blockMetaData);
            for (ColumnChunkMetaData chunk : blockMetaData.getColumns()) {
                TestIndexCache.validateColumnIndex(fileReader.readColumnIndex(chunk), indexCache.getColumnIndex(chunk));
                TestIndexCache.validateOffsetIndex(fileReader.readOffsetIndex(chunk), indexCache.getOffsetIndex(chunk));
                Assert.assertEquals((String)"BloomFilter should match", (Object)fileReader.readBloomFilter(chunk), (Object)indexCache.getBloomFilter(chunk));
                if (!freeCacheAfterGet) continue;
                Assert.assertThrows(IllegalStateException.class, () -> indexCache.getColumnIndex(chunk));
                Assert.assertThrows(IllegalStateException.class, () -> indexCache.getOffsetIndex(chunk));
                if (!columns.contains(chunk.getPath())) continue;
                Assert.assertThrows(IllegalStateException.class, () -> indexCache.getBloomFilter(chunk));
            }
        }
    }

    private static void validateColumnIndex(ColumnIndex expected, ColumnIndex target) {
        if (expected == null) {
            Assert.assertEquals((String)"ColumnIndex should should equal", (Object)expected, (Object)target);
        } else {
            Assert.assertNotNull((String)"ColumnIndex should not be null", (Object)target);
            Assert.assertEquals(expected.getClass(), target.getClass());
            Assert.assertEquals((Object)expected.getMinValues(), (Object)target.getMinValues());
            Assert.assertEquals((Object)expected.getMaxValues(), (Object)target.getMaxValues());
            Assert.assertEquals((Object)expected.getBoundaryOrder(), (Object)target.getBoundaryOrder());
            Assert.assertEquals((Object)expected.getNullCounts(), (Object)target.getNullCounts());
            Assert.assertEquals((Object)expected.getNullPages(), (Object)target.getNullPages());
        }
    }

    private static void validateOffsetIndex(OffsetIndex expected, OffsetIndex target) {
        if (expected == null) {
            Assert.assertEquals((String)"OffsetIndex should should equal", (Object)expected, (Object)target);
        } else {
            Assert.assertNotNull((String)"OffsetIndex should not be null", (Object)target);
            Assert.assertEquals(expected.getClass(), target.getClass());
            Assert.assertEquals((Object)expected.toString(), (Object)target.toString());
        }
    }
}

