/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.rewrite;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.IndexCache;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.rewrite.MaskMode;
import org.apache.parquet.hadoop.rewrite.ParquetRewriter;
import org.apache.parquet.hadoop.rewrite.RewriteOptions;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.EncDecProperties;
import org.apache.parquet.hadoop.util.EncryptionTestFile;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.hadoop.util.TestFileBuilder;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParquetRewriterTest {
    private final int numRecord = 100000;
    private final Configuration conf = new Configuration();
    private final ParquetConfiguration parquetConf = new PlainParquetConfiguration();
    private final ParquetProperties.WriterVersion writerVersion;
    private final IndexCache.CacheStrategy indexCacheStrategy;
    private final boolean usingHadoop;
    private List<EncryptionTestFile> inputFiles = null;
    private String outputFile = null;
    private ParquetRewriter rewriter = null;

    @Parameterized.Parameters(name="WriterVersion = {0}, IndexCacheStrategy = {1}, UsingHadoop = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"v1", "NONE", true}, {"v1", "PREFETCH_BLOCK", true}, {"v2", "PREFETCH_BLOCK", true}, {"v2", "PREFETCH_BLOCK", false}};
    }

    public ParquetRewriterTest(String writerVersion, String indexCacheStrategy, boolean usingHadoop) {
        this.writerVersion = ParquetProperties.WriterVersion.fromString((String)writerVersion);
        this.indexCacheStrategy = IndexCache.CacheStrategy.valueOf((String)indexCacheStrategy);
        this.usingHadoop = usingHadoop;
    }

    private void testPruneSingleColumnTranslateCodec(List<Path> inputPaths) throws Exception {
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        List<String> pruneColumns = Collections.singletonList("Gender");
        CompressionCodecName newCodec = CompressionCodecName.ZSTD;
        RewriteOptions options = builder.prune(pruneColumns).transform(newCodec).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        this.validateSchema();
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(CompressionCodecName.ZSTD);
            }
        }, null);
        this.validateColumnData(new HashSet<String>(pruneColumns), Collections.emptySet(), null);
        this.validatePageIndex((Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(0, 0);
                this.put(1, 1);
                this.put(2, 3);
                this.put(3, 4);
            }
        });
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Before
    public void setUp() {
        this.outputFile = TestFileBuilder.createTempFile("test");
    }

    @Test
    public void testPruneSingleColumnTranslateCodecSingleFile() throws Exception {
        this.testSingleInputFileSetup("GZIP");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneSingleColumnTranslateCodecTwoFiles() throws Exception {
        this.testMultipleInputFilesSetup();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
    }

    private void testPruneNullifyTranslateCodec(List<Path> inputPaths) throws Exception {
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        List<String> pruneColumns = Collections.singletonList("Gender");
        HashMap<String, MaskMode> maskColumns = new HashMap<String, MaskMode>();
        maskColumns.put("Links.Forward", MaskMode.NULLIFY);
        final CompressionCodecName newCodec = CompressionCodecName.ZSTD;
        RewriteOptions options = builder.prune(pruneColumns).mask(maskColumns).transform(newCodec).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        this.validateSchema();
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(newCodec);
            }
        }, null);
        this.validateColumnData(new HashSet<String>(pruneColumns), maskColumns.keySet(), null);
        this.validatePageIndex((Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(0, 0);
                this.put(1, 1);
                this.put(2, 3);
            }
        });
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Test
    public void testPruneNullifyTranslateCodecSingleFile() throws Exception {
        this.testSingleInputFileSetup("GZIP");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneNullifyTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneNullifyTranslateCodecTwoFiles() throws Exception {
        this.testMultipleInputFilesSetup();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testPruneNullifyTranslateCodec((List<Path>)inputPaths);
    }

    private void testPruneEncryptTranslateCodec(List<Path> inputPaths) throws Exception {
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        List<String> pruneColumns = Collections.singletonList("Gender");
        builder.prune(pruneColumns);
        final CompressionCodecName newCodec = CompressionCodecName.ZSTD;
        builder.transform(newCodec);
        String[] encryptColumns = new String[]{"DocId"};
        FileEncryptionProperties fileEncryptionProperties = EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false);
        builder.encrypt(Arrays.asList(encryptColumns)).encryptionProperties(fileEncryptionProperties);
        builder.indexCacheStrategy(this.indexCacheStrategy);
        RewriteOptions options = builder.build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        this.validateSchema();
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(newCodec);
            }
        }, fileDecryptionProperties);
        this.validateColumnData(new HashSet<String>(pruneColumns), Collections.emptySet(), fileDecryptionProperties);
        ParquetMetadata metaData = this.getFileMetaData(this.outputFile, fileDecryptionProperties);
        Assert.assertFalse((boolean)metaData.getBlocks().isEmpty());
        List columns = ((BlockMetaData)metaData.getBlocks().get(0)).getColumns();
        HashSet<String> set = new HashSet<String>(Arrays.asList(encryptColumns));
        for (ColumnChunkMetaData column : columns) {
            if (set.contains(column.getPath().toDotString())) {
                Assert.assertTrue((boolean)column.isEncrypted());
                continue;
            }
            Assert.assertFalse((boolean)column.isEncrypted());
        }
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Test
    public void testPruneEncryptTranslateCodecSingleFile() throws Exception {
        this.testSingleInputFileSetup("GZIP");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneEncryptTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneEncryptTranslateCodecTwoFiles() throws Exception {
        this.testMultipleInputFilesSetup();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testPruneEncryptTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testRewriteWithoutColumnIndexes() throws Exception {
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(ParquetRewriterTest.class.getResource("/test-file-with-no-column-indexes-1.parquet").toURI()));
            }
        };
        this.inputFiles = inputPaths.stream().map(p -> new EncryptionTestFile(p.toString(), null)).collect(Collectors.toList());
        RewriteOptions.Builder builder = this.createBuilder((List<Path>)inputPaths);
        HashMap maskCols = Maps.newHashMap();
        maskCols.put("location.lat", MaskMode.NULLIFY);
        maskCols.put("location.lon", MaskMode.NULLIFY);
        maskCols.put("location", MaskMode.NULLIFY);
        ArrayList pruneCols = Lists.newArrayList((Object[])new String[]{"phoneNumbers"});
        RewriteOptions options = builder.mask((Map)maskCols).prune((List)pruneCols).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)3L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"id");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"name");
        Assert.assertEquals((Object)((Type)fields.get(2)).getName(), (Object)"location");
        List subFields = ((Type)fields.get(2)).asGroupType().getFields();
        Assert.assertEquals((long)subFields.size(), (long)2L);
        Assert.assertEquals((Object)((Type)subFields.get(0)).getName(), (Object)"lon");
        Assert.assertEquals((Object)((Type)subFields.get(1)).getName(), (Object)"lat");
        try (ParquetReader outReader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).build();
             ParquetReader inReader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)((Path)inputPaths.get(0))).withConf(this.conf).build();){
            Group inRead = (Group)inReader.read();
            Group outRead = (Group)outReader.read();
            while (inRead != null || outRead != null) {
                Assert.assertNotNull((Object)inRead);
                Assert.assertNotNull((Object)outRead);
                Assert.assertEquals((long)inRead.getLong("id", 0), (long)outRead.getLong("id", 0));
                Assert.assertEquals((Object)inRead.getString("name", 0), (Object)outRead.getString("name", 0));
                Group finalOutRead = outRead;
                Assert.assertThrows(RuntimeException.class, () -> finalOutRead.getGroup("location", 0).getDouble("lat", 0));
                Assert.assertThrows(RuntimeException.class, () -> finalOutRead.getGroup("location", 0).getDouble("lon", 0));
                Assert.assertThrows(InvalidRecordException.class, () -> finalOutRead.getGroup("phoneNumbers", 0));
                inRead = (Group)inReader.read();
                outRead = (Group)outReader.read();
            }
        }
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    private void testNullifyAndEncryptColumn(List<Path> inputPaths) throws Exception {
        HashMap<String, MaskMode> maskColumns = new HashMap<String, MaskMode>();
        maskColumns.put("DocId", MaskMode.NULLIFY);
        String[] encryptColumns = new String[]{"DocId"};
        FileEncryptionProperties fileEncryptionProperties = EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false);
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        RewriteOptions options = builder.mask(maskColumns).transform(CompressionCodecName.ZSTD).encrypt(Arrays.asList(encryptColumns)).encryptionProperties(fileEncryptionProperties).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(CompressionCodecName.ZSTD);
            }
        }, fileDecryptionProperties);
        this.validateColumnData(Collections.emptySet(), maskColumns.keySet(), fileDecryptionProperties);
        this.validatePageIndex((Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(1, 1);
                this.put(2, 2);
                this.put(3, 3);
                this.put(4, 4);
            }
        });
        ParquetMetadata metaData = this.getFileMetaData(this.outputFile, fileDecryptionProperties);
        Assert.assertFalse((boolean)metaData.getBlocks().isEmpty());
        HashSet<String> encryptedColumns = new HashSet<String>(Arrays.asList(encryptColumns));
        for (BlockMetaData blockMetaData : metaData.getBlocks()) {
            List columns = blockMetaData.getColumns();
            for (ColumnChunkMetaData column : columns) {
                if (encryptedColumns.contains(column.getPath().toDotString())) {
                    Assert.assertTrue((boolean)column.isEncrypted());
                    continue;
                }
                Assert.assertFalse((boolean)column.isEncrypted());
            }
        }
    }

    @Test
    public void testNullifyEncryptSingleFile() throws Exception {
        this.testSingleInputFileSetup("GZIP");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testNullifyAndEncryptColumn((List<Path>)inputPaths);
    }

    @Test
    public void testNullifyEncryptTwoFiles() throws Exception {
        this.testMultipleInputFilesSetup();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testNullifyAndEncryptColumn((List<Path>)inputPaths);
    }

    @Test
    public void testMergeTwoFilesOnly() throws Exception {
        this.testMultipleInputFilesSetup();
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            inputPaths.add(new Path(inputFile.getFileName()));
        }
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        RewriteOptions options = builder.indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        MessageType expectSchema = this.createSchema();
        Assert.assertEquals((Object)expectSchema, (Object)schema);
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(CompressionCodecName.GZIP);
                this.add(CompressionCodecName.UNCOMPRESSED);
            }
        }, null);
        this.validateColumnData(Collections.emptySet(), Collections.emptySet(), null);
        this.validatePageIndex((Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(0, 0);
                this.put(1, 1);
                this.put(2, 2);
                this.put(3, 3);
                this.put(4, 4);
            }
        });
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Test(expected=InvalidSchemaException.class)
    public void testMergeTwoFilesWithDifferentSchema() throws Exception {
        MessageType schema1 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        MessageType schema2 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender")});
        this.inputFiles = Lists.newArrayList();
        this.inputFiles.add(new TestFileBuilder(this.conf, schema1).withNumRecord(100000).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
        this.inputFiles.add(new TestFileBuilder(this.conf, schema2).withNumRecord(100000).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            inputPaths.add(new Path(inputFile.getFileName()));
        }
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        RewriteOptions options = builder.indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
    }

    @Test
    public void testRewriteFileWithMultipleBlocks() throws Exception {
        this.testSingleInputFileSetup("GZIP", 1024L, new String[0]);
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneSingleColumnTranslateCodecAndEnableBloomFilter() throws Exception {
        this.testSingleInputFileSetupWithBloomFilter("GZIP", "DocId");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters(null);
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(null);
        Assert.assertEquals(inputBloomFilters, outputBloomFilters);
    }

    @Test
    public void testPruneNullifyTranslateCodecAndEnableBloomFilter() throws Exception {
        this.testSingleInputFileSetupWithBloomFilter("GZIP", "DocId", "Links.Forward");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneNullifyTranslateCodec((List<Path>)inputPaths);
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters(null);
        Assert.assertEquals((long)inputBloomFilters.size(), (long)2L);
        Assert.assertTrue((boolean)inputBloomFilters.containsKey(ColumnPath.fromDotString((String)"Links.Forward")));
        Assert.assertTrue((boolean)inputBloomFilters.containsKey(ColumnPath.fromDotString((String)"DocId")));
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(null);
        Assert.assertEquals((long)outputBloomFilters.size(), (long)1L);
        Assert.assertTrue((boolean)outputBloomFilters.containsKey(ColumnPath.fromDotString((String)"DocId")));
        inputBloomFilters.remove(ColumnPath.fromDotString((String)"Links.Forward"));
        Assert.assertEquals(inputBloomFilters, outputBloomFilters);
    }

    @Test
    public void testPruneEncryptTranslateCodecAndEnableBloomFilter() throws Exception {
        this.testSingleInputFileSetupWithBloomFilter("GZIP", "DocId", "Links.Forward");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneEncryptTranslateCodec((List<Path>)inputPaths);
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters(null);
        Assert.assertThrows(ParquetCryptoRuntimeException.class, () -> this.allOutputBloomFilters(null));
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(fileDecryptionProperties);
        Assert.assertEquals(inputBloomFilters, outputBloomFilters);
    }

    private void testSingleInputFileSetup(String compression) throws IOException {
        this.testSingleInputFileSetup(compression, 0x8000000L, new String[0]);
    }

    private void testSingleInputFileSetupWithBloomFilter(String compression, String ... bloomFilterEnabledColumns) throws IOException {
        this.testSingleInputFileSetup(compression, 0x8000000L, bloomFilterEnabledColumns);
    }

    private void testSingleInputFileSetup(String compression, long rowGroupSize, String ... bloomFilterEnabledColumns) throws IOException {
        MessageType schema = this.createSchema();
        this.inputFiles = Lists.newArrayList();
        this.inputFiles.add(new TestFileBuilder(this.conf, schema).withNumRecord(100000).withCodec(compression).withPageSize(0x100000).withRowGroupSize(rowGroupSize).withBloomFilterEnabled(bloomFilterEnabledColumns).withWriterVersion(this.writerVersion).build());
    }

    private void testMultipleInputFilesSetup() throws IOException {
        MessageType schema = this.createSchema();
        this.inputFiles = Lists.newArrayList();
        this.inputFiles.add(new TestFileBuilder(this.conf, schema).withNumRecord(100000).withCodec("GZIP").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
        this.inputFiles.add(new TestFileBuilder(this.conf, schema).withNumRecord(100000).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
    }

    private MessageType createSchema() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.FLOAT, "FloatFraction"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "DoubleFraction"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    }

    private void validateColumnData(Set<String> prunePaths, Set<String> nullifiedPaths, FileDecryptionProperties fileDecryptionProperties) throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).withDecryption(fileDecryptionProperties).build();
        int totalRows = 0;
        for (EncryptionTestFile inputFile : this.inputFiles) {
            totalRows += inputFile.getFileContent().length;
        }
        for (int i = 0; i < totalRows; ++i) {
            Group group = (Group)reader.read();
            Assert.assertNotNull((Object)group);
            SimpleGroup expectGroup = this.inputFiles.get(i / 100000).getFileContent()[i % 100000];
            if (!prunePaths.contains("DocId")) {
                if (nullifiedPaths.contains("DocId")) {
                    Assert.assertThrows(RuntimeException.class, () -> group.getLong("DocId", 0));
                } else {
                    Assert.assertEquals((long)group.getLong("DocId", 0), (long)expectGroup.getLong("DocId", 0));
                }
            }
            if (!prunePaths.contains("Name") && !nullifiedPaths.contains("Name")) {
                Assert.assertArrayEquals((byte[])group.getBinary("Name", 0).getBytes(), (byte[])expectGroup.getBinary("Name", 0).getBytes());
            }
            if (!prunePaths.contains("Gender") && !nullifiedPaths.contains("Gender")) {
                Assert.assertArrayEquals((byte[])group.getBinary("Gender", 0).getBytes(), (byte[])expectGroup.getBinary("Gender", 0).getBytes());
            }
            if (!prunePaths.contains("FloatFraction") && !nullifiedPaths.contains("FloatFraction")) {
                Assert.assertEquals((float)group.getFloat("FloatFraction", 0), (float)expectGroup.getFloat("FloatFraction", 0), (float)0.0f);
            }
            if (!prunePaths.contains("DoubleFraction") && !nullifiedPaths.contains("DoubleFraction")) {
                Assert.assertEquals((double)group.getDouble("DoubleFraction", 0), (double)expectGroup.getDouble("DoubleFraction", 0), (double)0.0);
            }
            Group subGroup = group.getGroup("Links", 0);
            if (!prunePaths.contains("Links.Backward") && !nullifiedPaths.contains("Links.Backward")) {
                Assert.assertArrayEquals((byte[])subGroup.getBinary("Backward", 0).getBytes(), (byte[])expectGroup.getGroup("Links", 0).getBinary("Backward", 0).getBytes());
            }
            if (prunePaths.contains("Links.Forward")) continue;
            if (nullifiedPaths.contains("Links.Forward")) {
                Assert.assertThrows(RuntimeException.class, () -> subGroup.getBinary("Forward", 0));
                continue;
            }
            Assert.assertArrayEquals((byte[])subGroup.getBinary("Forward", 0).getBytes(), (byte[])expectGroup.getGroup("Links", 0).getBinary("Forward", 0).getBytes());
        }
        reader.close();
    }

    private ParquetMetadata getFileMetaData(String file, FileDecryptionProperties fileDecryptionProperties) throws IOException {
        ParquetReadOptions readOptions = ParquetReadOptions.builder().withDecryption(fileDecryptionProperties).build();
        ParquetMetadata pmd = null;
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)new Path(file), (Configuration)this.conf);
        try (SeekableInputStream in = inputFile.newStream();){
            pmd = ParquetFileReader.readFooter((InputFile)inputFile, (ParquetReadOptions)readOptions, (SeekableInputStream)in);
        }
        return pmd;
    }

    private void verifyCodec(String file, Set<CompressionCodecName> expectedCodecs, FileDecryptionProperties fileDecryptionProperties) throws IOException {
        HashSet<CompressionCodecName> codecs = new HashSet<CompressionCodecName>();
        ParquetMetadata pmd = this.getFileMetaData(file, fileDecryptionProperties);
        for (int i = 0; i < pmd.getBlocks().size(); ++i) {
            BlockMetaData block = (BlockMetaData)pmd.getBlocks().get(i);
            for (int j = 0; j < block.getColumns().size(); ++j) {
                ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)block.getColumns().get(j);
                codecs.add(columnChunkMetaData.getCodec());
            }
        }
        Assert.assertEquals(expectedCodecs, codecs);
    }

    private void validatePageIndex(Map<Integer, Integer> outFileColumnMapping) throws Exception {
        ParquetMetadata outMetaData = this.getFileMetaData(this.outputFile, null);
        int inputFileIndex = 0;
        CompressionConverter.TransParquetFileReader inReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(this.inputFiles.get(inputFileIndex).getFileName()), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());
        ParquetMetadata inMetaData = inReader.getFooter();
        try (CompressionConverter.TransParquetFileReader outReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(this.outputFile), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());){
            int outBlockId = 0;
            int inBlockId = 0;
            while (outBlockId < outMetaData.getBlocks().size()) {
                if (inBlockId == inMetaData.getBlocks().size()) {
                    inReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(this.inputFiles.get(++inputFileIndex).getFileName()), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());
                    inMetaData = inReader.getFooter();
                    inBlockId = 0;
                }
                BlockMetaData inBlockMetaData = (BlockMetaData)inMetaData.getBlocks().get(inBlockId);
                BlockMetaData outBlockMetaData = (BlockMetaData)outMetaData.getBlocks().get(outBlockId);
                Assert.assertEquals((long)inBlockMetaData.getRowCount(), (long)outBlockMetaData.getRowCount());
                for (int j = 0; j < outBlockMetaData.getColumns().size(); ++j) {
                    if (!outFileColumnMapping.containsKey(j)) continue;
                    int columnIdFromInputFile = outFileColumnMapping.get(j);
                    ColumnChunkMetaData inChunk = (ColumnChunkMetaData)inBlockMetaData.getColumns().get(columnIdFromInputFile);
                    ColumnIndex inColumnIndex = inReader.readColumnIndex(inChunk);
                    OffsetIndex inOffsetIndex = inReader.readOffsetIndex(inChunk);
                    ColumnChunkMetaData outChunk = (ColumnChunkMetaData)outBlockMetaData.getColumns().get(j);
                    ColumnIndex outColumnIndex = outReader.readColumnIndex(outChunk);
                    OffsetIndex outOffsetIndex = outReader.readOffsetIndex(outChunk);
                    if (inColumnIndex != null) {
                        Assert.assertEquals((Object)inColumnIndex.getBoundaryOrder(), (Object)outColumnIndex.getBoundaryOrder());
                        Assert.assertEquals((Object)inColumnIndex.getMaxValues(), (Object)outColumnIndex.getMaxValues());
                        Assert.assertEquals((Object)inColumnIndex.getMinValues(), (Object)outColumnIndex.getMinValues());
                        Assert.assertEquals((Object)inColumnIndex.getNullCounts(), (Object)outColumnIndex.getNullCounts());
                    }
                    if (inOffsetIndex == null) continue;
                    List<Long> inOffsets = this.getOffsets(inReader, inChunk);
                    List<Long> outOffsets = this.getOffsets(outReader, outChunk);
                    Assert.assertEquals((long)inOffsets.size(), (long)outOffsets.size());
                    Assert.assertEquals((long)inOffsets.size(), (long)inOffsetIndex.getPageCount());
                    Assert.assertEquals((long)inOffsetIndex.getPageCount(), (long)outOffsetIndex.getPageCount());
                    for (int k = 0; k < inOffsetIndex.getPageCount(); ++k) {
                        Assert.assertEquals((long)inOffsetIndex.getFirstRowIndex(k), (long)outOffsetIndex.getFirstRowIndex(k));
                        Assert.assertEquals((long)inOffsetIndex.getLastRowIndex(k, inBlockMetaData.getRowCount()), (long)outOffsetIndex.getLastRowIndex(k, outBlockMetaData.getRowCount()));
                        Assert.assertEquals((long)inOffsetIndex.getOffset(k), (long)inOffsets.get(k));
                        Assert.assertEquals((long)outOffsetIndex.getOffset(k), (long)outOffsets.get(k));
                    }
                }
                ++outBlockId;
                ++inBlockId;
            }
        }
    }

    private List<Long> getOffsets(CompressionConverter.TransParquetFileReader reader, ColumnChunkMetaData chunk) throws IOException {
        ArrayList<Long> offsets = new ArrayList<Long>();
        reader.setStreamPosition(chunk.getStartingPos());
        long readValues = 0L;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            long curOffset = reader.getPos();
            PageHeader pageHeader = reader.readPageHeader();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    this.rewriter.readBlock(pageHeader.getCompressed_page_size(), reader);
                    continue block5;
                }
                case DATA_PAGE: {
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    offsets.add(curOffset);
                    this.rewriter.readBlock(pageHeader.getCompressed_page_size(), reader);
                    readValues += (long)headerV1.getNum_values();
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    offsets.add(curOffset);
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    this.rewriter.readBlock(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    this.rewriter.readBlock(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    this.rewriter.readBlock(payLoadLength, reader);
                    readValues += (long)headerV2.getNum_values();
                    continue block5;
                }
            }
            throw new IOException("Not recognized page type");
        }
        return offsets;
    }

    private void validateCreatedBy() throws Exception {
        HashSet<String> createdBySet = new HashSet<String>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            ParquetMetadata pmd = this.getFileMetaData(inputFile.getFileName(), null);
            createdBySet.add(pmd.getFileMetaData().getCreatedBy());
            Assert.assertNull(pmd.getFileMetaData().getKeyValueMetaData().get("original.created.by"));
        }
        Object[] inputCreatedBys = createdBySet.toArray();
        Assert.assertEquals((long)1L, (long)inputCreatedBys.length);
        FileMetaData outFMD = this.getFileMetaData(this.outputFile, null).getFileMetaData();
        String createdBy = outFMD.getCreatedBy();
        Assert.assertNotNull((Object)createdBy);
        Assert.assertEquals((Object)createdBy, (Object)"parquet-mr version 1.14.3 (build b5e376a2caee767a11e75b783512b14cf8ca90ec)");
        String inputCreatedBy = (String)inputCreatedBys[0];
        String originalCreatedBy = (String)outFMD.getKeyValueMetaData().get("original.created.by");
        Assert.assertEquals((Object)inputCreatedBy, (Object)originalCreatedBy);
    }

    private void validateRowGroupRowCount() throws Exception {
        ArrayList<Long> inputRowCounts = new ArrayList<Long>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            ParquetMetadata inputPmd = this.getFileMetaData(inputFile.getFileName(), null);
            for (BlockMetaData blockMetaData : inputPmd.getBlocks()) {
                inputRowCounts.add(blockMetaData.getRowCount());
            }
        }
        ArrayList<Long> outputRowCounts = new ArrayList<Long>();
        ParquetMetadata outPmd = this.getFileMetaData(this.outputFile, null);
        for (BlockMetaData blockMetaData : outPmd.getBlocks()) {
            outputRowCounts.add(blockMetaData.getRowCount());
        }
        Assert.assertEquals(inputRowCounts, outputRowCounts);
    }

    private Map<ColumnPath, List<BloomFilter>> allInputBloomFilters(FileDecryptionProperties fileDecryptionProperties) throws Exception {
        HashMap<ColumnPath, List<BloomFilter>> inputBloomFilters = new HashMap<ColumnPath, List<BloomFilter>>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            Map<ColumnPath, List<BloomFilter>> bloomFilters = this.allBloomFilters(inputFile.getFileName(), fileDecryptionProperties);
            for (Map.Entry<ColumnPath, List<BloomFilter>> entry : bloomFilters.entrySet()) {
                List bloomFilterList = inputBloomFilters.getOrDefault(entry.getKey(), new ArrayList());
                bloomFilterList.addAll((Collection)entry.getValue());
                inputBloomFilters.put(entry.getKey(), bloomFilterList);
            }
        }
        return inputBloomFilters;
    }

    private Map<ColumnPath, List<BloomFilter>> allOutputBloomFilters(FileDecryptionProperties fileDecryptionProperties) throws Exception {
        return this.allBloomFilters(this.outputFile, fileDecryptionProperties);
    }

    private Map<ColumnPath, List<BloomFilter>> allBloomFilters(String path, FileDecryptionProperties fileDecryptionProperties) throws Exception {
        HashMap<ColumnPath, List<BloomFilter>> allBloomFilters = new HashMap<ColumnPath, List<BloomFilter>>();
        ParquetReadOptions readOptions = ParquetReadOptions.builder().withDecryption(fileDecryptionProperties).build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)new Path(path), (Configuration)this.conf);
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader((InputFile)inputFile, readOptions);){
            ParquetMetadata metadata = reader.getFooter();
            for (BlockMetaData blockMetaData : metadata.getBlocks()) {
                for (ColumnChunkMetaData columnChunkMetaData : blockMetaData.getColumns()) {
                    BloomFilter bloomFilter = reader.readBloomFilter(columnChunkMetaData);
                    if (bloomFilter == null) continue;
                    List bloomFilterList = allBloomFilters.getOrDefault(columnChunkMetaData.getPath(), new ArrayList());
                    bloomFilterList.add(bloomFilter);
                    allBloomFilters.put(columnChunkMetaData.getPath(), bloomFilterList);
                }
            }
        }
        return allBloomFilters;
    }

    private RewriteOptions.Builder createBuilder(List<Path> inputPaths) throws IOException {
        RewriteOptions.Builder builder;
        if (this.usingHadoop) {
            Path outputPath = new Path(this.outputFile);
            builder = new RewriteOptions.Builder(this.conf, inputPaths, outputPath);
        } else {
            HadoopOutputFile outputPath = HadoopOutputFile.fromPath((Path)new Path(this.outputFile), (Configuration)this.conf);
            List inputs = inputPaths.stream().map(p -> HadoopInputFile.fromPathUnchecked((Path)p, (Configuration)this.conf)).collect(Collectors.toList());
            builder = new RewriteOptions.Builder(this.parquetConf, inputs, (OutputFile)outputPath);
        }
        return builder;
    }

    private void validateSchema() throws IOException {
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)5L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"DocId");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"Name");
        Assert.assertEquals((Object)((Type)fields.get(2)).getName(), (Object)"FloatFraction");
        Assert.assertEquals((Object)((Type)fields.get(3)).getName(), (Object)"DoubleFraction");
        Assert.assertEquals((Object)((Type)fields.get(4)).getName(), (Object)"Links");
        List subFields = ((Type)fields.get(4)).asGroupType().getFields();
        Assert.assertEquals((long)subFields.size(), (long)2L);
        Assert.assertEquals((Object)((Type)subFields.get(0)).getName(), (Object)"Backward");
        Assert.assertEquals((Object)((Type)subFields.get(1)).getName(), (Object)"Forward");
    }
}

