/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Float16;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFloat16Statistics {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Binary[] valuesInAscendingOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesInAscendingOrderMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesInDescendingOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, 124}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{0, -4})};
    private Binary[] valuesInDescendingOrderMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesUndefinedOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, -4})};
    private Binary[] valuesUndefinedOrderMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesAllPositiveZero = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0})};
    private Binary[] valuesAllPositiveStatsZeroMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0})};
    private Binary[] valuesAllNegativeZero = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128})};
    private Binary[] valuesAllNegativeStatsZeroMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0})};
    private Binary[] valuesWithNaN = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 126})};
    private Binary[] valuesWithNaNStatsMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128})};

    @Test
    public void testFloat16StatisticsMultipleCases() throws IOException {
        List testValues = Arrays.asList(this.valuesInAscendingOrder, this.valuesInDescendingOrder, this.valuesUndefinedOrder, this.valuesAllPositiveZero, this.valuesAllNegativeZero, this.valuesWithNaN);
        List expectedValues = Arrays.asList(this.valuesInAscendingOrderMinMax, this.valuesInDescendingOrderMinMax, this.valuesUndefinedOrderMinMax, this.valuesAllPositiveStatsZeroMinMax, this.valuesAllNegativeStatsZeroMinMax, this.valuesWithNaNStatsMinMax);
        for (int i = 0; i < testValues.size(); ++i) {
            MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.float16Type())).length(2)).named("col_float16")).named("msg");
            Configuration conf = new Configuration();
            GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
            SimpleGroupFactory factory = new SimpleGroupFactory(schema);
            Path path = this.newTempPath();
            try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withConf(conf)).withDictionaryEncoding(false)).build();){
                for (Binary value : (Binary[])testValues.get(i)) {
                    writer.write((Object)factory.newGroup().append("col_float16", value));
                }
            }
            var9_9 = null;
            try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
                ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
                Statistics statistics = column.getStatistics();
                Assert.assertArrayEquals((byte[])((Binary[])expectedValues.get(i))[0].getBytes(), (byte[])statistics.getMinBytes());
                Assert.assertArrayEquals((byte[])((Binary[])expectedValues.get(i))[1].getBytes(), (byte[])statistics.getMaxBytes());
                continue;
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testFloat16Statistics() throws IOException {
        for (int i = 0; i < this.valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < this.valuesInAscendingOrder.length; ++j) {
                int minIndex = i;
                int maxIndex = j;
                if (Float16.compare((short)this.valuesInAscendingOrder[i].get2BytesLittleEndian(), (short)this.valuesInAscendingOrder[j].get2BytesLittleEndian()) > 0) {
                    minIndex = j;
                    maxIndex = i;
                }
                if (this.valuesInAscendingOrder[minIndex].get2BytesLittleEndian() == 0) {
                    minIndex = 3;
                }
                if (this.valuesInAscendingOrder[maxIndex].get2BytesLittleEndian() == Short.MIN_VALUE) {
                    maxIndex = 4;
                }
                MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.float16Type())).length(2)).named("col_float16")).named("msg");
                Configuration conf = new Configuration();
                GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
                SimpleGroupFactory factory = new SimpleGroupFactory(schema);
                Path path = this.newTempPath();
                try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withConf(conf)).withDictionaryEncoding(false)).build();){
                    writer.write((Object)factory.newGroup().append("col_float16", this.valuesInAscendingOrder[i]));
                    writer.write((Object)factory.newGroup().append("col_float16", this.valuesInAscendingOrder[j]));
                }
                var10_10 = null;
                try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
                    ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
                    Statistics statistics = column.getStatistics();
                    Assert.assertArrayEquals((byte[])this.valuesInAscendingOrder[minIndex].getBytes(), (byte[])statistics.getMinBytes());
                    Assert.assertArrayEquals((byte[])this.valuesInAscendingOrder[maxIndex].getBytes(), (byte[])statistics.getMaxBytes());
                    continue;
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
            }
        }
    }

    private Path newTempPath() throws IOException {
        File file = this.temp.newFile();
        Preconditions.checkArgument((boolean)file.delete(), (String)"Could not remove temp file");
        return new Path(file.getAbsolutePath());
    }
}

