/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import com.google.common.io.Files;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupFactory;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMultipleWriteRead {
    private static final MessageType SCHEMA = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.BaseListBuilder.ElementBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).named("id")).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)false))).named("phone_numbers")).optional(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("comment")).named("msg");
    private static final Comparator<Binary> BINARY_COMPARATOR = ((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("dummy")).comparator();
    private static Path tmpDir;

    @BeforeClass
    public static void createTmpDir() {
        tmpDir = new Path(Files.createTempDir().getAbsolutePath().toString());
    }

    @AfterClass
    public static void deleteTmpDir() throws IOException {
        tmpDir.getFileSystem(new Configuration()).delete(tmpDir, true);
    }

    private Path writeFile(Iterable<Group> data) throws IOException {
        Path file = new Path(tmpDir, "testMultipleReadWrite_" + UUID.randomUUID() + ".parquet");
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).config("parquet.example.schema", SCHEMA.toString())).build();){
            for (Group group : data) {
                writer.write((Object)group);
            }
        }
        return file;
    }

    private void validateFile(Path file, List<Group> data) throws IOException {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();){
            for (Group group : data) {
                Assert.assertEquals((Object)group.toString(), (Object)((Group)reader.read()).toString());
            }
        }
    }

    private void validateFile(Path file, FilterCompat.Filter filter, Stream<Group> data) throws IOException {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withFilter(filter).build();){
            Iterator it = data.iterator();
            while (it.hasNext()) {
                Assert.assertEquals((Object)((Group)it.next()).toString(), (Object)((Group)reader.read()).toString());
            }
        }
    }

    private void validateFileWithIdFilter(Path file, List<Group> data) throws IOException {
        this.validateFile(file, FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"id"), (Comparable)Integer.valueOf(0))), data.stream().filter(group -> group.getInteger("id", 0) == 0));
    }

    private void validateFileWithCommentFilter(Path file, List<Group> data) throws IOException {
        this.validateFile(file, FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"comment"), null)), data.stream().filter(group -> group.getFieldRepetitionCount("comment") == 0));
    }

    private void validateFileWithComplexFilter(Path file, List<Group> data) throws IOException {
        Binary binaryValueB = Binary.fromString((String)"b");
        FilterCompat.Filter filter = FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"id"), (Comparable)Integer.valueOf(0)), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)binaryValueB), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"comment"), null))));
        Predicate<Group> predicate = group -> group.getInteger("id", 0) >= 0 && BINARY_COMPARATOR.compare(group.getBinary("name", 0), binaryValueB) < 0 && group.getFieldRepetitionCount("comment") > 0;
        this.validateFile(file, filter, data.stream().filter(predicate));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWriteRead() throws Throwable {
        void var6_11;
        ArrayList data = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            data.add(Stream.generate(new DataGenerator(i)).limit(10000 - i * 1000).collect(Collectors.toList()));
        }
        ArrayList<Future<Path>> futureFiles = new ArrayList<Future<Path>>();
        ExecutorService exec = Executors.newFixedThreadPool(6);
        for (List list : data) {
            futureFiles.add(exec.submit(() -> {
                Path file = this.writeFile(list);
                this.validateFile(file, list);
                return file;
            }));
        }
        ArrayList files = new ArrayList();
        for (Future future : futureFiles) {
            try {
                files.add(future.get());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }
        ArrayList<Future<Object>> arrayList = new ArrayList<Future<Object>>();
        boolean bl = false;
        while (var6_11 < 10) {
            Path path = (Path)files.get((int)var6_11);
            List d = (List)data.get((int)var6_11);
            arrayList.add(exec.submit(() -> {
                this.validateFileWithIdFilter(file, d);
                return null;
            }));
            arrayList.add(exec.submit(() -> {
                this.validateFileWithCommentFilter(file, d);
                return null;
            }));
            arrayList.add(exec.submit(() -> {
                this.validateFileWithComplexFilter(file, d);
                return null;
            }));
            ++var6_11;
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    static /* synthetic */ MessageType access$000() {
        return SCHEMA;
    }

    private static class DataGenerator
    implements Supplier<Group> {
        private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz -";
        private static final int NAME_MIN_SIZE = 5;
        private static final int NAME_MAX_SIZE = 30;
        private static final int PHONE_NUMBERS_MAX_SIZE = 5;
        private static final long MIN_PHONE_NUMBER = 361000000L;
        private static final long MAX_PHONE_NUMBER = 361999999L;
        private static final double COMMENT_NULL_RATIO = 0.3;
        private static final int COMMENT_MAX_SIZE = 200;
        private final Random random;
        private final GroupFactory factory = new SimpleGroupFactory(TestMultipleWriteRead.access$000());

        DataGenerator(long seed) {
            this.random = new Random(seed);
        }

        private String getString(int minSize, int maxSize) {
            int size = this.random.nextInt(maxSize - minSize) + minSize;
            StringBuilder builder = new StringBuilder(size);
            for (int i = 0; i < size; ++i) {
                builder.append(ALPHABET.charAt(this.random.nextInt(ALPHABET.length())));
            }
            return builder.toString();
        }

        @Override
        public Group get() {
            Group group = this.factory.newGroup();
            group.add("id", this.random.nextInt());
            group.add("name", this.getString(5, 30));
            Group phoneNumbers = group.addGroup("phone_numbers");
            int n = this.random.nextInt(5);
            for (int i = 0; i < n; ++i) {
                Group phoneNumber = phoneNumbers.addGroup(0);
                phoneNumber.add(0, this.random.nextLong() % 999999L + 361000000L);
            }
            if (this.random.nextDouble() >= 0.3) {
                group.add("comment", this.getString(0, 200));
            }
            return group;
        }
    }
}

