/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.openhft.hashing.LongHashFunction;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.TestUtils;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriter {
    private TrackingByteBufferAllocator allocator;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Before
    public void initAllocator() {
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @After
    public void closeAllocator() {
        this.allocator.close();
    }

    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        Path root = new Path("target/tests/TestParquetWriter/");
        TestUtils.enforceEmptyDir(conf, root);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(3) flba_field; required int96 int96_field; } ");
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        HashMap<String, Encoding> expected = new HashMap<String, Encoding>();
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN);
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.RLE_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.DELTA_BYTE_ARRAY);
        for (int modulo : Arrays.asList(10, 1000)) {
            for (ParquetProperties.WriterVersion version : ParquetProperties.WriterVersion.values()) {
                Path file = new Path(root, version.name() + "_" + modulo);
                ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new TestOutputFile(file, conf)).withAllocator((ByteBufferAllocator)this.allocator)).withCompressionCodec(CompressionCodecName.UNCOMPRESSED)).withRowGroupSize(1024)).withPageSize(1024)).withDictionaryPageSize(512)).enableDictionaryEncoding()).withValidation(false)).withWriterVersion(version)).withConf(conf)).build();
                for (int i = 0; i < 1000; ++i) {
                    writer.write((Object)f.newGroup().append("binary_field", "test" + i % modulo).append("int32_field", 32).append("int64_field", 64L).append("boolean_field", true).append("float_field", 1.0f).append("double_field", 2.0).append("flba_field", "foo").append("int96_field", Binary.fromConstantByteArray((byte[])new byte[12])));
                }
                writer.close();
                ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).build();
                for (int i = 0; i < 1000; ++i) {
                    Group group = (Group)reader.read();
                    Assert.assertEquals((Object)("test" + i % modulo), (Object)group.getBinary("binary_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((long)32L, (long)group.getInteger("int32_field", 0));
                    Assert.assertEquals((long)64L, (long)group.getLong("int64_field", 0));
                    Assert.assertEquals((Object)true, (Object)group.getBoolean("boolean_field", 0));
                    Assert.assertEquals((double)1.0, (double)group.getFloat("float_field", 0), (double)0.001);
                    Assert.assertEquals((double)2.0, (double)group.getDouble("double_field", 0), (double)0.001);
                    Assert.assertEquals((Object)"foo", (Object)group.getBinary("flba_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((Object)Binary.fromConstantByteArray((byte[])new byte[12]), (Object)group.getInt96("int96_field", 0));
                }
                reader.close();
                ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                for (BlockMetaData blockMetaData : footer.getBlocks()) {
                    for (ColumnChunkMetaData column : blockMetaData.getColumns()) {
                        if (!column.getPath().toDotString().equals("binary_field")) continue;
                        String key = modulo + "-" + version;
                        Encoding expectedEncoding = (Encoding)expected.get(key);
                        Assert.assertTrue((String)(key + ":" + column.getEncodings() + " should contain " + expectedEncoding), (boolean)column.getEncodings().contains(expectedEncoding));
                    }
                }
                Assert.assertEquals((String)"Object model property should be example", (Object)"example", footer.getFileMetaData().getKeyValueMetaData().get("writer.model.name"));
            }
        }
    }

    @Test
    public void testBadWriteSchema() throws IOException {
        File file = this.temp.newFile("test.parquet");
        file.delete();
        TestUtils.assertThrows("Should reject a schema with an empty group", InvalidSchemaException.class, () -> {
            ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(file.toString())).withAllocator((ByteBufferAllocator)this.allocator)).withType((MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)new GroupType(Type.Repetition.REQUIRED, "invalid_group", new Type[0]))).named("invalid_message")).build();
            return null;
        });
        Assert.assertFalse((String)"Should not create a file when schema is rejected", (boolean)file.exists());
    }

    @Test
    public void testNullValuesWithPageRowLimit() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.BaseListBuilder.ElementBuilder)Types.buildMessage().optionalList().optionalElement(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("str_list")).named("msg");
        int recordCount = 100;
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Group listNull = factory.newGroup();
        File file = this.temp.newFile();
        file.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withAllocator((ByteBufferAllocator)this.allocator)).withPageRowCountLimit(10)).withConf(conf)).build();){
            for (int i = 0; i < 100; ++i) {
                writer.write((Object)listNull);
            }
        }
        var9_9 = null;
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)path).build();){
            int readRecordCount = 0;
            Group group = (Group)reader.read();
            while (group != null) {
                Assert.assertEquals((Object)listNull.toString(), (Object)group.toString());
                ++readRecordCount;
                group = (Group)reader.read();
            }
            Assert.assertEquals((String)"Number of written records should be equal to the read one", (long)100L, (long)readRecordCount);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testParquetFileWithBloomFilter() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        String[] testNames = new String[]{"hello", "parquet", "bloom", "filter"};
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        File file = this.temp.newFile();
        file.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withAllocator((ByteBufferAllocator)this.allocator)).withPageRowCountLimit(10)).withConf(conf)).withDictionaryEncoding(false)).withBloomFilterEnabled("name", true)).build();){
            for (String testName : testNames) {
                writer.write((Object)factory.newGroup().append("name", testName));
            }
        }
        var8_8 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            BlockMetaData blockMetaData = (BlockMetaData)reader.getFooter().getBlocks().get(0);
            BloomFilter bloomFilter = reader.getBloomFilterDataReader(blockMetaData).readBloomFilter((ColumnChunkMetaData)blockMetaData.getColumns().get(0));
            for (String name : testNames) {
                Assert.assertTrue((boolean)bloomFilter.findHash(LongHashFunction.xx((long)0L).hashBytes(Binary.fromString((String)name).toByteBuffer())));
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testParquetFileWithBloomFilterWithFpp() throws IOException {
        int buildBloomFilterCount = 100000;
        double[] testFpps = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.25};
        int randomStrLen = 12;
        int testBloomFilterCount = 200000;
        HashSet<String> distinctStringsForFileGenerate = new HashSet<String>();
        while (distinctStringsForFileGenerate.size() < buildBloomFilterCount) {
            String str = RandomStringUtils.randomAlphabetic((int)randomStrLen);
            distinctStringsForFileGenerate.add(str);
        }
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        for (double testFpp : testFpps) {
            File file = this.temp.newFile();
            file.delete();
            Path path = new Path(file.getAbsolutePath());
            try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withAllocator((ByteBufferAllocator)this.allocator)).withPageRowCountLimit(10)).withConf(conf)).withDictionaryEncoding(false)).withBloomFilterEnabled("name", true)).withBloomFilterNDV("name", (long)buildBloomFilterCount)).withBloomFilterFPP("name", testFpp)).build();){
                for (String str : distinctStringsForFileGenerate) {
                    writer.write((Object)factory.newGroup().append("name", str));
                }
            }
            var17_16 = null;
            try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
                BlockMetaData blockMetaData = (BlockMetaData)reader.getFooter().getBlocks().get(0);
                BloomFilter bloomFilter = reader.getBloomFilterDataReader(blockMetaData).readBloomFilter((ColumnChunkMetaData)blockMetaData.getColumns().get(0));
                int falsePositive = 0;
                HashSet<String> distinctStringsForProbe = new HashSet<String>();
                while (distinctStringsForProbe.size() < 200000) {
                    String str = RandomStringUtils.randomAlphabetic((int)(randomStrLen - 1));
                    if (!distinctStringsForProbe.add(str) || !bloomFilter.findHash(LongHashFunction.xx((long)0L).hashBytes(Binary.fromString((String)str).toByteBuffer()))) continue;
                    ++falsePositive;
                }
                double expectedFalsePositiveMaxCount = Math.floor(200000.0 * (testFpp * 1.15));
                Assert.assertTrue(((double)falsePositive < expectedFalsePositiveMaxCount && falsePositive > 0 ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                var17_16 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testBloomFilterMaxBytesSize() throws IOException {
        HashSet<String> distinctStrings = new HashSet<String>();
        while (distinctStrings.size() < 1000) {
            String str = RandomStringUtils.randomAlphabetic((int)10);
            distinctStrings.add(str);
        }
        int maxBloomFilterBytes = 0x100001;
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        File file = this.temp.newFile();
        file.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withAllocator((ByteBufferAllocator)this.allocator)).withConf(conf)).withDictionaryEncoding(false)).withBloomFilterEnabled("name", true)).withMaxBloomFilterBytes(maxBloomFilterBytes)).build();){
            Iterator iterator = distinctStrings.iterator();
            while (iterator.hasNext()) {
                writer.write((Object)factory.newGroup().append("name", (String)iterator.next()));
            }
        }
        var9_10 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            BlockMetaData blockMetaData = (BlockMetaData)reader.getFooter().getBlocks().get(0);
            BloomFilter bloomFilter = reader.getBloomFilterDataReader(blockMetaData).readBloomFilter((ColumnChunkMetaData)blockMetaData.getColumns().get(0));
            Assert.assertEquals((long)bloomFilter.getBitsetSize(), (long)maxBloomFilterBytes);
        }
        catch (Throwable throwable) {
            var9_10 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testParquetFileWritesExpectedNumberOfBlocks() throws IOException {
        this.testParquetFileNumberOfBlocks(100, 10000, 1);
        this.testParquetFileNumberOfBlocks(1, 1, 3);
    }

    @Test
    public void testExtraMetaData() throws Exception {
        Configuration conf = new Configuration();
        File testDir = this.temp.newFile();
        testDir.delete();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 int32_field; }");
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        for (ParquetProperties.WriterVersion version : ParquetProperties.WriterVersion.values()) {
            Path filePath = new Path(testDir.getAbsolutePath(), version.name());
            ParquetWriter writer = ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new TestOutputFile(filePath, conf)).withConf(conf)).withExtraMetaData((Map)ImmutableMap.of((Object)"simple-key", (Object)"some-value-1", (Object)"nested.key", (Object)"some-value-2")).build();
            for (int i = 0; i < 1000; ++i) {
                writer.write((Object)f.newGroup().append("int32_field", 32));
            }
            writer.close();
            ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)filePath, (Configuration)new Configuration()));
            Assert.assertEquals((long)1000L, (long)reader.readNextRowGroup().getRowCount());
            Assert.assertEquals((Object)ImmutableMap.of((Object)"simple-key", (Object)"some-value-1", (Object)"nested.key", (Object)"some-value-2", (Object)"writer.model.name", (Object)"example"), (Object)reader.getFileMetaData().getKeyValueMetaData());
            reader.close();
        }
    }

    @Test
    public void testFailsOnConflictingExtraMetaDataKey() throws Exception {
        Configuration conf = new Configuration();
        File testDir = this.temp.newFile();
        testDir.delete();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 int32_field; }");
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        for (ParquetProperties.WriterVersion version : ParquetProperties.WriterVersion.values()) {
            Path filePath = new Path(testDir.getAbsolutePath(), version.name());
            Assert.assertThrows(IllegalArgumentException.class, () -> ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new TestOutputFile(filePath, conf)).withConf(conf)).withExtraMetaData((Map)ImmutableMap.of((Object)"writer.model.name", (Object)"some-value-3")).build());
        }
    }

    private void testParquetFileNumberOfBlocks(int minRowCountForPageSizeCheck, int maxRowCountForPageSizeCheck, int expectedNumberOfBlocks) throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("str")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        File file = this.temp.newFile();
        this.temp.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withAllocator((ByteBufferAllocator)this.allocator)).withConf(conf)).withRowGroupSize(1)).withMinRowCountForPageSizeCheck(minRowCountForPageSizeCheck)).withMaxRowCountForPageSizeCheck(maxRowCountForPageSizeCheck)).build();){
            SimpleGroupFactory factory = new SimpleGroupFactory(schema);
            writer.write((Object)factory.newGroup().append("str", "foo"));
            writer.write((Object)factory.newGroup().append("str", "bar"));
            writer.write((Object)factory.newGroup().append("str", "baz"));
        }
        var9_9 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)conf));){
            ParquetMetadata footer = reader.getFooter();
            Assert.assertEquals((long)expectedNumberOfBlocks, (long)footer.getBlocks().size());
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSizeStatisticsControl() throws Exception {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).named("string_field")).required(PrimitiveType.PrimitiveTypeName.BOOLEAN).named("boolean_field")).required(PrimitiveType.PrimitiveTypeName.INT32).named("int32_field")).named("test_schema");
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Group group = factory.newGroup().append("string_field", "test").append("boolean_field", true).append("int32_field", 42);
        File file = this.temp.newFile();
        this.temp.delete();
        Path path = new Path(file.getAbsolutePath());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withType(schema).withSizeStatisticsEnabled(false)).build();){
            writer.write((Object)group);
        }
        var7_7 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            for (BlockMetaData block : reader.getFooter().getBlocks()) {
                for (ColumnChunkMetaData column : block.getColumns()) {
                    Assert.assertNull((Object)column.getSizeStatistics());
                }
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        file = this.temp.newFile();
        this.temp.delete();
        path = new Path(file.getAbsolutePath());
        writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withType(schema).withSizeStatisticsEnabled(true)).withSizeStatisticsEnabled("boolean_field", false)).build();
        var7_7 = null;
        try {
            writer.write((Object)group);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var7_7 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
        reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));
        var7_7 = null;
        try {
            for (BlockMetaData block : reader.getFooter().getBlocks()) {
                for (ColumnChunkMetaData column : block.getColumns()) {
                    if (column.getPath().toDotString().equals("boolean_field")) {
                        Assert.assertNull((Object)column.getSizeStatistics());
                        continue;
                    }
                    Assert.assertTrue((boolean)column.getSizeStatistics().isValid());
                }
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var7_7 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    private static class TestOutputFile
    implements OutputFile {
        private final OutputFile outputFile;

        TestOutputFile(Path path, Configuration conf) throws IOException {
            this.outputFile = HadoopOutputFile.fromPath((Path)path, (Configuration)conf);
        }

        public PositionOutputStream create(long blockSizeHint) throws IOException {
            return this.outputFile.create(blockSizeHint);
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
            return this.outputFile.createOrOverwrite(blockSizeHint);
        }

        public boolean supportsBlockSize() {
            return this.outputFile.supportsBlockSize();
        }

        public long defaultBlockSize() {
            return this.outputFile.defaultBlockSize();
        }
    }
}

