/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.filter2.recordlevel.PhoneBookWriter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.codec.CleanUtil;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.LocalOutputFile;
import org.apache.parquet.io.OutputFile;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriterError {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testInSeparateProcess() throws IOException, InterruptedException {
        String outputFile = this.tmpFolder.newFile("out.parquet").toString();
        String classpath = System.getProperty("java.class.path");
        String javaPath = Paths.get(System.getProperty("java.home"), "bin", "java").toAbsolutePath().toString();
        Process process = new ProcessBuilder(new String[0]).command(javaPath, "-cp", classpath, Main.class.getName(), outputFile).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
        Assert.assertEquals((String)"Test process exited with a non-zero return code. See previous logs for details.", (long)0L, (long)process.waitFor());
    }

    public static class Main {
        private static final Random RANDOM;
        private static final Field BUFFER_ADDRESS;

        private static Group generateNext() {
            HashMap<String, Double> accounts;
            ArrayList<PhoneBookWriter.PhoneNumber> phoneNumbers;
            double chance = RANDOM.nextDouble();
            PhoneBookWriter.Location location = chance < 0.45 ? new PhoneBookWriter.Location(RANDOM.nextDouble(), RANDOM.nextDouble()) : (chance < 0.9 ? new PhoneBookWriter.Location(RANDOM.nextDouble(), null) : null);
            if (RANDOM.nextDouble() < 0.1) {
                phoneNumbers = null;
                accounts = null;
            } else {
                int n = RANDOM.nextInt(4);
                phoneNumbers = new ArrayList<PhoneBookWriter.PhoneNumber>(n);
                accounts = new HashMap<String, Double>();
                for (int i = 0; i < n; ++i) {
                    String kind = RANDOM.nextDouble() < 0.1 ? null : "kind" + RANDOM.nextInt(5);
                    phoneNumbers.add(new PhoneBookWriter.PhoneNumber(RANDOM.nextInt(), kind));
                    accounts.put("Account " + i, Double.valueOf(i));
                }
            }
            String name = RANDOM.nextDouble() < 0.1 ? null : "name" + RANDOM.nextLong();
            PhoneBookWriter.User user = new PhoneBookWriter.User(RANDOM.nextLong(), name, phoneNumbers, location, accounts);
            return PhoneBookWriter.groupFromUser(user);
        }

        private static TrackingByteBufferAllocator createAllocator(final int oomAt) {
            return TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new DirectByteBufferAllocator(){
                private int counter = 0;

                public ByteBuffer allocate(int size) {
                    if (++this.counter >= oomAt) {
                        Assert.assertEquals((String)"There should not be any additional allocations after an OOM", (long)oomAt, (long)this.counter);
                        throw new OutOfMemoryError("Artificial OOM to fail write");
                    }
                    return super.allocate(size);
                }

                public void release(ByteBuffer b) {
                    CleanUtil.cleanDirectBuffer((ByteBuffer)b);
                    try {
                        if (BUFFER_ADDRESS != null) {
                            BUFFER_ADDRESS.setLong(b, 0L);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Unable to zero direct ByteBuffer address", e);
                    }
                }
            });
        }

        public static void main(String[] args) throws Throwable {
            CompressionCodecName[] codecs = new CompressionCodecName[]{CompressionCodecName.UNCOMPRESSED, CompressionCodecName.GZIP, CompressionCodecName.SNAPPY, CompressionCodecName.ZSTD, CompressionCodecName.LZ4_RAW};
            for (int cycle = 0; cycle < 50; ++cycle) {
                try (TrackingByteBufferAllocator allocator = Main.createAllocator(RANDOM.nextInt(100) + 1);
                     ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new LocalOutputFile(Paths.get(args[0], new String[0]))).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withType(PhoneBookWriter.getSchema()).withAllocator((ByteBufferAllocator)allocator)).withCodecFactory((CompressionCodecFactory)CodecFactory.createDirectCodecFactory((Configuration)new Configuration(), (ByteBufferAllocator)allocator, (int)0x100000))).withCompressionCodec(codecs[RANDOM.nextInt(codecs.length)])).build();){
                    for (int i = 0; i < 100000; ++i) {
                        writer.write((Object)Main.generateNext());
                    }
                    Assert.fail((String)"An OOM should have been thrown");
                    continue;
                }
                catch (OutOfMemoryError oom) {
                    Throwable[] suppressed = oom.getSuppressed();
                    if (suppressed == null || suppressed.length <= 0) continue;
                    throw suppressed[0];
                }
            }
        }

        static {
            Field bufferAddress;
            RANDOM = new Random(202402271420L);
            try {
                Class<?> bufferClass = Class.forName("java.nio.Buffer");
                bufferAddress = bufferClass.getDeclaredField("address");
                bufferAddress.setAccessible(true);
            }
            catch (Exception e) {
                bufferAddress = null;
            }
            BUFFER_ADDRESS = bufferAddress;
        }
    }
}

