/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ResourceIntensiveTestRule;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class TestLargeColumnChunk {
    private static final MessageType SCHEMA = (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(new Type[]{(Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("id"), (Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("data")})).named("schema");
    private static final int DATA_SIZE = 256;
    private static final int ROW_COUNT = 8389607;
    private static final long RANDOM_SEED = 42L;
    private static final int ID_INDEX = SCHEMA.getFieldIndex("id");
    private static final int DATA_INDEX = SCHEMA.getFieldIndex("data");
    private static final long ID_OF_FILTERED_DATA = 4194803L;
    private static Binary VALUE_IN_DATA;
    private static Binary VALUE_NOT_IN_DATA;
    private static Path file;
    @ClassRule
    public static TestRule maySkip;
    @ClassRule
    public static TemporaryFolder folder;

    @BeforeClass
    public static void createFile() throws IOException {
        file = new Path(folder.newFile().getAbsolutePath());
        SimpleGroupFactory factory = new SimpleGroupFactory(SCHEMA);
        Random random = new Random(42L);
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)SCHEMA, (Configuration)conf);
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)HadoopOutputFile.fromPath((Path)file, (Configuration)conf)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withConf(conf)).withCompressionCodec(CompressionCodecName.UNCOMPRESSED)).withRowGroupSize(0x100000000L)).withBloomFilterEnabled(true)).build();){
            for (long id = 0L; id < 8389607L; ++id) {
                Group group = factory.newGroup();
                group.add(ID_INDEX, id);
                Binary data = TestLargeColumnChunk.nextBinary(random);
                group.add(DATA_INDEX, data);
                writer.write((Object)group);
                if (id != 4194803L) continue;
                VALUE_IN_DATA = data;
            }
        }
        VALUE_NOT_IN_DATA = TestLargeColumnChunk.nextBinary(random);
    }

    private static Binary nextBinary(Random random) {
        byte[] bytes = new byte[256];
        random.nextBytes(bytes);
        return Binary.fromConstantByteArray((byte[])bytes);
    }

    @Test
    public void validateAllData() throws IOException {
        Random random = new Random(42L);
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();){
            for (long id = 0L; id < 8389607L; ++id) {
                Group group = (Group)reader.read();
                Assert.assertEquals((long)id, (long)group.getLong(ID_INDEX, 0));
                Assert.assertEquals((Object)TestLargeColumnChunk.nextBinary(random), (Object)group.getBinary(DATA_INDEX, 0));
            }
            Assert.assertNull((String)"No more record should be read", (Object)reader.read());
        }
    }

    @Test
    public void validateFiltering() throws IOException {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withFilter(FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"data"), (Comparable)VALUE_IN_DATA))).build();){
            Group group = (Group)reader.read();
            Assert.assertEquals((long)4194803L, (long)group.getLong(ID_INDEX, 0));
            Assert.assertEquals((Object)VALUE_IN_DATA, (Object)group.getBinary(DATA_INDEX, 0));
            Assert.assertNull((String)"No more record should be read", (Object)reader.read());
        }
        reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withFilter(FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"data"), (Comparable)VALUE_NOT_IN_DATA))).build();
        var2_2 = null;
        try {
            Assert.assertNull((String)"No record should be read", (Object)reader.read());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var2_2 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    static {
        maySkip = ResourceIntensiveTestRule.get();
        folder = new TemporaryFolder();
    }
}

