/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.junit.Assert;
import org.junit.Test;

public class CodecConfigTest {
    @Test
    public void testReadingCodecs() throws IOException {
        this.shouldUseParquetFlagToSetCodec("gzip", CompressionCodecName.GZIP);
        this.shouldUseHadoopFlagToSetCodec(CompressionCodecName.GZIP.getHadoopCompressionCodecClassName(), CompressionCodecName.GZIP);
        this.shouldUseParquetFlagToSetCodec("snappy", CompressionCodecName.SNAPPY);
        this.shouldUseHadoopFlagToSetCodec(CompressionCodecName.SNAPPY.getHadoopCompressionCodecClassName(), CompressionCodecName.SNAPPY);
        this.shouldUseHadoopFlagToSetCodec("unexistedCodec", CompressionCodecName.UNCOMPRESSED);
        this.shouldUseHadoopFlagToSetCodec("org.apache.hadoop.io.compress.DefaultCodec", CompressionCodecName.UNCOMPRESSED);
    }

    public void shouldUseParquetFlagToSetCodec(String codecNameStr, CompressionCodecName expectedCodec) throws IOException {
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        conf.set("parquet.compression", codecNameStr);
        TaskAttemptContext task = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)new TaskAttemptID(new TaskID(new JobID("test", 1), false, 1), 1));
        Assert.assertEquals((Object)CodecConfig.from((TaskAttemptContext)task).getCodec(), (Object)expectedCodec);
        JobConf jobConf = new JobConf();
        jobConf.set("parquet.compression", codecNameStr);
        Assert.assertEquals((Object)CodecConfig.from((JobConf)jobConf).getCodec(), (Object)expectedCodec);
    }

    public void shouldUseHadoopFlagToSetCodec(String codecClassStr, CompressionCodecName expectedCodec) throws IOException {
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", codecClassStr);
        TaskAttemptContext task = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)new TaskAttemptID(new TaskID(new JobID("test", 1), false, 1), 1));
        Assert.assertEquals((Object)expectedCodec, (Object)CodecConfig.from((TaskAttemptContext)task).getCodec());
        JobConf jobConf = new JobConf();
        jobConf.setBoolean("mapred.output.compress", true);
        jobConf.set("mapred.output.compression.codec", codecClassStr);
        Assert.assertEquals((Object)CodecConfig.from((JobConf)jobConf).getCodec(), (Object)expectedCodec);
    }
}

