/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.metadata;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import shaded.parquet.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.parquet.com.fasterxml.jackson.databind.ObjectWriter;
import shaded.parquet.com.fasterxml.jackson.databind.SerializationFeature;

public class ParquetMetadata {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;

    public static String toJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, false);
    }

    public static String toPrettyJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, true);
    }

    private static String toJSON(ParquetMetadata parquetMetaData, boolean isPrettyPrint) {
        String string;
        StringWriter stringWriter = new StringWriter();
        try {
            Object objectToPrint = parquetMetaData.getFileMetaData() == null || parquetMetaData.getFileMetaData().getEncryptionType() == FileMetaData.EncryptionType.UNENCRYPTED ? parquetMetaData : parquetMetaData.getFileMetaData();
            ObjectWriter writer = isPrettyPrint ? objectMapper.writerWithDefaultPrettyPrinter() : objectMapper.writer();
            writer.writeValue((Writer)stringWriter, objectToPrint);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stringWriter.close();
        return string;
    }

    public static ParquetMetadata fromJSON(String json) {
        try {
            return (ParquetMetadata)objectMapper.readValue((Reader)new StringReader(json), ParquetMetadata.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParquetMetadata(FileMetaData fileMetaData, List<BlockMetaData> blocks) {
        this.fileMetaData = fileMetaData;
        this.blocks = blocks;
    }

    public List<BlockMetaData> getBlocks() {
        return this.blocks;
    }

    public FileMetaData getFileMetaData() {
        return this.fileMetaData;
    }

    public String toString() {
        return "ParquetMetaData{" + String.valueOf(this.fileMetaData) + ", blocks: " + String.valueOf(this.blocks) + "}";
    }
}

