/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hive.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.hive.internal.AbstractHiveBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive010Binding
extends AbstractHiveBinding {
    private static final Logger LOG = LoggerFactory.getLogger(Hive010Binding.class);
    private final Map<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<String, PartitionDesc>();
    private MapredWork mrwork;

    private void init(JobConf job) {
        String plan = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN);
        if (this.mrwork == null && plan != null && plan.length() > 0) {
            this.mrwork = Utilities.getMapRedWork((Configuration)job);
            this.pathToPartitionInfo.clear();
            for (Map.Entry entry : this.mrwork.getPathToPartitionInfo().entrySet()) {
                this.pathToPartitionInfo.put(new Path((String)entry.getKey()).toUri().getPath().toString(), (PartitionDesc)entry.getValue());
            }
        }
    }

    private void pushProjectionsAndFilters(JobConf jobConf, String splitPath, String splitPathWithNoSchema) {
        if (this.mrwork == null) {
            LOG.debug("Not pushing projections and filters because MapredWork is null");
            return;
        }
        if (this.mrwork.getPathToAliases() == null) {
            LOG.debug("Not pushing projections and filters because pathToAliases is null");
            return;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Map.Entry entry : this.mrwork.getPathToAliases().entrySet()) {
            String key = new Path((String)entry.getKey()).toUri().getPath();
            if (!splitPath.equals(key) && !splitPathWithNoSchema.equals(key)) continue;
            ArrayList list = (ArrayList)entry.getValue();
            for (String val : list) {
                aliases.add(val);
            }
        }
        for (String alias : aliases) {
            Operator op = (Operator)this.mrwork.getAliasToWork().get(alias);
            if (op == null || !(op instanceof TableScanOperator)) continue;
            TableScanOperator tableScan = (TableScanOperator)op;
            ArrayList list = tableScan.getNeededColumnIDs();
            if (list != null) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobConf, (List)list);
            } else {
                ColumnProjectionUtils.setFullyReadColumns((Configuration)jobConf);
            }
            this.pushFilters(jobConf, tableScan);
        }
    }

    private void pushFilters(JobConf jobConf, TableScanOperator tableScan) {
        TableScanDesc scanDesc = (TableScanDesc)tableScan.getConf();
        if (scanDesc == null) {
            LOG.debug("Not pushing filters because TableScanDesc is null");
            return;
        }
        Utilities.setColumnNameList((JobConf)jobConf, (Operator)tableScan);
        ExprNodeDesc filterExpr = scanDesc.getFilterExpr();
        if (filterExpr == null) {
            LOG.debug("Not pushing filters because FilterExpr is null");
            return;
        }
        String filterText = filterExpr.getExprString();
        String filterExprSerialized = Utilities.serializeExpression((ExprNodeDesc)filterExpr);
        jobConf.set("hive.io.filter.text", filterText);
        jobConf.set("hive.io.filter.expr.serialized", filterExprSerialized);
    }

    public JobConf pushProjectionsAndFilters(JobConf jobConf, Path path) throws IOException {
        this.init(jobConf);
        JobConf cloneJobConf = new JobConf((Configuration)jobConf);
        PartitionDesc part = this.pathToPartitionInfo.get(path.toString());
        if (part != null && part.getTableDesc() != null) {
            Utilities.copyTableJobPropertiesToConf((TableDesc)part.getTableDesc(), (JobConf)cloneJobConf);
        }
        this.pushProjectionsAndFilters(cloneJobConf, path.toString(), path.toUri().toString());
        return cloneJobConf;
    }
}

